/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec;

import com.medset.hardware.ambulant.livetec.LiveecgDeviceDataExport;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.padsy.PadsyException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatFileInputStream
extends InputStream {
    private static Logger logger = Logger.getLogger(DatFileInputStream.class.getName());
    private byte[] remainingBuffer;
    private byte[] localBuffer;
    private int localBufferOffset;
    private int localBytesPosition;
    public final int BLOCK_MAX_SIZE = 32768;
    private LiveecgDeviceDataExport cardDataExport;

    public DatFileInputStream(LiveecgDeviceDataExport cardDataExport) {
        this.cardDataExport = cardDataExport;
        this.localBufferOffset = 0;
        this.localBuffer = new byte[32768];
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Reset not supported.");
    }

    private boolean readNext() throws PadsyException {
        boolean retval = false;
        if (this.localBufferOffset == 0) {
            while (this.localBufferOffset < this.localBuffer.length) {
                if (this.remainingBuffer != null) {
                    System.arraycopy(this.remainingBuffer, 0, this.localBuffer, this.localBufferOffset, this.remainingBuffer.length);
                    this.localBufferOffset += this.remainingBuffer.length;
                    this.remainingBuffer = null;
                    retval = true;
                }
                byte[] data = this.cardDataExport.next();
                logger.log(Level.FINE, "readNext data.length <" + data.length + "> localBuffer.length <" + this.localBuffer.length + ">");
                if (data.length > this.localBuffer.length) {
                    throw new PadsyException(LiveecgDeviceDriver.DRIVER_TEXT.getText("error.device.wrongDataLength"), 12);
                }
                if (data.length <= 0) break;
                int readBytes = Math.min(this.localBuffer.length - this.localBufferOffset, data.length);
                System.arraycopy(data, 0, this.localBuffer, this.localBufferOffset, readBytes);
                this.localBufferOffset += readBytes;
                if (readBytes < data.length) {
                    this.remainingBuffer = new byte[data.length - readBytes];
                    System.arraycopy(data, readBytes, this.remainingBuffer, 0, this.remainingBuffer.length);
                    logger.log(Level.FINE, "readNext remainingBuffer.length  : " + this.remainingBuffer.length);
                }
                retval = true;
                logger.log(Level.FINE, "readNext localBytesAvailable  : " + this.localBufferOffset);
            }
            this.localBytesPosition = 0;
        }
        return retval;
    }

    @Override
    public int read() throws IOException {
        int retval = -1;
        try {
            if (this.readNext()) {
                retval = this.localBuffer[this.localBytesPosition++] & 0xFF;
                --this.localBufferOffset;
            }
        }
        catch (PadsyException e) {
            throw new IOException(e.getMessage());
        }
        return retval;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

