/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec;

import com.medset.database.Patient;
import com.medset.database.datfile.DatFileInputStream;
import com.medset.database.datfile.DatFileManager;
import com.medset.ecg.filter.IoFilter;
import com.medset.hardware.DeviceException;
import com.medset.hardware.ambulant.DataSourceIterator;
import com.medset.hardware.ambulant.holter.HolterReadProgress;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileImport;
import com.medset.padsy.PadsyException;
import com.medset.util.progress.ProgressView;
import com.medset.util.progress.ProgressViewPanel;
import java.awt.Component;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class LiveecgDeviceDataExport
extends LiveecgFileImport
implements DataSourceIterator {
    private static Logger logger = Logger.getLogger(LiveecgDeviceDataExport.class.getName());
    private LiveecgDeviceDriver liveecgDeviceDriver;
    private ProgressView progressView;
    private JLabel infoTextLabel;
    private JProgressBar progressBar;
    private boolean endOfRecording;
    private int segmentCnt = 0;
    private long splitOfRecordingInMs = 172800000L;
    private long msHasRead = 0L;
    private long msRead = 0L;
    private int totalSlices = 0;
    private int oldSliceCnt = 0;
    private int sliceCnt = 1;
    private int sliceLengthAtWork = 0;
    private long startTime = 0L;
    protected Hashtable<String, String> parameter;

    public LiveecgDeviceDataExport(LiveecgDeviceDriver liveecgDeviceDriver, HolterReadProgress readProgress) {
        super(liveecgDeviceDriver, readProgress);
        this.liveecgDeviceDriver = liveecgDeviceDriver;
    }

    private void setInfoTextLabel() {
        Component[] componentArray = ((ProgressViewPanel)this.progressView).getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JProgressBar) {
                this.progressBar = (JProgressBar)c;
                break;
            }
            ++n2;
        }
    }

    private int getNextSliceLengthInMs(long read) {
        int retlen = (int)(this.liveecgDeviceDriver.getTotalRecordingLengthInMs() - read);
        return (int)((long)retlen >= this.splitOfRecordingInMs ? this.splitOfRecordingInMs : (long)retlen);
    }

    public int liveecgToDat(DatFileManager datfilemanager, IoFilter iofilter, Patient patient, ProgressView progressView, int splitofrecordinginms, int totalrecordinglength, long starttime, int totalslices, int filepos, int totalfiles) throws DeviceException {
        try {
            this.totalSlices = totalslices;
            this.startTime = starttime;
            if (this.msRead >= this.splitOfRecordingInMs) {
                this.msHasRead += this.msRead;
                this.sliceLengthAtWork = this.getNextSliceLengthInMs(this.msHasRead);
                this.msRead = 0L;
                ++this.sliceCnt;
                DatFileInputStream datFileInputStream = new DatFileInputStream((DataSourceIterator)this, iofilter);
                datfilemanager.newEntry("EKG-16", this.parameter, (InputStream)datFileInputStream);
                int n = this.sliceLengthAtWork;
                return n;
            }
            try {
                this.msHasRead = 0L;
                this.msRead = 0L;
                this.segmentCnt = 0;
                this.progressView = progressView;
                this.splitOfRecordingInMs = splitofrecordinginms;
                this.setInfoTextLabel();
                this.liveecgDeviceDriver.setComponents(this.infoTextLabel, this.progressBar);
                this.parameter = new Hashtable();
                logger.info("\u00a7 Header <" + this.liveecgDeviceDriver.isHeaderOk() + ">; connected <" + this.liveecgDeviceDriver.isConnected() + "> Split <" + this.splitOfRecordingInMs + " ms>");
                this.liveecgDeviceDriver.setAnalyseOk(false);
                progressView.setInfoText("Analyse <" + DateFormat.getDateInstance().format(new Date(starttime)) + "> " + LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.pos") + " <" + filepos + "/" + totalfiles + ">");
                this.liveecgDeviceDriver.resetLastFileResult();
                while (this.liveecgDeviceDriver.next(false)) {
                }
                if (!this.liveecgDeviceDriver.isHeaderOk()) {
                    logger.severe("Header of Livetec ECG file not valid!");
                    this.liveecgDeviceDriver.ejectVolume();
                    this.liveecgDeviceDriver.setConnected(false);
                    throw new DeviceException(this.liveecgDeviceDriver.getErrors());
                }
                this.parameter = this.setupParameters(iofilter);
                this.liveecgDeviceDriver.setAnalyseOk(true);
                logger.info("\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7 Analyse of files completed. Start Import of Data.");
                this.endOfRecording = false;
                iofilter.setOverflowType(this.liveecgDeviceDriver.getOverFlowType());
                this.sliceLengthAtWork = (int)(this.liveecgDeviceDriver.getTotalRecordingLengthInMs() >= this.splitOfRecordingInMs ? this.splitOfRecordingInMs : this.liveecgDeviceDriver.getTotalRecordingLengthInMs());
                DatFileInputStream datFileInputStream = new DatFileInputStream((DataSourceIterator)this, iofilter);
                datfilemanager.newEntry("EKG-16", this.parameter, (InputStream)datFileInputStream);
            }
            catch (PadsyException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw new DeviceException(e.getMessage());
            }
        }
        finally {
            this.liveecgDeviceDriver.release();
        }
        return this.sliceLengthAtWork;
    }

    public boolean isEndOfRecording() {
        logger.info("\u00a7 EOF Recording <" + this.endOfRecording + ">");
        return this.endOfRecording;
    }

    public void close() {
        logger.info("\u00a7 Close Recording after setting status to read.");
        this.liveecgDeviceDriver.setStatusRead();
        this.endOfRecording = true;
    }

    public byte[] next() throws DeviceException {
        if (this.segmentCnt == 0 || this.oldSliceCnt != this.sliceCnt) {
            logger.info("\u00a7\u00a7\u00a7 TotalRecordingLengthInMs <" + this.sliceLengthAtWork + " of " + this.liveecgDeviceDriver.getTotalRecordingLengthInMs() + ">");
            this.liveecgDeviceDriver.initProgress(this.sliceLengthAtWork);
            String dauer = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.dauer");
            String vom = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.from");
            this.progressView.setInfoText(" <" + this.sliceCnt + "/" + this.totalSlices + "> " + dauer + " <" + LiveecgDeviceDriver.getMsInHrsMins(this.sliceLengthAtWork) + "> " + vom + " <" + DateFormat.getDateInstance().format(new Date(this.startTime)) + ">");
            this.oldSliceCnt = this.sliceCnt;
        }
        byte[] result = new byte[]{};
        if (this.msRead >= this.splitOfRecordingInMs) {
            return result;
        }
        int blocks2read = 13;
        long newms = this.msRead + this.liveecgDeviceDriver.getMs4BlockCnt(blocks2read);
        if (newms > this.splitOfRecordingInMs) {
            long msleft = this.splitOfRecordingInMs - this.msRead;
            blocks2read = this.liveecgDeviceDriver.getBlockCnt4Ms(msleft);
        }
        result = this.liveecgDeviceDriver.getReadData(blocks2read);
        this.msRead += this.liveecgDeviceDriver.getMs4ByteCnt(result.length);
        this.liveecgDeviceDriver.updateProgress((int)this.msRead);
        boolean bl = this.endOfRecording = this.msHasRead + this.msRead >= this.liveecgDeviceDriver.getTotalRecordingLengthInMs();
        if (this.endOfRecording) {
            logger.info("\u00a7\u00a7\u00a7 EORECORDING  <" + this.msRead + "> \u00a7");
            this.progressView.setInfoText("Aufnahme Import beendet. O.K.");
        }
        if (result.length == 0) {
            logger.info("\u00a7\u00a7\u00a7 EOF Result length <0> \u00a7");
        } else {
            ++this.segmentCnt;
        }
        return result;
    }
}

