/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec;

import com.medset.cardiolight.CardiolightText;
import com.medset.cardiolight.sdk.livetec.liveecg.LiveecgDeviceDriverInterface;
import com.medset.database.Patient;
import com.medset.ecg.ableitung.Ableitung;
import com.medset.ecg.ableitung.AbleitungsFactory;
import com.medset.ecg.ableitung.AbleitungsSystem;
import com.medset.graphics.PadsyFont;
import com.medset.graphics.TableLayout;
import com.medset.hardware.CardDriverService;
import com.medset.hardware.CardDummyInterface;
import com.medset.hardware.Device;
import com.medset.hardware.DeviceException;
import com.medset.hardware.DeviceInfoPanel;
import com.medset.hardware.DeviceSetupPanel;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.Interface;
import com.medset.hardware.ambulant.AmbulantDeviceDataListener;
import com.medset.hardware.ambulant.AmbulantDeviceInfo;
import com.medset.hardware.ambulant.Battery;
import com.medset.hardware.ambulant.PatientInfo;
import com.medset.hardware.ambulant.RecordingInfo;
import com.medset.hardware.ambulant.Storage;
import com.medset.hardware.ambulant.assistent.AmbulantDeviceAssistant;
import com.medset.hardware.ambulant.assistent.AssistantFrame;
import com.medset.hardware.ambulant.assistent.AssistantStep;
import com.medset.hardware.ambulant.assistent.RecordPanel;
import com.medset.hardware.ambulant.holter.CardReader;
import com.medset.hardware.ambulant.holter.HolterAmbulantDevice;
import com.medset.hardware.ambulant.holter.HolterAmbulantDeviceDriver;
import com.medset.hardware.ambulant.holter.HolterAmbulantDeviceInfo;
import com.medset.hardware.ambulant.holter.HolterReadProgress;
import com.medset.hardware.ambulant.holter.HolterRecordingInfo;
import com.medset.hardware.ambulant.holter.HolterStartConfiguration;
import com.medset.hardware.ambulant.holter.HolterStartProgress;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceReadProgress;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileWorker;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import com.medset.hardware.ambulant.livetec.view.LiveecgExceptionView;
import com.medset.hardware.ambulant.livetec.view.device.LiveecgDeviceConfigPanel;
import com.medset.hardware.ambulant.livetec.view.device.LongRecordingsSettingsPanel;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgSelectPatientListDialog;
import com.medset.hardware.ambulant.livetec.view.recording.LiveecgRecordingsDialog;
import com.medset.install.ConfigDevice;
import com.medset.nativecode.media.RemovableMedia;
import com.medset.oem.OemManager;
import com.medset.padsy.Energizer;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyException;
import com.medset.padsy.PadsySession;
import com.medset.padsy.PadsyText;
import com.medset.util.ArtefactInfo;
import com.medset.util.Praktisch;
import com.medset.util.Semaphore;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LiveecgDeviceDriver
extends LiveecgFileWorker
implements HolterAmbulantDeviceDriver,
CardReader,
LiveecgDeviceDriverInterface {
    private static Logger logger = Logger.getLogger(LiveecgDeviceDriver.class.getName());
    public static DriverBundle DRIVER_TEXT = new DriverBundle(LiveecgDeviceDriver.class);
    public static final int SPLIT_24_HOUR = 86400000;
    public static final int SPLIT_48_HOUR = 172800000;
    private static final String DRIVE_STRING_KEY = "drivename";
    private static final String NO_VALUE_STRING = "-NO-VALUE-";
    private static final String LIVEECG_PREFIX = "LiveECG_";
    public static final String OSX_DRIVE_NAME = String.valueOf(File.separator) + "Volumes" + File.separator + "MEDSET_ATA";
    private static final String DEVICEDRIVER_NAME = DRIVER_TEXT.getFormattedText("company.driverFor", (Object)"LIVETEC ECG");
    private static final String VENDOR_NAME = OemManager.getOemHandler().getVendorName();
    private static final String GDT_EXAMINATION_TYPE = "EKG04";
    private static final String LIVEECG_DAT_FILE_NAME = "liveECG_0.00";
    private static final String SPLIT_PROPERTY = "LongRecordingsSplitInMS";
    private static final String AUTOCALC_PROPERTY = "Autocalc";
    private static final String SMALL_ICON_NAME = "LivetecSmallIcon.jpg";
    private static final String ICON_NAME = "LivetecIcon.jpg";
    private static ImageIcon SMALL_ICON = null;
    private static ImageIcon ICON = null;
    private static final double[][] LAYOUT_INFO_PANEL = new double[][]{{-2.0, 12.0, -2.0}, {17.0, 3.0, 17.0, -1.0, -2.0}};
    private String driveName = "-NO-VALUE-";
    private ArtefactInfo artefactInfo = ArtefactInfo.getArtefactInfo((String)"Livetec");
    private ConfigDevice configDevice;
    private CardDummyInterface cardDummyInterface;
    private int splitOfLongRecordingsInMs = 86400000;
    private boolean autoCalc = false;
    LiveecgDeviceReadProgress liveecgDeviceReadProgress = null;
    private boolean removable = false;
    DeviceSetupPanel[] deviceSetupPanels = new DeviceSetupPanel[3];
    private JLabel stateInfoLabel = null;
    private PatientInfo patientInfo = null;
    private boolean connected = false;
    private boolean cardRemoved = false;
    private RemovableMedia removableMedia = null;
    private String serialNumber = "-NO-VALUE-";
    private final Semaphore available = new Semaphore();
    private PadsySession padsySession;
    private AmbulantDeviceAssistant ambulantDeviceAssistant = null;
    private Patient gdtPatient = null;
    private boolean useGdtPatient = false;
    RecordPanel recordPanel = null;

    public LiveecgDeviceDriver() {
        this.cardDummyInterface = new CardDummyInterface(this.driveName, DRIVER_TEXT.getText("device.holter.cardTitle"));
    }

    public LiveecgDeviceDriver(ConfigDevice configDevice) {
        this.init(configDevice);
    }

    public LiveecgDeviceDriver(String driveName) {
        this.driveName = driveName;
        this.cardDummyInterface = new CardDummyInterface(driveName, DRIVER_TEXT.getText("device.holter.cardTitle"));
    }

    public LiveecgDeviceDriver(ConfigDevice configDevice, String driveName) {
        this.driveName = driveName;
        this.init(configDevice);
    }

    private void init(ConfigDevice configDevice) {
        this.configDevice = configDevice;
        this.loadConfig(configDevice);
        this.cardDummyInterface = new CardDummyInterface(this.driveName, DRIVER_TEXT.getText("device.holter.cardTitle"));
    }

    public File getVoiceMessage() {
        return null;
    }

    public boolean hasVoiceMessage() {
        return false;
    }

    public HolterRecordingInfo getRecordingInfo() throws DeviceException {
        this.patientInfo = this.getPatientInfo();
        HolterRecordingInfo holterRecordingInfo = new HolterRecordingInfo(this.patientInfo, this.getStartDate() != null ? this.getStartDate() : new Date(), (int)(this.getTotalRecordingLengthInMs() <= 0L ? 10000L : this.getTotalRecordingLengthInMs()), this.getLeadSystem(), this.hasPacemakerSpikeDetection(), this.getRecordingState(), this.getBreakCode(), this.getRecNr());
        if (this.hasVoiceMessage()) {
            holterRecordingInfo.setVoiceMessage(this.getVoiceMessage());
        }
        return holterRecordingInfo;
    }

    public PatientInfo getPatientInfo() {
        String idNumber = this.getPatientId();
        String lastname = this.getPatientLastName();
        String firstname = this.getPatientFirstName();
        Date birthdate = this.getPatientBirthDate();
        return new PatientInfo(idNumber, firstname, lastname, birthdate);
    }

    @Override
    public Patient getPatient() {
        if (this.useGdtPatient) {
            return this.gdtPatient;
        }
        return this.patient;
    }

    @Override
    public String getPatientId() {
        if (this.useGdtPatient) {
            return this.gdtPatient.getPatientId();
        }
        return super.getPatientId();
    }

    @Override
    public String getPatientLastName() {
        if (this.useGdtPatient) {
            return this.gdtPatient.getLastname();
        }
        return super.getPatientLastName();
    }

    @Override
    public String getPatientFirstName() {
        if (this.useGdtPatient) {
            return this.gdtPatient.getFirstname();
        }
        return super.getPatientFirstName();
    }

    @Override
    public Date getPatientBirthDate() {
        if (this.useGdtPatient) {
            return this.gdtPatient.getBirthdate();
        }
        return super.getPatientBirthDate();
    }

    public AbleitungsSystem getLeadSystem() throws DeviceException {
        Ableitung[] ableitung = new Ableitung[]{AbleitungsFactory.getAbleitung((int)22), AbleitungsFactory.getAbleitung((int)23), AbleitungsFactory.getAbleitung((int)24)};
        return new AbleitungsSystem("LIVEECG-Ableitungen", ableitung);
    }

    private int getRecordingState() {
        int recstate = 0;
        if (this.connected && this.isHeaderOk()) {
            recstate = this.hasBeenRead() ? 3 : 2;
        }
        logger.fine("Recording state <" + recstate + ">; connected <" + this.connected + ">; isheader <" + this.isHeaderOk() + ">");
        return recstate;
    }

    private int getBreakCode() {
        return this.getAbortCode();
    }

    private String getRecNr() {
        return "LIVEECG";
    }

    @Override
    public int getSplitOfLongRecordingsInMs() {
        return this.splitOfLongRecordingsInMs;
    }

    protected void acquire() {
        try {
            logger.finest("\u00a7 acquire start");
            this.available.acquire();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "wait interrupted", e);
        }
    }

    protected void release() {
        logger.finest("\u00a7 release start");
        this.available.release();
    }

    private void loadConfig(ConfigDevice configDevice) {
        if (Praktisch.isOSX()) {
            this.driveName = this.driveName == NO_VALUE_STRING ? OSX_DRIVE_NAME : this.driveName;
        } else {
            this.driveName = configDevice.getParameter(DRIVE_STRING_KEY, NO_VALUE_STRING);
            this.autoCalc = Boolean.parseBoolean(configDevice.getParameter(AUTOCALC_PROPERTY, "false"));
        }
        this.splitOfLongRecordingsInMs = Integer.parseInt(configDevice.getParameter(SPLIT_PROPERTY, String.valueOf(86400000)));
    }

    private void saveConfig(ConfigDevice configDevice) {
        this.splitOfLongRecordingsInMs = (int)((LongRecordingsSettingsPanel)this.deviceSetupPanels[2]).getSplitOfLongRecordingsInMs();
        if (!Praktisch.isOSX()) {
            configDevice.setParameter(DRIVE_STRING_KEY, this.driveName);
            configDevice.setParameter(SPLIT_PROPERTY, String.valueOf(this.splitOfLongRecordingsInMs));
            configDevice.setParameter(AUTOCALC_PROPERTY, String.valueOf(this.getAutoCalc()));
        }
    }

    public DeviceSetupPanel[] getSetupPanel(Device device) {
        this.deviceSetupPanels[0] = new DeviceInfoPanel(device);
        this.deviceSetupPanels[1] = new LiveecgDeviceConfigPanel(this);
        this.deviceSetupPanels[2] = new LongRecordingsSettingsPanel(this.getSplitOfLongRecordingsInMs());
        return this.deviceSetupPanels;
    }

    public void install(ConfigDevice configDevice) {
        this.saveConfig(configDevice);
    }

    @Override
    public String getDriveName() {
        return this.driveName;
    }

    public void setDriveName(String driveName) {
        this.driveName = driveName;
    }

    public void setAutoCalc(boolean autocalc, boolean save) {
        this.autoCalc = autocalc;
        if (save) {
            this.configDevice.setParameter(AUTOCALC_PROPERTY, String.valueOf(this.getAutoCalc()));
            try {
                this.configDevice.save();
            }
            catch (PadsyException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean getAutoCalc() {
        return this.autoCalc;
    }

    public ConfigDevice getConfigDevice() {
        return this.configDevice;
    }

    public Class getDeviceClass() {
        return HolterAmbulantDevice.class;
    }

    public String getDeviceName() {
        return "LIVETEC ECG";
    }

    public String getDriverVendor() {
        return VENDOR_NAME;
    }

    public String[] getDescription() {
        return new String[]{DRIVER_TEXT.getText("device.holter.livetec.description1"), DRIVER_TEXT.getText("device.holter.livetec.description2"), DRIVER_TEXT.getText("device.holter.livetec.description3")};
    }

    public float getMaxDays() {
        float days = this.getTotalRecordingLengthInMs() / 1000L / 60L / 60L / 24L;
        return days;
    }

    public boolean hasDeviceSetupPanel() {
        return false;
    }

    public boolean hasRecording() throws DeviceException {
        logger.fine("\u00a7 hasRecording");
        return this.getRecordingState() == 2 || this.getRecordingState() == 3;
    }

    public boolean isRead() throws DeviceException {
        logger.fine("\u00a7 isRead");
        return this.getRecordingState() == 3;
    }

    public Interface getInterface() {
        return this.cardDummyInterface;
    }

    public boolean canTransfer() {
        logger.fine("\u00a7 canTransfer");
        return this.checkDrive() && this.checkDatFile();
    }

    public void cancelConnection() {
        logger.fine("\u00a7 cancelConnection");
        if (this.removable && this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (DeviceException e) {
                logger.log(Level.SEVERE, "can't disconnect device", e);
            }
        }
    }

    private void setFilesToImportList(List<String> filesToImportList) {
        this.setImportFiles(filesToImportList, this.driveName);
    }

    private List<String> getFilesToImportList() {
        File dirfile = null;
        dirfile = Praktisch.isOSX() ? new File("", this.getDriveName()) : new File(this.getDriveName(), "");
        logger.fine("\u00a7 DIRectory File <" + dirfile.getAbsolutePath() + "> / <" + dirfile.getPath() + "> <" + dirfile.getName() + ">");
        File[] liveecgFiles = dirfile.listFiles(new LiveecgFileFilter());
        String[] filesToImport = null;
        if (liveecgFiles != null) {
            logger.fine("Files found count <" + liveecgFiles.length + ">");
            filesToImport = new String[liveecgFiles.length];
            int i = 0;
            while (i < liveecgFiles.length) {
                File file = liveecgFiles[i];
                filesToImport[i] = file.getName();
                ++i;
            }
        }
        ArrayList<String> filesToImportList = new ArrayList<String>();
        if (filesToImport == null) {
            return filesToImportList;
        }
        int index = 0;
        while (index <= 99) {
            int ityp = 1;
            while (ityp >= 0) {
                String sFileName2Process = String.valueOf(this.getLiveecgPrefix()) + ityp + "." + (index <= 9 ? "0" : "") + index;
                boolean fnd = false;
                int i = 0;
                while (i < filesToImport.length) {
                    fnd = sFileName2Process.equalsIgnoreCase(filesToImport[i]);
                    if (fnd) {
                        filesToImportList.add(filesToImport[i]);
                        break;
                    }
                    ++i;
                }
                if (!fnd) break;
                --ityp;
            }
            ++index;
        }
        return filesToImportList;
    }

    private boolean checkDrive() {
        logger.finest("\u00a7 >> LIVETEC ECG checkDrive() : " + this.driveName);
        this.cardDummyInterface.setWriting(true);
        boolean retval = CardDriverService.getInstance().checkDrive(this.driveName);
        this.cardDummyInterface.setWriting(false);
        if (retval) {
            this.cardDummyInterface.setReading(true);
            this.cardDummyInterface.setReading(false);
        }
        logger.finest("\u00a7 << LIVETEC ECG checkDrive() : " + retval);
        return retval;
    }

    private boolean checkDatFile() {
        boolean retval = false;
        if (this.checkDrive() && new File(String.valueOf(this.driveName) + File.separator + LIVEECG_DAT_FILE_NAME).exists()) {
            logger.fine("\u00a7 DAT file <" + this.driveName + File.separator + LIVEECG_DAT_FILE_NAME + " exists <true>");
            retval = true;
            File datFile = new File(String.valueOf(this.driveName) + File.separator + LIVEECG_DAT_FILE_NAME);
            this.currentFileDate = datFile.lastModified();
        }
        return retval;
    }

    private boolean datFileChanged() {
        if (this.checkDrive()) {
            File datFile = new File(String.valueOf(this.driveName) + File.separator + LIVEECG_DAT_FILE_NAME);
            long fileDate = datFile.lastModified();
            return fileDate != this.currentFileDate;
        }
        return true;
    }

    public String getCardSerialNumber() throws DeviceException {
        return this.getDeviceSerNo();
    }

    public void setRemovableMedia(RemovableMedia removablemedia) {
        this.removableMedia = removablemedia;
    }

    public void connect() throws DeviceException {
        this.reset();
        logger.fine("\u00a7 connect\n");
        if (this.available.tryAcquire()) {
            if (this.checkDatFile()) {
                AssistantStep step;
                if (this.removableMedia == null) {
                    this.removableMedia = new RemovableMedia();
                }
                try {
                    this.removable = this.removableMedia.isWinMediaRemovable(this.driveName);
                }
                catch (Exception e) {
                    logger.severe(e.getMessage());
                }
                List<String> filesToImportList = this.getFilesToImportList();
                if (filesToImportList == null || filesToImportList.size() == 0) {
                    if (filesToImportList == null) {
                        logger.warning("filesToImportList == null");
                    } else if (filesToImportList.size() == 0) {
                        logger.warning("filesToImportList.size() == 0");
                    }
                    this.release();
                    return;
                }
                this.setFilesToImportList(filesToImportList);
                if (!this.isHeaderOk()) {
                    this.resetLastFileResult();
                    while (this.next(true)) {
                    }
                }
                if (this.ambulantDeviceAssistant != null && (step = this.ambulantDeviceAssistant.getStep()) != null) {
                    this.ejectVolume();
                    this.connected = false;
                    this.release();
                    throw new DeviceException(DRIVER_TEXT.getText("device.holter.noDatFile"));
                }
                if (this.hasBeenRead()) {
                    DateFormat format = DateFormat.getDateInstance(3);
                    DateFormat startFormat = DateFormat.getDateTimeInstance(3, 3);
                    Date birthDate = this.getPatientBirthDate();
                    Date startDate = this.getStartDate();
                    String message = "\n" + this.getPatientFirstName() + " " + this.getPatientLastName() + " (" + DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.warnings.read.recordingexists.born") + ": " + format.format(birthDate) + ")\n" + DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.warnings.read.recordingexists.dated") + " " + startFormat.format(startDate) + "\n";
                    int result = JOptionPane.showConfirmDialog(null, String.valueOf(DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.warnings.read.recordingexists1")) + message + DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.warnings.read.recordingexists2"), DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.title"), 0, 2);
                    if (result == 1) {
                        this.ejectVolume();
                        this.connected = false;
                        this.release();
                        throw new DeviceException(DRIVER_TEXT.getText("device.holter.noDatFile"));
                    }
                    if (this.datFileChanged()) {
                        JOptionPane.showMessageDialog(null, DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.datfilechanged"), DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.datfilechanged.title"), 0);
                        this.ejectVolume();
                        this.connected = false;
                        this.release();
                    }
                }
                if (!this.isDataOk()) {
                    this.ejectVolume();
                    this.connected = false;
                    this.release();
                    Exception e = new Exception(this.getErrors());
                    CharArrayWriter stackWriter = new CharArrayWriter();
                    e.printStackTrace(new PrintWriter(stackWriter));
                    String fileError = this.getLastFileError();
                    if (fileError == null) {
                        fileError = DRIVER_TEXT.getFormattedText("device.holter.livetec.recordings.data.invalid", (Object)this.getDirName());
                    }
                    LiveecgExceptionView liveecgExceptionView = new LiveecgExceptionView(null, DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.title"), fileError, String.valueOf(DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.count")) + "\n" + this.getErrors(), null, DRIVER_TEXT.getText("panel.yes"), DRIVER_TEXT.getText("panel.abort"), stackWriter.toString(), 0);
                    throw new DeviceException(DRIVER_TEXT.getText("device.holter.noDatFile"));
                }
                if (this.isHeaderOk()) {
                    this.serialNumber = this.getCardSerialNumber();
                    this.connected = true;
                    this.cardRemoved = false;
                    this.useGdtPatient = false;
                    boolean proceed = true;
                    List<LiveecgRecording> failedRecordings = this.getFailedLiveecgRecordings();
                    if (failedRecordings.size() > 0) {
                        Exception e = new Exception(this.getErrors());
                        CharArrayWriter stackWriter = new CharArrayWriter();
                        e.printStackTrace(new PrintWriter(stackWriter));
                        LiveecgExceptionView liveecgExceptionView = new LiveecgExceptionView(null, DRIVER_TEXT.getText("device.holter.livetec.recordings.validation.success.read.file.title"), DRIVER_TEXT.getFormattedText("device.holter.livetec.recordings.data.invalid", (Object)this.getDirName()), String.valueOf(DRIVER_TEXT.getFormattedText("device.holter.livetec.recordings.validation.success.read.file.count", (Object)failedRecordings.size(), (Object)(this.getImportFiles().size() / 2))) + "\n" + this.getErrors(), null, DRIVER_TEXT.getText("panel.yes"), DRIVER_TEXT.getText("panel.abort"), stackWriter.toString(), 0);
                        if (liveecgExceptionView.getActionSelected() == 1 || liveecgExceptionView.getActionSelected() == 2) {
                            this.ejectVolume();
                            this.connected = false;
                            this.release();
                            proceed = false;
                            throw new DeviceException(DRIVER_TEXT.getText("device.holter.noDatFile"));
                        }
                    }
                    if (proceed) {
                        logger.info("START");
                        this.createRecordingsView();
                        logger.fine("\u00a7 Connected <true>; cardRemoved <false>; Card serial no <" + this.serialNumber + ">");
                    }
                } else {
                    this.serialNumber = this.getCardSerialNumber();
                    this.connected = true;
                    this.cardRemoved = false;
                    logger.info("START");
                    this.useGdtPatient = false;
                    this.createRecordingsView();
                }
            } else {
                this.release();
                throw new DeviceException(DRIVER_TEXT.getText("device.holter.noDatFile"));
            }
            this.release();
        }
    }

    private Patient getTempPatient() {
        Patient patient = new Patient(this.getPatientFirstName(), this.getPatientLastName(), this.getPatientBirthDate());
        return patient;
    }

    public void createRecordingsView() {
        List<LiveecgRecording> liveecgRecordings = this.getLiveecgRecordings();
        if (liveecgRecordings == null || liveecgRecordings.size() <= 0) {
            return;
        }
        String title = String.valueOf(CardiolightText.getText((String)"HolterModulName")) + " " + DRIVER_TEXT.getText("device.holter.livetec.recordings.aufnahme");
        AssistantFrame assistantFrame = this.getAssistantFrame();
        assistantFrame.setLocation(new Point(-1000, -1000));
        try {
            new LiveecgRecordingsDialog((JFrame)assistantFrame, title, null, this.getTempPatient(), this, liveecgRecordings, this.getAutoCalc());
        }
        catch (Exception e) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            assistantFrame.setLocation(screen.width / 2 - assistantFrame.getWidth() / 2, screen.height / 2 - assistantFrame.getHeight() / 2);
            if (this.getPadsySession() != null) {
                this.getPadsySession().showException(PadsyText.getText((String)"AssistentErrorTitle"), PadsyText.getText((String)"AssistentErrorReadDevice"), (Throwable)e, PadsyText.getText((String)"AssistentErrorAnewHint"), PadsyText.getText((String)"OK"), null);
            }
            logger.severe("Start Error!\n" + e.getMessage());
            throw new RuntimeException("Start Error!", e);
        }
    }

    public void createSelectPatientView() {
        Patient liveecgPatient = this.getPatientInfo().getPatient();
        AssistantFrame assistantFrame = this.getAssistantFrame();
        assistantFrame.setLocation(new Point(-1000, -1000));
        String title = String.valueOf(CardiolightText.getText((String)"HolterModulName")) + " " + DRIVER_TEXT.getText("device.holter.livetec.recordings.patients");
        try {
            liveecgPatient.putAttribute("_PID_", (Object)this.getPatientId());
            new LiveecgSelectPatientListDialog(this.getPadsySession(), (JFrame)assistantFrame, title, null, liveecgPatient, this.gdtPatient, this);
        }
        catch (Exception e) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            assistantFrame.setLocation(screen.width / 2 - assistantFrame.getWidth() / 2, screen.height / 2 - assistantFrame.getHeight() / 2);
            if (this.getPadsySession() != null) {
                this.getPadsySession().showException(PadsyText.getText((String)"AssistentErrorTitle"), PadsyText.getText((String)"AssistentErrorReadDevice"), (Throwable)e, PadsyText.getText((String)"AssistentErrorAnewHint"), PadsyText.getText((String)"OK"), null);
            }
            logger.severe("Start Error!\n" + e.getMessage());
            throw new RuntimeException("Start Error!", e);
        }
    }

    private AssistantFrame getAssistantFrame() {
        Window[] frames;
        Window[] windowArray = frames = Window.getWindows();
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            Window fr = windowArray[n2];
            if (fr instanceof AssistantFrame) {
                return (AssistantFrame)fr;
            }
            ++n2;
        }
        return null;
    }

    public void ejectVolume() {
        if (this.checkDrive() && this.removableMedia != null && this.removable) {
            if (this.stateInfoLabel != null) {
                this.stateInfoLabel.setText(String.valueOf(RecordingInfo.STATE_TEXT) + RecordingInfo.stateCodeString[this.getRecordingState()]);
            }
            this.reset();
            boolean retval = this.removableMedia.ejectVolume(this.driveName);
            logger.fine("\u00a7 " + System.getProperty("os.name") + " ejectVolume volume=" + this.driveName + "  eject=" + retval);
            this.cardRemoved = true;
            this.removableMedia = null;
        }
    }

    public void disconnect() throws DeviceException {
        logger.fine("\u00a7 disconnect");
        this.acquire();
        this.ejectVolume();
        this.connected = false;
        this.reset();
        this.release();
    }

    public boolean isConnected() {
        boolean retval = false;
        this.acquire();
        if (this.checkDrive() && !this.cardRemoved && this.connected) {
            try {
                retval = this.serialNumber.equals(this.getCardSerialNumber());
            }
            catch (DeviceException e) {
                retval = false;
            }
        }
        this.release();
        if (!retval) {
            try {
                this.disconnect();
            }
            catch (DeviceException e) {
                logger.log(Level.SEVERE, "can't disconnect device", e);
            }
        }
        logger.finest("\u00a7 isConnected connected <" + this.connected + ">; retval <" + retval + ">");
        return this.connected && retval;
    }

    public AmbulantDeviceInfo getAmbulantDeviceInfo(Energizer energizer) throws DeviceException {
        this.acquire();
        HolterAmbulantDeviceInfo holterAmbulantDeviceInfo = null;
        try {
            Battery battery = this.getBattery();
            Storage storage = this.getStorage();
            AbleitungsSystem leadSystem = this.getLeadSystem();
            holterAmbulantDeviceInfo = new HolterAmbulantDeviceInfo(null, this.createInfoPanel(storage), battery, storage, this.getRecordingInfo(), this.getCardSerialNumber(), this.hasPacemakerSpikeDetection(), leadSystem, this.getRecorderCableInfo());
        }
        catch (DeviceException e) {
            this.release();
            throw e;
        }
        this.release();
        return holterAmbulantDeviceInfo;
    }

    public String getBuildNo() {
        return this.artefactInfo.getBuildNo();
    }

    public String getVersion() {
        return this.artefactInfo.getVersion();
    }

    public String getName() {
        return DEVICEDRIVER_NAME;
    }

    public ImageIcon getSmallIcon() {
        if (SMALL_ICON == null) {
            URL url = this.getClass().getResource(SMALL_ICON_NAME);
            if (url != null) {
                SMALL_ICON = new ImageIcon(url);
            } else {
                SMALL_ICON = new ImageIcon();
                logger.warning("image: LivetecSmallIcon.jpg not found");
            }
        }
        return SMALL_ICON;
    }

    public Icon getIcon() {
        if (ICON == null) {
            URL url = this.getClass().getResource(ICON_NAME);
            if (url != null) {
                ICON = new ImageIcon(url);
            } else {
                ICON = new ImageIcon();
                logger.warning("image: LivetecIcon.jpg not found");
            }
        }
        return ICON;
    }

    public HolterReadProgress getReadProgress() throws DeviceException {
        if (this.liveecgDeviceReadProgress != null) {
            return this.liveecgDeviceReadProgress;
        }
        this.liveecgDeviceReadProgress = new LiveecgDeviceReadProgress(this, this.cardDummyInterface);
        return this.liveecgDeviceReadProgress;
    }

    private JPanel createInfoPanel(Storage storage) {
        JPanel retval = new JPanel();
        retval.setLayout((LayoutManager)new TableLayout(LAYOUT_INFO_PANEL));
        retval.setBackground(Color.WHITE);
        retval.setOpaque(false);
        ImageIcon cardIcon = this.getSmallIcon();
        JLabel cardLabel = new JLabel(cardIcon);
        JLabel deviceInfoLabel = this.createLabel(this.getDeviceName(), PadsyFont.getBoldFont((float)14.0f));
        JLabel storageInfoLabel = this.createLabel(storage != null ? storage.getSizeString() : "Unknown Storage", PadsyFont.getPlainFont((float)14.0f));
        String stateText = RecordingInfo.STATE_TEXT;
        stateText = String.valueOf(stateText) + RecordingInfo.stateCodeString[this.getRecordingState()];
        this.stateInfoLabel = this.createLabel(stateText, PadsyFont.getPlainFont((float)14.0f));
        retval.add((Component)cardLabel, "0, 0, 0, 4");
        retval.add((Component)deviceInfoLabel, "2, 0");
        retval.add((Component)storageInfoLabel, "2, 2");
        retval.add((Component)this.stateInfoLabel, "2, 4");
        return retval;
    }

    private JLabel createLabel(String text, Font font) {
        JLabel label = new JLabel(text);
        label.setVerticalAlignment(3);
        label.setFont(font);
        return label;
    }

    protected String getLiveecgPrefix() {
        return LIVEECG_PREFIX;
    }

    private String getFilePrefix(File f) {
        String fileName = f.getName();
        int inx = fileName.indexOf(95);
        String filePrefix = inx > 0 ? fileName.substring(0, inx + 1) : "";
        return filePrefix;
    }

    public void startOnline() throws DeviceException {
    }

    public void stopOnline() throws DeviceException {
    }

    public boolean canOnline() {
        return false;
    }

    public boolean canRecord() {
        logger.fine("\u00a7 canRecord");
        return false;
    }

    public boolean canExternStart() {
        return false;
    }

    public int getLeadCode() {
        return 0;
    }

    public DeviceSetupPanel getDeviceSetupPanel(Device device) throws DeviceException {
        return null;
    }

    public String getGdtExaminationType() {
        return GDT_EXAMINATION_TYPE;
    }

    public void setAmbulantDeviceDataListener(AmbulantDeviceDataListener arg0) {
    }

    public HolterStartConfiguration getDefaultStartConfiguration() {
        return null;
    }

    public boolean isGdtPatientDiff() {
        return this.gdtPatient != null && (!this.getPatientFirstName().equalsIgnoreCase(this.gdtPatient.getFirstname()) || !this.getPatientLastName().equalsIgnoreCase(this.gdtPatient.getLastname()));
    }

    public void registerGdtPatient(Patient gdtPatient) {
        this.useGdtPatient = false;
        if (gdtPatient == null) {
            return;
        }
        if (!this.getPatientFirstName().equalsIgnoreCase(gdtPatient.getFirstname()) || !this.getPatientLastName().equalsIgnoreCase(gdtPatient.getLastname())) {
            this.gdtPatient = gdtPatient;
        }
    }

    public void setGdtPatientActive() {
        this.useGdtPatient = true;
        this.getAmbulantDeviceAssistant().setPatient(this.gdtPatient);
    }

    public HolterStartProgress getStartProgress() throws DeviceException {
        return null;
    }

    public void uninstall() {
    }

    public String getCompatibility() {
        return "7.3a";
    }

    public int getOverFlowType() {
        return 16;
    }

    public PadsySession getPadsySession() {
        return this.padsySession;
    }

    public void setPadsySession(PadsySession padsySession) {
        this.padsySession = padsySession;
    }

    public void setAmbulantDeviceAssistent(AmbulantDeviceAssistant ambulantDeviceAssistant) {
        this.ambulantDeviceAssistant = ambulantDeviceAssistant;
    }

    public AmbulantDeviceAssistant getAmbulantDeviceAssistant() {
        return this.ambulantDeviceAssistant;
    }

    public String getGdtPatientProfile() {
        return this.gdtPatient != null ? String.valueOf(this.gdtPatient.getLastname()) + ", " + this.gdtPatient.getFirstname() + "; " + PadsyDateFormat.format((Date)this.gdtPatient.getBirthdate(), (int)100) : "";
    }

    public void setRecordPanel(RecordPanel recordpanel) {
        this.recordPanel = recordpanel;
    }

    public RecordPanel getRecordPanel() {
        return this.recordPanel;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    protected DriverBundle getDriverBundle() {
        return DRIVER_TEXT;
    }

    public static void main(String[] args) {
        LiveecgDeviceDriver driver = new LiveecgDeviceDriver("Y:\\");
        try {
            driver.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class LiveecgFileFilter
    implements FileFilter {
        LiveecgFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String filePrefix = LiveecgDeviceDriver.this.getFilePrefix(pathname);
            if (filePrefix != null) {
                return filePrefix.equalsIgnoreCase(LiveecgDeviceDriver.this.getLiveecgPrefix());
            }
            return false;
        }
    }
}

