/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec;

import com.medset.cardiolight.data.filter.FilterService;
import com.medset.cardiolight.database.HolterRecording;
import com.medset.database.DatabaseHandle;
import com.medset.database.PadsyDatabase;
import com.medset.database.Patient;
import com.medset.database.Record;
import com.medset.database.Recording;
import com.medset.database.Sex;
import com.medset.database.datfile.DatFileManager;
import com.medset.ecg.filter.IoFilter;
import com.medset.hardware.CardDummyInterface;
import com.medset.hardware.DeviceException;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.holter.HolterReadInfo;
import com.medset.hardware.ambulant.holter.HolterReadProgress;
import com.medset.hardware.ambulant.holter.HolterRecordingInfo;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDataExport;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyException;
import com.medset.padsy.PadsyServerConnection;
import com.medset.padsy.PadsySession;
import com.medset.padsy.PadsyText;
import com.medset.padsy.ServerConnection;
import com.medset.util.progress.ProgressView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LiveecgDeviceReadProgress
extends HolterReadProgress {
    private static final Logger logger = Logger.getLogger(LiveecgDeviceReadProgress.class.getName());
    private LiveecgDeviceDriver liveecgDeviceDriver;
    private CardDummyInterface cardDummyInterface;

    public LiveecgDeviceReadProgress(LiveecgDeviceDriver liveecgdevicedriver, CardDummyInterface carddummyinterface) {
        this.liveecgDeviceDriver = liveecgdevicedriver;
        this.cardDummyInterface = carddummyinterface;
    }

    public HolterReadInfo[] read(PadsySession padsySession, ProgressView progressView, IoFilter ioFilter, Patient patient) throws PadsyException {
        HolterReadInfo[] retval = null;
        ArrayList<HolterReadInfo> allRecordings = new ArrayList<HolterReadInfo>();
        this.cardDummyInterface.setReading(true);
        HolterRecordingInfo recordingInfo = this.liveecgDeviceDriver.getRecordingInfo();
        ServerConnection padsyServerConnection = PadsyServerConnection.getInstance();
        PadsyDatabase padsyDatabase = padsyServerConnection.getPadsyDatabase();
        int sex = this.liveecgDeviceDriver.getPatientSex();
        if (sex != patient.getSex().getType() && (sex != 0 || patient.getSex().getType() == 0)) {
            DatabaseHandle phandle = padsyDatabase.openRecord((Record)patient, padsySession.getPadsyUser());
            patient.setSex(new Sex(sex), phandle);
            padsyDatabase.closeRecord((Record)patient, phandle);
        }
        int recordingsCount = 1;
        int holterrecordinglength = 0;
        int totalRecordingLength = 0;
        int splitOfRecordingInMs = this.liveecgDeviceDriver.getSplitOfLongRecordingsInMs();
        if (splitOfRecordingInMs != 86400000 && splitOfRecordingInMs != 172800000) {
            splitOfRecordingInMs = 86400000;
        }
        List<String> filesToImportList = this.liveecgDeviceDriver.getImportFiles();
        String dirName = this.liveecgDeviceDriver.getDriveName();
        List<LiveecgRecording> liveecgRecordings = this.liveecgDeviceDriver.getLiveecgRecordings();
        boolean fsttime = true;
        int rowcnt = liveecgRecordings.size() * 2;
        int rowinx = 0;
        while (rowinx < rowcnt) {
            int fromMs = 0;
            int toMs = 0;
            ArrayList<String> filessetlist = new ArrayList<String>();
            int filePos = liveecgRecordings.get(rowinx / 2).getPos();
            int fileInx = (filePos - 1) * 2;
            filessetlist.add(filesToImportList.get(fileInx));
            filessetlist.add(filesToImportList.get(fileInx + 1));
            LiveecgDeviceDriver liveecgdevicedriver = new LiveecgDeviceDriver();
            liveecgdevicedriver.setPacer(patient.getPacer() == null || patient.getPacer().isEmpty() || !patient.getPacer().equalsIgnoreCase(PadsyText.getText((String)"NoPacerText")));
            liveecgdevicedriver.setPadsySession(padsySession);
            liveecgdevicedriver.setImportFiles(filessetlist, dirName);
            LiveecgDeviceDataExport deviceDataExport = new LiveecgDeviceDataExport(liveecgdevicedriver, (HolterReadProgress)this);
            if (liveecgRecordings.get(rowinx / 2).getRecordingStartDateTime() == null) {
                DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
                String msg = String.valueOf(driverBundle.getText("device.holter.livetec.recordings.pos")) + " " + (rowinx + 1) + ": " + driverBundle.getText("device.holter.livetec.recordings.startdate") + " & " + driverBundle.getText("device.holter.livetec.recordings.starttime") + " <" + PadsyDateFormat.format(null, (int)10) + "> " + driverBundle.getText("device.holter.livetec.recordings.invalid") + ".";
                logger.severe(msg);
                throw new PadsyException(msg, rowinx);
            }
            long starttime = liveecgRecordings.get(rowinx / 2).getRecordingStartDateTime().getTime();
            int totalslices = (int)liveecgRecordings.get(rowinx / 2).getRecordingSlices();
            int currentslice = 0;
            while (!deviceDataExport.isEndOfRecording()) {
                if (!fsttime && ioFilter.getFilterSettings().isBaseLineFilterOn()) {
                    ((FilterService)ioFilter).resetFilterService();
                }
                fsttime = false;
                logger.log(Level.INFO, "Start reading recording[" + recordingsCount + "]; Pacer <" + patient.getPacer() + ">");
                int filerecordinglength = (int)liveecgRecordings.get(rowinx / 2).getRecordingLength();
                if (currentslice >= totalslices) {
                    DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
                    String msg = String.valueOf(driverBundle.getText("device.holter.livetec.recordings.pos")) + " " + (rowinx + 1) + ": " + driverBundle.getText("device.holter.livetec.recordings.startdate") + " & " + driverBundle.getText("device.holter.livetec.recordings.starttime") + " <" + PadsyDateFormat.format(null, (int)10) + "> " + driverBundle.getText("device.holter.livetec.recordings.invalid") + " <" + (currentslice + 1) + "/" + totalslices + ">";
                    logger.severe("\u00a7\u00a7\u00a7\u00a7 SEVERE\n" + msg + "\n\u00a7\u00a7\u00a7\u00a7 SEVERE");
                }
                HolterRecording holterRecording = new HolterRecording(new Date(starttime), filerecordinglength, recordingInfo.getLeadSystem().getAbleitungsAnzahl(), recordingInfo.getSerialNumber());
                padsyDatabase.addRecording((Recording)holterRecording, patient, null, padsySession.getPadsyUser());
                logger.fine("Recording created");
                DatabaseHandle db = padsyDatabase.openRecord((Record)holterRecording, padsySession.getPadsyUser());
                DatFileManager datFileManager = new DatFileManager(holterRecording.openFileHandle(padsyDatabase, "DAT", db));
                logger.fine("\u00a7 Recording opened splitOfRecordingInMs <" + splitOfRecordingInMs + ">");
                try {
                    holterrecordinglength = deviceDataExport.liveecgToDat(datFileManager, ioFilter, patient, progressView, splitOfRecordingInMs, filerecordinglength, starttime, totalslices, rowinx / 2 + 1, liveecgRecordings.size());
                    holterRecording.setRecordingLength(holterrecordinglength, db);
                }
                catch (DeviceException de) {
                    padsyDatabase.closeRecord((Record)holterRecording, db);
                    padsyDatabase.removeRecord((Record)holterRecording, padsySession.getPadsyUser());
                    throw de;
                }
                toMs = fromMs + holterrecordinglength;
                int[] smspikes = liveecgdevicedriver.getSMSpikes(fromMs, toMs);
                int[] eventmarkers = liveecgdevicedriver.getEventMarkers(fromMs, toMs);
                logger.fine("holter record recording length[" + recordingsCount + "] = " + holterrecordinglength);
                logger.fine("holter record pacer count [" + recordingsCount + "] = " + smspikes.length);
                logger.fine("holter record marker count [" + recordingsCount + "] = " + eventmarkers.length);
                if (holterrecordinglength > 0) {
                    HolterReadInfo holterReadInfo = new HolterReadInfo((Recording)holterRecording, datFileManager, db, holterrecordinglength, smspikes, eventmarkers, liveecgdevicedriver.getBatteryVoltageList(holterrecordinglength, totalRecordingLength));
                    totalRecordingLength += holterrecordinglength;
                    allRecordings.add(holterReadInfo);
                    starttime += (long)holterrecordinglength;
                    fromMs = toMs;
                } else {
                    padsyDatabase.closeRecord((Record)holterRecording, db);
                    padsyDatabase.removeRecord((Record)holterRecording, padsySession.getPadsyUser());
                    logger.log(Level.INFO, "DELETE reading[" + recordingsCount + "] of length 0");
                }
                logger.log(Level.INFO, "END reading recording[" + recordingsCount + "]");
                ++recordingsCount;
                ++currentslice;
            }
            deviceDataExport.close();
            rowinx += 2;
        }
        retval = allRecordings.toArray(new HolterReadInfo[allRecordings.size()]);
        logger.log(Level.INFO, "SUMMARY total number of created recordings = " + retval.length);
        this.liveecgDeviceDriver.clearRecording();
        this.liveecgDeviceDriver.cancelConnection();
        this.cardDummyInterface.setReading(false);
        return retval;
    }
}

