/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

public class ByteSwapper {
    public static short swap(short value) {
        int b1 = value & 0xFF;
        int b2 = value >> 8 & 0xFF;
        return (short)(b1 << 8 | b2 << 0);
    }

    public static int swap(int value) {
        int b1 = value >> 0 & 0xFF;
        int b2 = value >> 8 & 0xFF;
        int b3 = value >> 16 & 0xFF;
        int b4 = value >> 24 & 0xFF;
        return b1 << 24 | b2 << 16 | b3 << 8 | b4 << 0;
    }

    public static long swap(long value) {
        long b1 = value >> 0 & 0xFFL;
        long b2 = value >> 8 & 0xFFL;
        long b3 = value >> 16 & 0xFFL;
        long b4 = value >> 24 & 0xFFL;
        long b5 = value >> 32 & 0xFFL;
        long b6 = value >> 40 & 0xFFL;
        long b7 = value >> 48 & 0xFFL;
        long b8 = value >> 56 & 0xFFL;
        return b1 << 56 | b2 << 48 | b3 << 40 | b4 << 32 | b5 << 24 | b6 << 16 | b7 << 8 | b8 << 0;
    }

    public static float swap(float value) {
        int intValue = Float.floatToIntBits(value);
        intValue = ByteSwapper.swap(intValue);
        return Float.intBitsToFloat(intValue);
    }

    public static double swap(double value) {
        long longValue = Double.doubleToLongBits(value);
        longValue = ByteSwapper.swap(longValue);
        return Double.longBitsToDouble(longValue);
    }

    public static void swap(short[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = ByteSwapper.swap(array[i]);
            ++i;
        }
    }

    public static void swap(int[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = ByteSwapper.swap(array[i]);
            ++i;
        }
    }

    public static void swap(long[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = ByteSwapper.swap(array[i]);
            ++i;
        }
    }

    public static void swap(float[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = ByteSwapper.swap(array[i]);
            ++i;
        }
    }

    public static void swap(double[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = ByteSwapper.swap(array[i]);
            ++i;
        }
    }
}

