/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

import com.medset.hardware.DeviceException;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.install.ConfigDevice;
import com.medset.nativecode.media.RemovableMedia;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LiveecgDeviceDriverTest {
    private List<String> FILES;
    private String DIR;
    private LiveecgDeviceDriver liveecgDeviceDriver;

    @Before
    public void startup() {
        this.FILES = Arrays.asList("liveECG_1.00", "liveECG_0.00");
        String path = this.getClass().getResource("/").getPath();
        path = String.valueOf(path) + this.getClass().getName().replace(".", "/").replace(this.getClass().getSimpleName(), "");
        this.DIR = path.substring(0, path.length() - 1);
        this.liveecgDeviceDriver = new LiveecgDeviceDriver();
    }

    @Test
    public void testSetImportFiles() {
        this.liveecgDeviceDriver.reset();
        this.liveecgDeviceDriver.setImportFiles(this.FILES, this.DIR);
        List<String> files = this.liveecgDeviceDriver.getImportFiles();
        String dir = this.liveecgDeviceDriver.getDirName();
        Assert.assertTrue((boolean)this.FILES.containsAll(files));
        Assert.assertEquals((Object)this.DIR, (Object)dir);
    }

    @Test
    public void testNext() {
        this.liveecgDeviceDriver.reset();
        this.liveecgDeviceDriver.setImportFiles(this.FILES, this.DIR);
        boolean result = this.liveecgDeviceDriver.next(true);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)0L, (long)this.liveecgDeviceDriver.getBlockCount());
        Assert.assertEquals((Object)"2119728729", (Object)this.liveecgDeviceDriver.getRecordingId());
        Assert.assertEquals((long)4080000L, (long)this.liveecgDeviceDriver.getRecordingLengthInMs());
        Assert.assertEquals((long)0L, (long)this.liveecgDeviceDriver.getAbortCode());
        result = this.liveecgDeviceDriver.next(true);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)0L, (long)this.liveecgDeviceDriver.getBlockCount());
        Assert.assertEquals((Object)"2119728729", (Object)this.liveecgDeviceDriver.getRecordingId());
        Assert.assertEquals((long)4080000L, (long)this.liveecgDeviceDriver.getRecordingLengthInMs());
        Assert.assertEquals((Object)"01.01.2000 12:01:00", (Object)new SimpleDateFormat("dd.MM.yyyy hh:MM:ss").format(this.liveecgDeviceDriver.getPatientBirthDate()));
        this.liveecgDeviceDriver.setAnalyseOk(false);
        result = this.liveecgDeviceDriver.next(false);
        Assert.assertTrue((boolean)result);
        result = this.liveecgDeviceDriver.next(false);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"250Hz", (Object)this.liveecgDeviceDriver.getSampling());
        Assert.assertEquals((long)2040L, (long)this.liveecgDeviceDriver.getTotalBlockCount());
        Assert.assertEquals((long)3L, (long)this.liveecgDeviceDriver.getChannelCount());
        Assert.assertEquals((Object)"01.01.2000 12:01:00", (Object)new SimpleDateFormat("dd.MM.yyyy hh:MM:ss").format(this.liveecgDeviceDriver.getStartDate()));
        Assert.assertEquals((Object)"LIVEECG1234567", (Object)this.liveecgDeviceDriver.getDeviceSerNo());
        Assert.assertEquals((long)4L, (long)this.liveecgDeviceDriver.getEventMarkers(0, 4080000).length);
        int[] ints = new int[]{4059880, 4061092, 4066664, 4069076};
        int i = 0;
        int[] nArray = this.liveecgDeviceDriver.getEventMarkers(0, 4080000);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int ival = nArray[n2];
            Assert.assertEquals((long)ival, (long)ints[i++]);
            ++n2;
        }
        int[] smspikes = this.liveecgDeviceDriver.getSMSpikes(0, 4080000);
        Assert.assertEquals((long)10L, (long)smspikes.length);
        int[] spikes = new int[]{168, 168, 4059692, 4059724, 4059740, 4059772, 4070172, 4070172, 4070172, 4070172};
        i = 0;
        int[] nArray2 = this.liveecgDeviceDriver.getSMSpikes(0, 4080000);
        int n3 = nArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            int ival = nArray2[n4];
            Assert.assertEquals((long)ival, (long)spikes[i++]);
            ++n4;
        }
        Assert.assertEquals((long)0L, (long)this.liveecgDeviceDriver.getBatteryVoltage().length);
    }

    @Test
    public void testGetReadData() {
        this.liveecgDeviceDriver.reset();
        this.liveecgDeviceDriver.setImportFiles(this.FILES, this.DIR);
        boolean result = this.liveecgDeviceDriver.next(false);
        Assert.assertTrue((boolean)result);
        result = this.liveecgDeviceDriver.next(false);
        Assert.assertTrue((boolean)result);
        this.liveecgDeviceDriver.setAnalyseOk(true);
        Assert.assertEquals((long)2040L, (long)this.liveecgDeviceDriver.getTotalBlockCount());
        byte[] data = this.liveecgDeviceDriver.getReadData(1);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)2400L, (long)data.length);
        int cnt = 1;
        int i = 0;
        while (i < 203) {
            data = this.liveecgDeviceDriver.getReadData(10);
            Assert.assertNotNull((Object)data);
            Assert.assertEquals((long)24000L, (long)data.length);
            cnt += 10;
            ++i;
        }
        i = 0;
        while (i < 9) {
            data = this.liveecgDeviceDriver.getReadData(1);
            Assert.assertNotNull((Object)data);
            Assert.assertEquals((long)2400L, (long)data.length);
            ++cnt;
            ++i;
        }
        Assert.assertEquals((long)2040L, (long)cnt);
    }

    @Test
    public void testDeviceDriver() throws DeviceException {
        ConfigDevice configdevice = (ConfigDevice)EasyMock.createMockBuilder(ConfigDevice.class).addMockedMethod("getParameter").createMock();
        EasyMock.expect((Object)configdevice.getParameter("drivename", "-NO-VALUE-")).andReturn((Object)this.DIR).times(1);
        EasyMock.expect((Object)configdevice.getParameter("Autocalc", "false")).andReturn((Object)"false").times(1);
        EasyMock.expect((Object)configdevice.getParameter("LongRecordingsSplitInMS", String.valueOf(86400000))).andReturn((Object)"86400").times(1);
        EasyMock.replay((Object[])new Object[]{configdevice});
        RemovableMedia removableMedia = null;
        EasyMock.expect((Object)removableMedia.isWinMediaRemovable(this.DIR)).andReturn((Object)true).times(1);
        LiveecgDeviceDriver liveecgDeviceDriverNew = new LiveecgDeviceDriver(configdevice, this.DIR);
        liveecgDeviceDriverNew.reset();
        liveecgDeviceDriverNew.setRemovableMedia(removableMedia);
    }
}

