/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

import com.medset.database.Patient;
import com.medset.database.datfile.DatFileEntry;
import com.medset.database.datfile.DatFileManager;
import com.medset.ecg.filter.FilterSettings;
import com.medset.ecg.filter.IoFilter;
import com.medset.hardware.DeviceException;
import com.medset.hardware.ambulant.holter.HolterReadProgress;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileImportInterface;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileWorker;
import com.medset.padsy.PadsyException;
import com.medset.util.progress.ProgressView;
import java.text.DateFormat;
import java.util.Hashtable;
import java.util.logging.Logger;

public class LiveecgFileImport
implements LiveecgFileImportInterface {
    private static Logger logger = Logger.getLogger(LiveecgFileWorker.class.getName());
    protected static final int NOOFBLOCKS2READ = 13;
    private HolterReadProgress readProgress;
    private LiveecgFileWorker liveecgFileWorker;

    public LiveecgFileImport(LiveecgFileWorker liveecgfileworker, HolterReadProgress readProgress) {
        this.readProgress = readProgress;
        this.liveecgFileWorker = liveecgfileworker;
    }

    public Hashtable<String, String> setupParameters(IoFilter ioFilter) {
        Hashtable<String, String> parameter = new Hashtable<String, String>();
        int numberOfChannels = this.liveecgFileWorker.getChannelCount();
        logger.info("\u00a7 FIXED SCALING UNIT <" + this.liveecgFileWorker.getFixedScaleUnit() + ">");
        parameter.put("DU", "" + this.liveecgFileWorker.getFixedScaleUnit());
        parameter.put("DT", "5ms");
        parameter.put("LEADSYSTEM", "Holter");
        if (ioFilter != null) {
            parameter.put("OVERFLOWTYPE", String.valueOf(new Integer(((LiveecgDeviceDriver)this.liveecgFileWorker).getOverFlowType()).toString()) + "bit");
            FilterSettings filtersettings = ioFilter.getFilterSettings();
            parameter.put("BASELINEFILTER", new Boolean(filtersettings.isBaseLineFilterOn()).toString());
            parameter.put("MUSCLEFILTER", new Boolean(filtersettings.isMuscleFilterOn()).toString());
            parameter.put("POWERLINEFREQUENCY", String.valueOf(new Integer(filtersettings.getPowerlineFrequency()).toString()) + "Hz");
            parameter.put("POWERLINEFILTER", new Boolean(filtersettings.isPowerlineFilterOn()).toString());
        }
        parameter.put("KAN", new String("ABCD").substring(0, numberOfChannels));
        parameter.put("NAME", this.liveecgFileWorker.getPatientName());
        if (this.liveecgFileWorker.getStartDate() != null) {
            parameter.put("START", DateFormat.getDateInstance().format(this.liveecgFileWorker.getStartDate()));
        }
        logger.info("\u00a7 Parameters setup <ok>; SCALE  ECG_DU_ID <" + this.liveecgFileWorker.getFixedScaleUnit() + "nV>");
        return parameter;
    }

    private String calcRecordingTime() {
        int val = this.liveecgFileWorker.getBlockCount();
        int hrs = val * 2 / 60 / 60;
        int mins = this.liveecgFileWorker.getBlockCount() - hrs * 60 * 60 / 2;
        mins = mins * 2 / 60;
        return hrs + "." + (mins < 10 ? "0" + mins : Integer.valueOf(mins)) + "h";
    }

    @Override
    public int liveecgToDat(DatFileManager datFileManager, Patient patient, ProgressView progressView) throws DeviceException {
        int recordingLength = 0;
        try {
            byte[] readData;
            Hashtable<Object, Object> parameter = new Hashtable();
            while (this.liveecgFileWorker.next(false)) {
                if (!this.liveecgFileWorker.isHeaderOk()) continue;
                parameter = this.setupParameters(null);
            }
            this.liveecgFileWorker.setAnalyseOk(true);
            this.readProgress.initProgress(this.liveecgFileWorker.getBlockCount());
            logger.info("\u00a7Analyse of files completed. Start Import of Data.");
            progressView.setInfoText("Dateianalyse O.K.");
            byte[] tmp = new byte[]{};
            DatFileEntry datFileEntry = datFileManager.newEntry("EKG-16", parameter, tmp);
            while ((readData = this.liveecgFileWorker.getReadData(13)).length != 0) {
                datFileManager.appendData(datFileEntry, readData);
            }
            progressView.setProgress(100);
            progressView.finishOK(this.calcRecordingTime());
        }
        catch (PadsyException e) {
            logger.severe("Import Error!\n" + (Object)((Object)e));
            throw new DeviceException(e.getMessage());
        }
        return (int)((long)recordingLength - this.liveecgFileWorker.getTotalRecordingLengthInMs());
    }

    public int[] getVoltageList() {
        return this.liveecgFileWorker.getBatteryVoltage();
    }
}

