/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

import com.medset.cardiolight.data.filter.FilterService;
import com.medset.ecg.filter.FilterSettings;
import com.medset.ecg.filter.IoFilter;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceReadProgress;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileImport;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileWorker;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class LiveecgFileImportTest {
    @Test
    public void testSetupParameters() {
        String NAME = "Vorname Nachname";
        double SCALE = 228.88882106997895;
        LiveecgDeviceReadProgress liveecgDeviceReadProgress = (LiveecgDeviceReadProgress)((Object)EasyMock.createMockBuilder(LiveecgDeviceReadProgress.class).createMock());
        LiveecgFileWorker liveecgFileWorker = (LiveecgFileWorker)EasyMock.createMockBuilder(LiveecgFileWorker.class).addMockedMethod("getChannelCount").addMockedMethod("getChannelCount").addMockedMethod("getPatientName").addMockedMethod("getStartDate").addMockedMethod("getFixedScaleUnit").createMock();
        EasyMock.expect((Object)liveecgFileWorker.getChannelCount()).andReturn((Object)3).times(1);
        EasyMock.expect((Object)liveecgFileWorker.getPatientName()).andReturn((Object)NAME).times(1);
        Date date = new Date();
        EasyMock.expect((Object)liveecgFileWorker.getStartDate()).andReturn((Object)date).times(2);
        EasyMock.expect((Object)liveecgFileWorker.getFixedScaleUnit()).andReturn((Object)SCALE).times(2);
        IoFilter iofilter = (IoFilter)EasyMock.createMockBuilder(FilterService.class).addMockedMethod("getFilterSettings").createMock();
        EasyMock.expect((Object)iofilter.getFilterSettings()).andReturn((Object)this.createFilterSettings()).times(1);
        EasyMock.replay((Object[])new Object[]{liveecgFileWorker});
        EasyMock.replay((Object[])new Object[]{iofilter});
        Hashtable<String, String> pars = new LiveecgFileImport(liveecgFileWorker, liveecgDeviceReadProgress).setupParameters(iofilter);
        Assert.assertNotNull(pars);
        Assert.assertEquals((Object)pars.get("DU"), (Object)("" + SCALE));
        Assert.assertEquals((Object)pars.get("DT"), (Object)"5ms");
        Assert.assertEquals((Object)pars.get("BASELINEFILTER"), (Object)"true");
        Assert.assertEquals((Object)pars.get("MUSCLEFILTER"), (Object)"true");
        Assert.assertEquals((Object)pars.get("POWERLINEFILTER"), (Object)"true");
        Assert.assertEquals((Object)pars.get("POWERLINEFREQUENCY"), (Object)"50Hz");
        Assert.assertEquals((long)pars.get("KAN").length(), (long)3L);
        Assert.assertEquals((Object)pars.get("NAME"), (Object)NAME);
        Assert.assertEquals((Object)pars.get("START"), (Object)DateFormat.getDateInstance().format(date));
    }

    private FilterSettings createFilterSettings() {
        return new FilterSettings(true, true, true);
    }
}

