/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

import com.medset.database.Patient;
import com.medset.hardware.DeviceException;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.Battery;
import com.medset.hardware.ambulant.RecorderCableInfo;
import com.medset.hardware.ambulant.Storage;
import com.medset.hardware.ambulant.livetec.file.AnalyseResult;
import com.medset.hardware.ambulant.livetec.file.ByteSwapper;
import com.medset.hardware.ambulant.livetec.file.LiveecgFileWorkerInterface;
import com.medset.hardware.ambulant.livetec.file.LiveecgHeaderEnums;
import com.medset.hardware.ambulant.livetec.file.LiveecgInterpolate;
import com.medset.hardware.ambulant.livetec.file.LivetecRecorderCableInfo;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import com.medset.util.Praktisch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public abstract class LiveecgFileWorker
implements LiveecgFileWorkerInterface {
    private static Logger logger = Logger.getLogger(LiveecgFileWorker.class.getName());
    public static final double MAXVALUE_IN_nV = 1.0E7;
    private static final double FIXED_SCALE_UNIT = 333.3333333333333;
    public static final int WORK_FREQUENCY = 200;
    public static final int NO_BYTES_PER_SIGNAL = 2;
    private static final int MS_PER_BLOCK = 2000;
    private static final int BYTE_CNT_PER_RESAMPLED_BLOCK = 2400;
    public static final int CHANNEL_MAP_FIELD_COUNT = 7;
    public static final int CHANNEL_TYPE = 0;
    public static final int SCALE_UNITS = 1;
    public static final int SAMPLING = 2;
    public static final int AMPLIFIER = 3;
    public static final int DATA_FILE_INX = 4;
    public static final int FILE_POINTER = 5;
    public static final int DATA_LENGTH = 6;
    private static final String LIVETEC_DATA_CODEPAGE_WIN = "ISO-8859-1";
    private static final String LIVETEC_DATA_CODEPAGE_MAC = "UTF-8";
    public Map<String, List<Object>> ecgChnlMap = new HashMap<String, List<Object>>();
    public List<List<Object>> ecgChannelData = new ArrayList<List<Object>>();
    private Map<String, String> hdrMap = new HashMap<String, String>();
    private List<Integer> batteryVolts = new ArrayList<Integer>();
    private List<Integer> eventMarkers = new ArrayList<Integer>();
    private List<Integer> eventSMSpikes = new ArrayList<Integer>();
    private List<LiveecgRecording> liveecgRecordings = new ArrayList<LiveecgRecording>();
    protected Patient patient = null;
    private String dirName;
    private String fileName = null;
    private File fileAtWork = null;
    private int filePosInx = 0;
    private boolean analyseOk = false;
    private List<String> filesToImportList;
    private int channelCount = 0;
    private int totBlockCount = 0;
    private int blockInx = 0;
    private boolean hdrOk = false;
    private boolean dataOk = true;
    private RandomAccessFile racFile = null;
    private int startRecordingidInfo = 0;
    private int recordingidInfo = 0;
    private long recordinglengthInfo = 0L;
    private long totalRecordingLengthInfo = 0L;
    private int abortInfo = 0;
    private int statusInfo = -1;
    private Date startDate = null;
    private Date birthDate = null;
    private String lastName = null;
    private String firstName = null;
    private String patientId = null;
    private int patientSex = 0;
    private String deviceSerNo = null;
    private int samplesInBlock = 0;
    private boolean pacer = false;
    private JLabel infoTextLabel;
    private JProgressBar progressBar;
    private boolean stopAnalysisByError = true;
    private StringBuffer errors = new StringBuffer();
    private static int INFO_FILE_SIZE = 20;
    private static int MINIMUM_DATA_FILE_SIZE = 28;
    private Map<String, String> fileErrorMap = new HashMap<String, String>();
    private AnalyseResult lastFileResult = null;
    protected long currentFileDate = 0L;

    public void setComponents(JLabel infotextlabel, JProgressBar progressbar) {
        logger.fine("Text label <" + (infotextlabel != null) + ">, Progress Bar <" + (progressbar != null) + "> <<" + this.totalRecordingLengthInfo + ">>");
        this.infoTextLabel = infotextlabel;
        this.progressBar = progressbar;
    }

    public abstract int getSplitOfLongRecordingsInMs();

    public JLabel getInfoTextLabel() {
        return this.infoTextLabel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void initProgress(int max) {
        if (this.progressBar != null) {
            this.progressBar.setMaximum(max);
            this.progressBar.invalidate();
        }
    }

    public void updateProgress(int val) {
        if (this.progressBar != null) {
            this.progressBar.setValue(val);
            this.progressBar.invalidate();
        }
    }

    private void clearMaps() {
        int ecgchnlinx = 0;
        while (ecgchnlinx < this.getChannelCount()) {
            List<Object> data = this.ecgChnlMap.get("" + (ecgchnlinx + 1));
            if (data != null) {
                this.ecgChnlMap.get("" + (ecgchnlinx + 1)).clear();
            }
            ++ecgchnlinx;
        }
        this.ecgChnlMap.clear();
        this.hdrMap.clear();
        this.batteryVolts.clear();
        this.eventMarkers.clear();
        this.eventSMSpikes.clear();
        this.liveecgRecordings.clear();
        this.liveecgRecordings = new ArrayList<LiveecgRecording>();
    }

    public void reset() {
        logger.fine("\u00a7 RESET Worker");
        this.clearMaps();
        this.fileClose(this.racFile);
        this.racFile = null;
        this.fileAtWork = null;
        this.fileName = null;
        this.analyseOk = false;
        this.hdrOk = false;
        this.abortInfo = 0;
        this.recordingidInfo = 0;
        this.startRecordingidInfo = 0;
        this.totalRecordingLengthInfo = 0;
        this.statusInfo = -1;
        this.filePosInx = 0;
        this.blockInx = 0;
        this.totBlockCount = 0;
        this.channelCount = 0;
        this.birthDate = null;
        this.startDate = null;
        this.patientId = null;
        this.deviceSerNo = null;
        this.firstName = null;
        this.lastName = null;
        this.stopAnalysisByError = true;
        this.patient = null;
        this.currentFileDate = 0L;
        this.clearErrors();
    }

    public String getLastFileError() {
        if (this.lastFileResult != null) {
            return this.lastFileResult.getMessage();
        }
        return null;
    }

    public void resetLastFileResult() {
        this.lastFileResult = null;
        this.clearMaps();
    }

    @Override
    public boolean next(boolean onlyheader) {
        AnalyseResult result;
        if (this.filePosInx >= this.filesToImportList.size()) {
            return false;
        }
        logger.fine("next: " + this.filePosInx + " " + this.filesToImportList.get(this.filePosInx));
        this.fileName = this.filesToImportList.get(this.filePosInx);
        logger.fine("\u00a7 NEXT FILE <" + this.dirName + "> <" + this.fileName + ">");
        this.fileAtWork = new File(this.dirName, this.fileName);
        ++this.filePosInx;
        if (!this.analyseOk && (result = this.analyseFileAtWork(onlyheader)).getCode() != 0) {
            this.reset();
            this.lastFileResult = result;
            return false;
        }
        return true;
    }

    @Override
    public void setAnalyseOk(boolean analyseok) {
        if (!analyseok) {
            this.clearMaps();
            this.reset();
        }
        this.analyseOk = analyseok;
        this.filePosInx = 0;
    }

    private boolean isInfoFile(String filename) {
        return this.fileName != null && this.fileName.substring(0, 9).equalsIgnoreCase("liveECG_1");
    }

    private boolean isDataFile(String filename) {
        return this.fileName != null && this.fileName.substring(0, 9).equalsIgnoreCase("liveECG_0");
    }

    private boolean isDataFile(File file) {
        return file.getName() != null && file.getName().substring(0, 9).equalsIgnoreCase("liveECG_0");
    }

    private void addFileError(File file, String errmsg) {
        this.fileErrorMap.put(file.getName().substring(file.getName().indexOf(".") + 1), errmsg);
    }

    private String getFileErrors(File file) {
        return this.fileErrorMap.get(file.getName().substring(file.getName().indexOf(".") + 1));
    }

    private String getCodePage() {
        if (Praktisch.isOSX()) {
            return LIVETEC_DATA_CODEPAGE_MAC;
        }
        return LIVETEC_DATA_CODEPAGE_WIN;
    }

    private AnalyseResult analyseFileAtWork(boolean onlyheader) {
        AnalyseResult result = new AnalyseResult("", AnalyseResult.RESULT_OK);
        RandomAccessFile file = null;
        String errmsg = "";
        try {
            file = new RandomAccessFile(this.fileAtWork, "r");
            logger.fine("\u00a7 RANDOM ACCESS FILE <" + this.fileAtWork.getAbsolutePath() + "> OPENNED ");
            long filesize = file.length();
            if (this.isInfoFile(this.fileName)) {
                if (filesize != (long)INFO_FILE_SIZE) {
                    result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.assert.filesize", (Object)this.fileAtWork.getAbsolutePath(), (Object)20, (Object)filesize), Level.WARNING));
                    result.setCode(AnalyseResult.RESULT_ERROR_INFO_FILE);
                    AnalyseResult analyseResult = result;
                    return analyseResult;
                }
                this.recordingidInfo = ByteSwapper.swap(file.readInt());
                if (this.startRecordingidInfo == 0) {
                    this.startRecordingidInfo = this.recordingidInfo;
                } else if (this.startRecordingidInfo != this.recordingidInfo) {
                    this.logError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.recordingid.invalid", (Object)this.getCurrentFilePath(), (Object)("" + this.startRecordingidInfo), (Object)("" + this.recordingidInfo)), Level.WARNING);
                    result.setCode(AnalyseResult.RESULT_ERROR);
                    AnalyseResult analyseResult = result;
                    return analyseResult;
                }
                this.recordinglengthInfo = ByteSwapper.swap(file.readLong());
                if (onlyheader || this.totalRecordingLengthInfo <= 0L) {
                    this.totalRecordingLengthInfo += this.recordinglengthInfo;
                }
                this.abortInfo = ByteSwapper.swap(file.readInt());
                int status = ByteSwapper.swap(file.readInt());
                this.statusInfo = this.statusInfo == 0 ? this.statusInfo : status;
            } else if (this.isDataFile(this.fileName)) {
                if (filesize < (long)MINIMUM_DATA_FILE_SIZE) {
                    result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.assert.filesize", (Object)this.fileAtWork.getAbsolutePath(), (Object)" >= 28", (Object)filesize), Level.WARNING));
                    result.setCode(AnalyseResult.RESULT_ERROR_ZERO_FILE);
                    this.dataOk = false;
                    AnalyseResult analyseResult = result;
                    return analyseResult;
                }
            } else {
                this.logError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.assert.livetec.file", (Object)this.fileAtWork.getAbsolutePath()), Level.WARNING);
                result.setCode(AnalyseResult.RESULT_ERROR);
                AnalyseResult analyseResult = result;
                return analyseResult;
            }
            try {
                int cntblocks = 0;
                Object bytes = null;
                String theError = null;
                while (file.getFilePointer() < filesize) {
                    String shortErrorMsg;
                    CRC32 checksum = null;
                    checksum = new CRC32();
                    ++cntblocks;
                    long offset = file.getFilePointer();
                    int blockid = ByteSwapper.swap(file.readInt());
                    if (checksum != null) {
                        checksum.update(ByteBuffer.allocate(4).putInt(blockid).array(), 0, 4);
                    }
                    int recordingid = ByteSwapper.swap(file.readInt());
                    if (checksum != null) {
                        checksum.update(ByteBuffer.allocate(4).putInt(recordingid).array(), 0, 4);
                    }
                    long timeoffset = ByteSwapper.swap(file.readLong());
                    if (checksum != null) {
                        checksum.update(ByteBuffer.allocate(8).putLong(timeoffset).array(), 0, 8);
                    }
                    int blockLength = ByteSwapper.swap(file.readInt());
                    if (checksum != null) {
                        checksum.update(ByteBuffer.allocate(4).putInt(blockLength).array(), 0, 4);
                    }
                    int headerlength = ByteSwapper.swap(file.readInt());
                    if (checksum != null) {
                        checksum.update(ByteBuffer.allocate(4).putInt(headerlength).array(), 0, 4);
                    }
                    if (blockid != cntblocks) {
                        if (this.filePosInx <= 2) {
                            this.hdrOk = false;
                        }
                        result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.blockid.invalid", (Object)this.fileAtWork.getAbsolutePath(), (Object)cntblocks, (Object)blockid), Level.SEVERE));
                        result.setCode(AnalyseResult.RESULT_ERROR_INVALID_BLOCK_ID);
                        errmsg = this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.blockid.invalid", (Object)this.fileAtWork.getAbsolutePath(), (Object)cntblocks, (Object)blockid), Level.SEVERE);
                        shortErrorMsg = this.getDriverBundle().getText("device.holter.livetec.recordings.data.blockid.invalid.short");
                        this.addFileError(this.fileAtWork, errmsg);
                        theError = errmsg;
                        logger.severe("!!!!!!!!!!!!!!!! file offset on error: " + offset);
                        this.dataOk = false;
                        break;
                    }
                    if (cntblocks == 1 && timeoffset != 0L) {
                        if (this.filePosInx <= 2) {
                            this.hdrOk = false;
                        }
                        result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.timestamp.invalid", (Object)this.fileAtWork.getAbsolutePath(), (Object)0, (Object)timeoffset), Level.SEVERE));
                        result.setCode(AnalyseResult.RESULT_ERROR_INVALID_TIME_OFFSET);
                        shortErrorMsg = this.getDriverBundle().getText("device.holter.livetec.recordings.data.timestamp.invalid.short");
                        this.addFileError(this.fileAtWork, errmsg);
                        logger.severe("file offset on error: " + offset);
                        this.dataOk = false;
                        break;
                    }
                    if (timeoffset > this.totalRecordingLengthInfo) {
                        if (this.filePosInx <= 2) {
                            this.hdrOk = false;
                        }
                        result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.timestamp.greater", (Object)this.fileAtWork.getAbsolutePath(), (Object)timeoffset, (Object)this.totalRecordingLengthInfo), Level.SEVERE));
                        result.setCode(AnalyseResult.RESULT_ERROR_INVALID_TIMESTAMP);
                        this.addFileError(this.fileAtWork, errmsg);
                        logger.severe("file offset on error: " + offset);
                        this.dataOk = false;
                        break;
                    }
                    if (recordingid != this.startRecordingidInfo) {
                        if (this.filePosInx <= 2) {
                            this.hdrOk = false;
                        }
                        result.setMessage(this.logAnalysisError(this.getDriverBundle().getFormattedText("device.holter.livetec.recordings.data.recordingid.invalid", (Object)this.fileAtWork.getAbsolutePath(), (Object)("" + this.startRecordingidInfo), (Object)("" + recordingid)), Level.SEVERE));
                        result.setCode(AnalyseResult.RESULT_ERROR_INVALID_RECORDING_ID);
                        shortErrorMsg = this.getDriverBundle().getText("device.holter.livetec.recordings.data.recordingid.invalid.short");
                        this.addFileError(this.fileAtWork, errmsg);
                        logger.severe("file offset on error: " + offset);
                        this.dataOk = false;
                        break;
                    }
                    offset += 24L;
                    if (headerlength > 0) {
                        byte[] hdrbyte = new byte[headerlength];
                        file.read(hdrbyte);
                        if (checksum != null) {
                            checksum.update(hdrbyte, 0, headerlength);
                        }
                        String line = new String(hdrbyte, this.getCodePage());
                        String header = line.substring(0, line.lastIndexOf(";"));
                        String[] keyvalues = header.split("[;]");
                        String keyvalerror = null;
                        String[] stringArray = keyvalues;
                        int n = keyvalues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String keyvalue = stringArray[n2];
                            String[] keyval = keyvalue.split("[=]");
                            keyvalerror = this.checkAndStoreHeaderParam(keyval, blockid, timeoffset);
                            if (keyvalerror != null) {
                                errmsg = String.valueOf(keyvalerror) + "  " + this.fileAtWork.getAbsolutePath() + " \n";
                                this.logError(errmsg, Level.WARNING);
                                logger.severe("++++++++++++++ keyvalue: " + keyvalue);
                                break;
                            }
                            ++n2;
                        }
                        if (keyvalerror != null) {
                            logger.severe("++++++++++++++ keyvalerror: " + keyvalerror);
                            break;
                        }
                        offset += (long)headerlength;
                        if (!this.hdrOk && !onlyheader) {
                            this.initProgress((int)this.totalRecordingLengthInfo / 2000);
                        }
                        this.hdrOk = true;
                    }
                    if (!this.hdrOk) {
                        String message = "\u00a7 Header Info fehlt oder ung\u00fcltig!";
                        this.logError(message, Level.SEVERE);
                        logger.severe("file offset on error: " + offset);
                        break;
                    }
                    String[] chnltyps = this.hdrMap.get(LiveecgHeaderEnums.RECCHANNELS.getLabel()).split("[,]");
                    this.setChannelCount(chnltyps);
                    int chnltyppos = 1;
                    int ecgchnlpos = 1;
                    while (chnltyppos <= chnltyps.length) {
                        if (offset >= filesize) break;
                        int datalength2read = Integer.parseInt(this.hdrMap.get(LiveecgHeaderEnums.CHANNELCOUNT.getLabel("" + chnltyppos))) * 2;
                        if (!onlyheader && this.isEcgChannel(chnltyps[chnltyppos - 1])) {
                            List<Object> data;
                            List<Object> channelvals = new ArrayList<String>();
                            if (this.ecgChannelData.size() >= ecgchnlpos && (data = this.ecgChannelData.get(ecgchnlpos - 1)) != null) {
                                channelvals = data;
                            }
                            channelvals.add(chnltyps[chnltyppos - 1]);
                            String units = this.hdrMap.get(LiveecgHeaderEnums.CHANNELUNIT.getLabel("" + chnltyppos));
                            channelvals.add(units);
                            channelvals.add(this.hdrMap.get(LiveecgHeaderEnums.CHANNELSAMPLING.getLabel("" + chnltyppos)));
                            channelvals.add(this.hdrMap.get(LiveecgHeaderEnums.CHANNELAMPLIFIER.getLabel("" + chnltyppos)));
                            channelvals.add(new Integer(this.filePosInx));
                            channelvals.add(new Long(file.getFilePointer()));
                            channelvals.add(new Integer(datalength2read));
                            this.ecgChnlMap.put("" + ecgchnlpos++, channelvals);
                            this.ecgChannelData.add(channelvals);
                        }
                        file.seek(offset += (long)datalength2read);
                        if (chnltyppos == chnltyps.length) {
                            long crc = ByteSwapper.swap(file.readInt());
                            break;
                        }
                        ++chnltyppos;
                    }
                    ++this.totBlockCount;
                    if (onlyheader) continue;
                    this.updateProgress(this.totBlockCount);
                }
                if (onlyheader && this.isDataFile(this.fileAtWork)) {
                    this.updateLiveecgRecording(this.getFileErrors(this.fileAtWork));
                }
            }
            catch (Exception e) {
                result.setMessage(String.valueOf(e.getMessage()) + "\n" + this.getDriverBundle().getText("device.holter.livetec.recordings.read.abort"));
                result.setCode(AnalyseResult.RESULT_ERROR);
                errmsg = String.valueOf(e.getMessage()) + "\n" + this.getDriverBundle().getText("device.holter.livetec.recordings.read.abort");
                this.logError(errmsg, Level.WARNING);
            }
        }
        finally {
            logger.fine("\u00a7Total Blocks read <" + this.totBlockCount + ">");
            this.fileClose(file);
        }
        return result;
    }

    private void updateLiveecgRecording(String errmsg) {
        LiveecgRecording recording = new LiveecgRecording(this.filePosInx / 2, this.getStartDate(), this.getRecordingLengthInMs(), this.getSplitOfLongRecordingsInMs(), errmsg);
        this.liveecgRecordings.add(recording);
    }

    public List<LiveecgRecording> getLiveecgRecordings() {
        return this.liveecgRecordings;
    }

    public List<LiveecgRecording> getFailedLiveecgRecordings() {
        ArrayList<LiveecgRecording> failedRecordings = new ArrayList<LiveecgRecording>();
        for (LiveecgRecording recording : this.liveecgRecordings) {
            if (recording.getErrmsg() == null) continue;
            failedRecordings.add(recording);
        }
        return failedRecordings;
    }

    private String checkAndStoreHeaderParam(String[] keyval, int blockid, long timeoffset) throws ParseException {
        String errmsg = null;
        String key = keyval[0];
        String val = null;
        if (keyval.length > 1) {
            val = keyval[1];
        }
        if (key != null && !key.isEmpty()) {
            String oldval = this.hdrMap.get(key);
            String nkey = key.replaceAll("[0-9]", "#").replace("##", "#");
            logger.finest("\u00a7 Key <" + key + "> <" + nkey + ">");
            LiveecgHeaderEnums headerenum = LiveecgHeaderEnums.getEnum(nkey);
            DriverBundle bundle = this.getDriverBundle();
            if (headerenum == null) {
                throw new RuntimeException(bundle.getFormattedText("device.holter.livetec.recording.invalid.key", (Object)nkey));
            }
            switch (headerenum) {
                case DEVICESERNO: {
                    if (this.setDeviceSerNo(val)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.serialno", (Object)val, (Object)oldval);
                    logger.warning(errmsg);
                    return errmsg;
                }
                case PATIENTIDNUM: {
                    if (val == null || val.isEmpty() || this.setPatientId(val)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.patientid", (Object)val, (Object)oldval);
                    logger.warning(errmsg);
                    return errmsg;
                }
                case PATIENTFNAME: {
                    if (this.setPatientFirstName(val)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.firstname", (Object)val, (Object)oldval);
                    logger.warning(errmsg);
                    return errmsg;
                }
                case PATIENTLNAME: {
                    if (this.setPatientLastName(val)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.lastname", (Object)val, (Object)oldval);
                    logger.warning(errmsg);
                    return errmsg;
                }
                case PATIENTSEX: {
                    if (val == null || val.isEmpty() || this.setPatientSex(val)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.lastname", (Object)val, (Object)oldval);
                    logger.warning(errmsg);
                    return errmsg;
                }
                case PATIENTBDAY: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    dateFormat.setLenient(false);
                    Date bdate = null;
                    try {
                        bdate = dateFormat.parse(val);
                    }
                    catch (ParseException e) {
                        errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.birthday", (Object)val, (Object)(this.getPatientBirthDate() != null ? this.getPatientBirthDate().toString() : ""));
                        logger.warning(errmsg);
                        return errmsg;
                    }
                    if (new Date(System.currentTimeMillis()).compareTo(bdate) == -1) {
                        errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.birthday", (Object)val, (Object)(this.getPatientBirthDate() != null ? this.getPatientBirthDate().toString() : ""));
                        logger.warning(errmsg);
                        return errmsg;
                    }
                    if (this.setBirthDate(bdate)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.birthday", (Object)val, (Object)(this.getPatientBirthDate() != null ? this.getPatientBirthDate().toString() : ""));
                    logger.warning(errmsg);
                    return errmsg;
                }
                case RECSTARTTIME: {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(val.indexOf(44) > 0 ? "dd/MM/yyyy,HH/mm/ss" : "dd/MM/yyyy/HH/mm/ss");
                    dateFormat.setLenient(false);
                    Date date = null;
                    try {
                        date = dateFormat.parse(val);
                    }
                    catch (ParseException e) {
                        errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.starttime", (Object)val, (Object)(this.getStartDate() != null ? this.getStartDate().toString() : ""));
                        logger.warning(errmsg);
                        return errmsg;
                    }
                    if (this.setStartDate(date)) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.starttime", (Object)val, (Object)(this.getStartDate() != null ? this.getStartDate().toString() : ""));
                    logger.warning(errmsg);
                    return errmsg;
                }
                case EVENTMARKER: {
                    if (val == null || val.isEmpty()) break;
                    logger.fine("<" + val + "> <" + blockid + "> <" + timeoffset + "/" + LiveecgFileWorker.getMsInHrsMinsSecs(timeoffset) + ">");
                    this.insertEventMarkers(timeoffset, val);
                    break;
                }
                case EVENTSMSPIKE: 
                case EVENTSMSPIKES: {
                    if (val == null || val.isEmpty()) break;
                    logger.fine("<" + val + "> <" + blockid + "> <" + timeoffset + "/" + LiveecgFileWorker.getMsInHrsMinsSecs(timeoffset) + ">");
                    this.insertEventSMSpikes(timeoffset, val);
                    break;
                }
                case ABLEITUNGSYSTEM: 
                case CHANNELUNIT: 
                case CHANNELSAMPLING: 
                case CHANNELCOUNT: 
                case CHANNELAMPLIFIER: 
                case CHANNELOFFSET: {
                    if (val != null && !val.isEmpty()) break;
                    errmsg = bundle.getFormattedText("device.holter.livetec.recording.invalid.keyvalue", (Object)headerenum.getLabel(), (Object)val, (Object)oldval);
                    logger.info(errmsg);
                    return errmsg;
                }
            }
            this.hdrMap.put(key, val);
            this.insertBatteryVoltage();
        }
        return errmsg;
    }

    protected void testParameter() {
    }

    public int getBlockCount() {
        return this.totBlockCount;
    }

    public int getBlockLengthFromMap(int blockinx) {
        int len = 0;
        int chnlcnt = 1;
        while (this.ecgChnlMap != null && chnlcnt <= this.getChannelCount()) {
            len += ((Integer)this.ecgChnlMap.get("" + chnlcnt).get(6 + blockinx * 7)).intValue();
            ++chnlcnt;
        }
        return len;
    }

    public double[] getChannelUnitsFromMapInNanoVolts(int blockinx) {
        double[] units = new double[this.getChannelCount()];
        String[] unitsold = new String[this.getChannelCount()];
        int chnlcnt = 1;
        while (this.ecgChnlMap != null && chnlcnt <= this.getChannelCount()) {
            unitsold[chnlcnt - 1] = "" + this.ecgChnlMap.get("" + chnlcnt).get(1 + blockinx * 7);
            units[chnlcnt - 1] = this.getScalingUnitAsDoubleNanoVolts(unitsold[chnlcnt - 1]);
            ++chnlcnt;
        }
        return units;
    }

    public int getLength2Read(int blockinx, int blocks2read) {
        int len = 0;
        int startinx = blockinx;
        int cnt = 0;
        while (cnt < blocks2read && startinx < this.totBlockCount) {
            len += this.getBlockLengthFromMap(startinx);
            ++startinx;
            ++cnt;
        }
        return len;
    }

    public double[] getRealValues(byte[] src, int blklen, double[] units) {
        int totbytesperchnl = blklen / this.getChannelCount();
        int valsperchnl = totbytesperchnl / 2;
        double[] result = new double[valsperchnl * this.getChannelCount()];
        int valinx = 0;
        int resultinx = 0;
        while (valinx < valsperchnl) {
            int ecgchnlinx = 0;
            while (ecgchnlinx < this.getChannelCount()) {
                int chnldataoff = valinx * 2 + totbytesperchnl * ecgchnlinx;
                byte[] bval = new byte[2];
                int i = 1;
                int boff = 0;
                while (i >= 0) {
                    System.arraycopy(src, chnldataoff + i, bval, boff, 1);
                    --i;
                    ++boff;
                }
                result[resultinx] = ByteBuffer.wrap(bval).getShort();
                int n = resultinx;
                result[n] = result[n] * units[ecgchnlinx];
                int n2 = resultinx++;
                result[n2] = result[n2] / 1000.0;
                ++ecgchnlinx;
            }
            ++valinx;
        }
        return result;
    }

    private int appendInterpolatedBlock(byte[] src, int blklen, byte[] dest, int resultoff, double[] units) {
        double[] realvals = this.getRealValues(src, blklen, units);
        double[] resampledvals = LiveecgInterpolate.resample(realvals, 200, this.getSamplingAsInt(), this.getChannelCount());
        byte[] bval = new byte[2];
        int i = 0;
        while (i < resampledvals.length) {
            ByteBuffer.wrap(bval).putShort(this.getScaledShortValue(resampledvals[i]));
            System.arraycopy(bval, 0, dest, resultoff, 2);
            ++i;
            resultoff += 2;
        }
        return resultoff;
    }

    private double getScaledValue(double val) {
        return val * 1000.0 / 333.3333333333333;
    }

    private short getScaledShortValue(double val) {
        long lvalue = new Double(this.getScaledValue(val)).longValue();
        return (short)lvalue;
    }

    public void fileClose(RandomAccessFile racfile) {
        try {
            if (racfile != null) {
                racfile.close();
                logger.fine("\u00a7 RANDOM ACCESS FILE <" + this.fileAtWork.getAbsolutePath() + "> CLOSED");
                this.fileAtWork = null;
                this.fileName = null;
            }
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public RandomAccessFile switchFile(int filepos, RandomAccessFile racfile, String mode) throws FileNotFoundException, IOException {
        if (filepos != this.filePosInx) {
            this.filePosInx = filepos - 1;
            if (racfile != null) {
                this.fileClose(racfile);
            }
            this.next(false);
            racfile = new RandomAccessFile(this.fileAtWork, mode);
            logger.fine("\u00a7 RANDOM ACCESS FILE <" + this.fileAtWork.getAbsolutePath() + "> OPENNED");
        }
        return racfile;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getReadData(int blockcount2read) {
        totlen = this.getLength2Read(this.blockInx, blockcount2read);
        dataSampleRate = this.getSamplingAsInt();
        resultBuffersize = totlen * 200 / dataSampleRate;
        result = new byte[resultBuffersize];
        LiveecgFileWorker.logger.log(Level.FINE, "buffersize: " + resultBuffersize + " (" + totlen + "*" + 200 + "/" + dataSampleRate + ") ,blockInx:" + this.blockInx + ", blockcount2read:" + blockcount2read);
        if (totlen == 0) {
            return result;
        }
        chnldata = new byte[]{};
        resultoff = 0;
        try {
            try {
                endinx = this.blockInx + blockcount2read - 1;
                if (true) ** GOTO lbl26
                do {
                    filepos = (Integer)this.ecgChnlMap.get("1").get(4 + this.blockInx * 7);
                    this.racFile = this.switchFile(filepos, this.racFile, "r");
                    this.racFile.seek(((Long)this.ecgChnlMap.get("1").get(5 + this.blockInx * 7)).intValue());
                    blklen = this.getBlockLengthFromMap(this.blockInx);
                    if (blklen != chnldata.length) {
                        chnldata = new byte[blklen];
                    }
                    this.racFile.read(chnldata);
                    units = this.getChannelUnitsFromMapInNanoVolts(this.blockInx);
                    resultoff = this.appendInterpolatedBlock(chnldata, blklen, result, resultoff, units);
                    ++this.blockInx;
lbl26:
                    // 2 sources

                    if (this.blockInx > endinx) return result;
                } while (this.blockInx < this.totBlockCount);
                return result;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (this.blockInx != this.totBlockCount) return result;
                this.fileClose(this.racFile);
                this.racFile = null;
                return result;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.blockInx != this.totBlockCount) return result;
                this.fileClose(this.racFile);
                this.racFile = null;
                return result;
            }
        }
        finally {
            if (this.blockInx == this.totBlockCount) {
                this.fileClose(this.racFile);
                this.racFile = null;
            }
        }
    }

    public void setImportFiles(List<String> filesToImportList, String dirName) {
        logger.fine("\u00a7 Files to Import <" + dirName + "> <" + filesToImportList.toString() + ">");
        this.dirName = dirName;
        this.filesToImportList = filesToImportList;
    }

    public List<String> getImportFiles() {
        return this.filesToImportList;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPatient(Patient patient) {
        logger.fine("\u00a7 Setting Patient");
        this.patient = patient;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public boolean isheaderFile() {
        return this.filePosInx == 1;
    }

    @Override
    public int getChannelCount() {
        return this.channelCount;
    }

    public int setChannelCount(String[] chnltyps) {
        int cnt = 0;
        String[] stringArray = chnltyps;
        int n = chnltyps.length;
        int n2 = 0;
        while (n2 < n) {
            String chnltyp = stringArray[n2];
            if (this.isEcgChannel(chnltyp)) {
                ++cnt;
            }
            ++n2;
        }
        this.channelCount = cnt;
        return this.channelCount;
    }

    @Override
    public String getPatientName() {
        return String.valueOf(this.hdrMap.get(LiveecgHeaderEnums.PATIENTFNAME.getLabel())) + " " + this.hdrMap.get(LiveecgHeaderEnums.PATIENTLNAME.getLabel());
    }

    public String getSampling() {
        return this.hdrMap.get(LiveecgHeaderEnums.CHANNELSAMPLING.getLabel("1"));
    }

    public int getSamplingAsInt() {
        String sampling = this.getSampling();
        return Integer.parseInt(sampling.substring(0, sampling.indexOf("Hz")));
    }

    @Override
    public String getSkalingUnitAsStringNanoVolts(String skalingunit) {
        skalingunit = skalingunit == null ? this.hdrMap.get(LiveecgHeaderEnums.CHANNELUNIT.getLabel("1")) : skalingunit;
        double dskale = 0.0;
        double dskalingunit = 0.0;
        if (skalingunit.indexOf("nV") >= 0) {
            dskalingunit = new Double(skalingunit.substring(0, skalingunit.indexOf("nV"))).intValue();
        } else if (skalingunit.indexOf("mV") >= 0) {
            dskale = Double.parseDouble(skalingunit.substring(0, skalingunit.indexOf("mV")));
            dskalingunit = new Double(dskale *= 1000000.0);
        } else if (skalingunit.indexOf("uV") >= 0) {
            dskale = Double.parseDouble(skalingunit.substring(0, skalingunit.indexOf("uV")));
            dskalingunit = new Double(dskale *= 1000.0);
        } else if (skalingunit.indexOf("V") >= 0) {
            dskale = Double.parseDouble(skalingunit.substring(0, skalingunit.indexOf("V")));
            dskalingunit = new Double(dskale *= 1.0E9);
        } else {
            return skalingunit;
        }
        return "" + dskalingunit;
    }

    public double getScalingUnitAsDoubleNanoVolts(String skalingunit) {
        return Double.parseDouble(this.getSkalingUnitAsStringNanoVolts(skalingunit));
    }

    public String getAnalogeAmplifier() {
        return this.hdrMap.get(LiveecgHeaderEnums.CHANNELAMPLIFIER.getLabel("1"));
    }

    private boolean isEcgChannel(String chnltyp) {
        return chnltyp != null && !chnltyp.isEmpty() && chnltyp.startsWith("ECG");
    }

    public String getDeviceSerNo() {
        return "LIVETEC ECG " + this.deviceSerNo;
    }

    public boolean setDeviceSerNo(String deviceserno) {
        if (this.deviceSerNo == null) {
            this.deviceSerNo = deviceserno;
        } else if (deviceserno == null || !deviceserno.equals(this.deviceSerNo)) {
            return false;
        }
        return this.deviceSerNo != null;
    }

    public String getPatientId() {
        return this.patientId;
    }

    public boolean setPatientId(String patientid) {
        if (this.patientId == null) {
            logger.fine("################## Patient ID <" + patientid + "> #####################");
            this.patientId = patientid;
        } else if (patientid == null || !patientid.equals(this.patientId)) {
            return false;
        }
        return this.patientId != null;
    }

    public String getPatientLastName() {
        return this.lastName;
    }

    public boolean setPatientLastName(String lastname) {
        if (this.lastName == null) {
            this.lastName = lastname;
        } else if (lastname == null || !lastname.equalsIgnoreCase(this.lastName)) {
            return false;
        }
        return this.lastName != null;
    }

    public String getPatientFirstName() {
        return this.firstName;
    }

    public boolean setPatientFirstName(String firstname) {
        if (this.firstName == null) {
            this.firstName = firstname;
        } else if (firstname == null || !firstname.equalsIgnoreCase(this.firstName)) {
            return false;
        }
        return this.firstName != null;
    }

    public int getPatientSex() {
        return this.patientSex;
    }

    public boolean setPatientSex(String sexAsString) {
        if (sexAsString == null) {
            this.patientSex = 0;
            return true;
        }
        this.patientSex = sexAsString.equalsIgnoreCase("male") ? 1 : (sexAsString.equalsIgnoreCase("female") ? 2 : (sexAsString.equalsIgnoreCase("1") ? 1 : (sexAsString.equalsIgnoreCase("2") ? 2 : 0)));
        return true;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public boolean setStartDate(Date startdate) {
        if (this.startDate == null) {
            this.startDate = startdate;
        } else if (startdate == null || !startdate.equals(this.startDate)) {
            return false;
        }
        return this.startDate != null;
    }

    public Date getPatientBirthDate() {
        return this.birthDate;
    }

    public boolean setBirthDate(Date birthdate) {
        if (this.birthDate == null) {
            this.birthDate = birthdate;
        } else if (birthdate == null || !birthdate.equals(this.birthDate)) {
            return false;
        }
        return this.birthDate != null;
    }

    public int getTotalBlockCount() {
        return this.totBlockCount;
    }

    public long getTotalRecordingLengthInMs() {
        return this.totalRecordingLengthInfo;
    }

    public long getRecordingLengthInMs() {
        return this.recordinglengthInfo;
    }

    public long getMs4ByteCnt(long bytecnt) {
        return bytecnt * 2000L / 2400L;
    }

    public long getMs4BlockCnt(int blockcnt) {
        return blockcnt * 2000;
    }

    public int getBlockCnt4Ms(long milliSecs) {
        return (int)(milliSecs / 2000L);
    }

    public String getRecordingLengthInHrsMins() {
        return LiveecgFileWorker.getMsInHrsMins(this.totalRecordingLengthInfo);
    }

    public static String getMsInHrsMins(long ms) {
        int hrs = (int)(ms / 1000L / 3600L);
        String shrs = "" + hrs;
        if (shrs.length() == 0) {
            shrs = "00";
        } else if (shrs.length() == 1) {
            shrs = "0" + shrs;
        }
        int mins = (int)((ms - (long)(hrs * 3600 * 1000)) / 1000L / 60L);
        String smins = "" + mins;
        if (smins.length() == 0) {
            smins = "00";
        } else if (smins.length() == 1) {
            smins = "0" + smins;
        }
        return shrs + ":" + smins;
    }

    public static String getMsInHrsMinsSecs(long ms) {
        int hrs = (int)(ms / 1000L / 3600L);
        String shrs = "" + hrs;
        if (shrs.length() == 0) {
            shrs = "00";
        } else if (shrs.length() == 1) {
            shrs = "0" + shrs;
        }
        int mins = (int)((ms - (long)(hrs * 3600 * 1000)) / 1000L / 60L);
        String smins = "" + mins;
        if (smins.length() == 0) {
            smins = "00";
        } else if (smins.length() == 1) {
            smins = "0" + smins;
        }
        int secs = (int)((ms - (long)(hrs * 3600 * 1000 + mins * 60 * 1000)) / 1000L);
        String ssecs = "" + secs;
        if (ssecs.length() == 0) {
            ssecs = "00";
        } else if (ssecs.length() == 1) {
            ssecs = "0" + ssecs;
        }
        return shrs + ":" + smins + ":" + ssecs;
    }

    public String getRecordingId() {
        return this.startRecordingidInfo != 0 ? "" + this.startRecordingidInfo : null;
    }

    public int[] getBatteryVoltage() {
        String svoltunits = this.hdrMap.get(LiveecgHeaderEnums.LISTBATTERYUNIT.getLabel());
        String svolts = this.hdrMap.get(LiveecgHeaderEnums.LISTBATTERY.getLabel());
        if (svoltunits != null && !svoltunits.isEmpty() && svolts != null && !svolts.isEmpty()) {
            Double[] dvals = this.parseBatteryVoltageInMilliVolts(svolts, svoltunits);
            int[] ivals = new int[dvals.length];
            int i = 0;
            while (i < dvals.length) {
                ivals[i] = dvals[i].intValue();
                ++i;
            }
            return ivals;
        }
        return new int[0];
    }

    private Double[] parseBatteryVoltageInMilliVolts(String svolts, String svoltunits) {
        double dunits = Double.parseDouble(svoltunits.replace("V", ""));
        String[] sbatvolts = svolts.replace("(", "").replace(")", "").split("[,]");
        Double[] dbatvolts = new Double[2];
        if (sbatvolts.length == 1) {
            dbatvolts[0] = Double.parseDouble(sbatvolts[0]) * dunits * 1000.0;
            dbatvolts[1] = dbatvolts[0];
        } else if (sbatvolts.length >= 2) {
            dbatvolts[0] = Double.parseDouble(sbatvolts[0]) * dunits * 1000.0;
            dbatvolts[1] = Double.parseDouble(sbatvolts[1]) * dunits * 1000.0;
        }
        return dbatvolts;
    }

    private void insertBatteryVoltage() {
        String svoltunits = this.hdrMap.get(LiveecgHeaderEnums.LISTBATTERYUNIT.getLabel());
        String svolts = this.hdrMap.get(LiveecgHeaderEnums.LISTBATTERY.getLabel());
        if (svoltunits != null && !svoltunits.isEmpty() && svolts != null && !svolts.isEmpty()) {
            int val = this.parseBatteryVoltageInMilliVolts(svolts, svoltunits)[1].intValue();
            this.batteryVolts.add(new Integer(val));
            this.hdrMap.put(LiveecgHeaderEnums.LISTBATTERY.getLabel(), "");
        }
    }

    private void insertEvents(List<Integer> list, long timeoffset, String events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        String[] sevents = events.split("[,]");
        int i = 0;
        while (i < sevents.length) {
            int ival = (int)timeoffset + Integer.parseInt(sevents[i]);
            list.add(new Integer(ival));
            ++i;
        }
    }

    private void insertEventMarkers(long timeoffset, String markers) {
        this.insertEvents(this.eventMarkers, timeoffset, markers);
    }

    public int[] getEventMarkers(int fromms, int toms) {
        return this.getInts(this.eventMarkers, fromms, toms, true);
    }

    private int[] getInts(List<Integer> list, int fromms, int toms, boolean filter) {
        int[] result = new int[list.size()];
        if (filter) {
            int j = 0;
            int i = 0;
            while (i < list.size()) {
                int ival = list.get(i);
                if (ival >= fromms && ival <= toms) {
                    result[j++] = ival - fromms;
                }
                ++i;
            }
            int[] tmp = new int[j];
            int i2 = 0;
            while (i2 < j) {
                tmp[i2] = result[i2];
                ++i2;
            }
            result = tmp;
        } else {
            int i = 0;
            while (i < list.size()) {
                result[i] = list.get(i);
                ++i;
            }
        }
        return result;
    }

    public int[] getSMSpikes(int fromms, int toms) {
        return this.hasPacemakerSpikeDetection() ? this.getInts(this.eventSMSpikes, fromms, toms, true) : new int[]{};
    }

    private void insertEventSMSpikes(long timeoffset, String eventsmspikes) {
        this.insertEvents(this.eventSMSpikes, timeoffset, eventsmspikes);
    }

    @Override
    public boolean isHeaderOk() {
        return this.hdrOk;
    }

    public boolean isDataOk() {
        return this.dataOk;
    }

    @Override
    public void clearRecording() {
    }

    @Override
    public int[] getBatteryVoltageList(int recordingLength, int totalRecordingLength) {
        return this.getInts(this.batteryVolts, 0, 0, false);
    }

    protected RecorderCableInfo getRecorderCableInfo() {
        try {
            return new LivetecRecorderCableInfo();
        }
        catch (DeviceException e) {
            throw new RuntimeException("\u00a7 Recorder Cable Info creation error!\n", e);
        }
    }

    protected Storage getStorage() {
        Storage s = null;
        try {
            s = new Storage(0, "LIVEECG-Record", 1.0f, 1.0f);
        }
        catch (DeviceException e) {
            throw new RuntimeException("Error creating Storage Object.", e);
        }
        return s;
    }

    protected Battery getBattery() {
        Battery b = null;
        try {
            b = new Battery(0, 3, 1.0f, 1.0f);
        }
        catch (DeviceException e) {
            throw new RuntimeException("Error creating Battery Object.", e);
        }
        return b;
    }

    protected boolean hasPacemakerSpikeDetection() {
        return this.isPacer() && this.hdrMap.get(LiveecgHeaderEnums.PACEMAKERDETECT.getLabel()) != null && this.hdrMap.get(LiveecgHeaderEnums.PACEMAKERDETECT.getLabel()).equalsIgnoreCase("true");
    }

    protected boolean hasBeenRead() {
        return this.isHeaderOk() && this.statusInfo == 1;
    }

    public int getAbortCode() {
        return this.abortInfo;
    }

    public boolean setStatusRead() {
        logger.fine("Setting Status of File to <READ>");
        RandomAccessFile racfile = null;
        try {
            try {
                int pos = 1;
                while (pos < this.filesToImportList.size()) {
                    racfile = this.switchFile(pos, null, "rw");
                    if (racfile != null) {
                        racfile.seek(16L);
                        int statusinfo = 1;
                        racfile.writeInt(0);
                        racfile.seek(16L);
                        racfile.writeInt(ByteSwapper.swap(statusinfo));
                        this.fileClose(racfile);
                        racfile = null;
                    }
                    pos += 2;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (racfile != null) {
                    this.fileClose(racfile);
                }
                this.statusInfo = 1;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (racfile != null) {
                    this.fileClose(racfile);
                }
                this.statusInfo = 1;
            }
        }
        finally {
            if (racfile != null) {
                this.fileClose(racfile);
            }
            this.statusInfo = 1;
        }
        return true;
    }

    public long getCurrentRecordingStartTime() {
        return this.liveecgRecordings.get(this.filePosInx / 2 - 1).getRecordingStartDateTime().getTime();
    }

    public double getFixedScaleUnit() {
        return 333.3333333333333;
    }

    public boolean isPacer() {
        return this.pacer;
    }

    public void setPacer(boolean pacer) {
        this.pacer = pacer;
    }

    public String getDriveName() {
        return "";
    }

    private String getCurrentFilePath() {
        return "<" + this.dirName + "> <" + this.fileName + ">";
    }

    private void clearErrors() {
        this.errors = new StringBuffer();
    }

    public String getErrors() {
        return this.errors.toString();
    }

    private void logError(String errmsg, Level level) {
        this.errors.append(String.valueOf(errmsg) + "\r\n");
        logger.log(level, "\u00a7 " + errmsg);
    }

    private String logAnalysisError(String errmsg, Level level) {
        this.logError(errmsg, level);
        if (this.filePosInx > 2 && !this.stopAnalysisByError()) {
            errmsg = "";
        }
        return errmsg;
    }

    private boolean stopAnalysisByError() {
        if (this.stopAnalysisByError && this.getErrors().length() > 0) {
            Object[] options = new String[]{this.getDriverBundle().getText("panel.yes"), this.getDriverBundle().getText("panel.no")};
            if (JOptionPane.showOptionDialog(null, this.getDriverBundle().getText("device.holter.livetec.recordings.validation.errors.read.all.continue"), this.getDriverBundle().getText("device.holter.livetec.recordings.validation.errors.read.all.title"), 0, 0, null, options, options[0]) == 0) {
                this.stopAnalysisByError = false;
            }
        }
        return this.stopAnalysisByError;
    }

    protected DriverBundle getDriverBundle() {
        return null;
    }

    public int getSampleCountPerBlock() {
        return this.samplesInBlock;
    }

    public int getEcgChannelCount() {
        return this.ecgChnlMap.size();
    }

    public int getNumberOfBytesPerSample() {
        return 2;
    }
}

