/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.file;

import com.medset.numeric.Bspline;
import java.util.ArrayList;

public class LiveecgInterpolate {
    public static double[] resample(double[] data, int newFrequency, int oldFrequency, int channelcount) {
        double[] resamplingData = null;
        if (data != null) {
            ArrayList<double[]> interpolList = new ArrayList<double[]>();
            int chnlno = 1;
            while (chnlno <= channelcount) {
                interpolList.add(LiveecgInterpolate.getInterpolatedData(data, chnlno, newFrequency, oldFrequency, channelcount));
                ++chnlno;
            }
            resamplingData = new double[((double[])interpolList.get(0)).length * channelcount];
            int i = 0;
            int h = 0;
            while (i < resamplingData.length) {
                resamplingData[i] = ((double[])interpolList.get(0))[h];
                resamplingData[i + 1] = ((double[])interpolList.get(1))[h];
                resamplingData[i + 2] = ((double[])interpolList.get(2))[h];
                ++h;
                i += channelcount;
            }
        }
        return resamplingData;
    }

    protected static double[] getInterpolatedData(double[] data, int canalpos, int newFrequency, int oldFrequency, int channelcount) {
        double[] canal = LiveecgInterpolate.getCanalData(data, canalpos, channelcount);
        Bspline bspline = Bspline.calculateLinearBspline((double[])canal);
        return bspline.interpolateArray(canal, newFrequency, oldFrequency);
    }

    protected static double[] getCanalData(double[] data, int canalNumber, int channelcount) {
        double[] canalData = new double[data.length / channelcount];
        int k = 0;
        int i = canalNumber - 1;
        while (i < data.length) {
            canalData[k] = data[i];
            ++k;
            i += channelcount;
        }
        return canalData;
    }

    public static int[] resample(int[] data, int newFrequency, int oldFrequency, int channelcount) {
        int[] resamplingData = null;
        if (data != null) {
            ArrayList<int[]> interpolList = new ArrayList<int[]>();
            int chnlno = 1;
            while (chnlno <= channelcount) {
                interpolList.add(LiveecgInterpolate.getInterpolatedData(data, chnlno, newFrequency, oldFrequency, channelcount));
                ++chnlno;
            }
            resamplingData = new int[((int[])interpolList.get(0)).length * channelcount];
            int i = 0;
            int h = 0;
            while (i < resamplingData.length) {
                resamplingData[i] = ((int[])interpolList.get(0))[h];
                resamplingData[i + 1] = ((int[])interpolList.get(1))[h];
                resamplingData[i + 2] = ((int[])interpolList.get(2))[h];
                ++h;
                i += channelcount;
            }
        }
        return resamplingData;
    }

    protected static int[] getInterpolatedData(int[] data, int canalpos, int newFrequency, int oldFrequency, int channelcount) {
        int[] canal = LiveecgInterpolate.getCanalData(data, canalpos, channelcount);
        Bspline bspline = Bspline.calculateLinearBspline((int[])canal);
        return bspline.interpolateArray(canal, newFrequency, oldFrequency);
    }

    protected static int[] getCanalData(int[] data, int canalpos, int channelcount) {
        int[] canalData = new int[data.length / channelcount];
        int i = canalpos;
        int k = 0;
        while (i < data.length) {
            canalData[k] = data[i];
            i += channelcount;
            ++k;
        }
        return canalData;
    }
}

