/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.model;

import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.ProgramSettingsManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class LiveecgRecording {
    private static final Logger logger = Logger.getLogger(LiveecgRecording.class.getName());
    private Integer pos;
    private Date recordingStartDate;
    private Date recordingStartTime;
    private long recordingLength;
    private long recordingSlices;
    private Date startDateTimeCopy;
    private int slicesInMs;
    private String errmsg;

    public LiveecgRecording(int pos, Date startDateTime, long recordingLength, int sliceInMs, String errormsg) {
        this.setPos(pos);
        this.setRecordingStartDate(startDateTime);
        this.setRecordingStartTime(startDateTime);
        this.setRecordingLength(recordingLength);
        this.slicesInMs = sliceInMs;
        long slices = recordingLength / (long)this.slicesInMs;
        if (recordingLength > slices * (long)this.slicesInMs) {
            ++slices;
        }
        this.setRecordingSlices(slices);
        this.startDateTimeCopy = startDateTime;
        this.errmsg = errormsg;
    }

    public Date getRecordingStartTime() {
        return this.recordingStartTime;
    }

    public void setRecordingStartTime(Date recordingStartTime) {
        this.recordingStartTime = recordingStartTime;
    }

    public long getRecordingLength() {
        return this.recordingLength;
    }

    public void setRecordingLength(long recordingLength) {
        this.recordingLength = recordingLength;
    }

    public Date getRecordingStartDate() {
        return this.recordingStartDate;
    }

    public void setRecordingStartDate(Date recordingStartDate) {
        String onlydatestr = null;
        try {
            onlydatestr = PadsyDateFormat.format((Date)recordingStartDate);
            this.recordingStartDate = PadsyDateFormat.parse((String)onlydatestr);
        }
        catch (ParseException e) {
            logger.warning("\u00a7\u00a7\u00a7\u00a7 Recording <" + onlydatestr + "> error!");
            String errmsg = String.valueOf(e.getMessage()) + "\n" + LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.invalidentry");
            JOptionPane.showMessageDialog(null, errmsg, LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.data.invalid"), 2);
        }
    }

    public Integer getPos() {
        return this.pos;
    }

    public void setPos(Integer pos) {
        this.pos = pos;
    }

    public Date getRecordingStartDateTime() {
        String onlydatestr = null;
        String onlytimestr = null;
        try {
            onlydatestr = PadsyDateFormat.format((Date)this.getRecordingStartDate());
            onlytimestr = PadsyDateFormat.formatTime((Date)this.getRecordingStartTime(), (int)10);
            return new SimpleDateFormat(String.valueOf(ProgramSettingsManager.getInstance().getDateOutputFormat()) + " HH:mm:ss").parse(String.valueOf(onlydatestr) + " " + onlytimestr);
        }
        catch (ParseException e) {
            String errmsg = String.valueOf(e.getMessage()) + "\n" + LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.invalidentry");
            JOptionPane.showMessageDialog(null, errmsg, LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.data.invalid"), 2);
            return null;
        }
    }

    public LiveecgRecording clone() {
        return new LiveecgRecording(this.pos, this.recordingStartDate, this.recordingLength, this.slicesInMs, this.errmsg);
    }

    public void revert() {
        this.recordingStartDate = this.recordingStartTime = this.startDateTimeCopy;
    }

    public static void revert(List<LiveecgRecording> list) {
        for (LiveecgRecording item : list) {
            item.revert();
        }
    }

    public long getRecordingSlices() {
        return this.recordingSlices;
    }

    public void setRecordingSlices(long recordingSlices) {
        this.recordingSlices = recordingSlices;
    }

    public String getErrmsg() {
        return this.errmsg;
    }
}

