/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.model;

import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class LiveecgRecordingTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8203425380857072060L;
    public static final int REC_POS = 0;
    public static final int REC_STARTDATE = 1;
    public static final int REC_STARTTIME = 2;
    public static final int REC_LENGTH = 3;
    public static final int REC_SLICES = 4;
    public static final int REC_ERROR = 5;
    DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
    List<LiveecgRecording> recordingList = new ArrayList<LiveecgRecording>();
    private final String[] columnNames = new String[]{this.driverBundle.getText("device.holter.livetec.recordings.pos"), this.driverBundle.getText("device.holter.livetec.recordings.startdate"), this.driverBundle.getText("device.holter.livetec.recordings.starttime"), this.driverBundle.getText("device.holter.livetec.recordings.length"), this.driverBundle.getText("device.holter.livetec.recordings.slice"), this.driverBundle.getText("device.holter.livetec.recordings.error")};
    private final Class[] columnClass = new Class[]{Integer.class, Date.class, Date.class, Long.class, Long.class, String.class};

    public LiveecgRecordingTableModel() {
    }

    public LiveecgRecordingTableModel(List<LiveecgRecording> recordingList) {
        this.recordingList = recordingList;
    }

    public List<LiveecgRecording> getLiveecgRecordings() {
        return this.recordingList;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int colInx) {
        return this.columnClass[colInx];
    }

    @Override
    public int getColumnCount() {
        boolean hasError = false;
        for (LiveecgRecording recording : this.recordingList) {
            if (recording.getErrmsg() == null) continue;
            hasError = true;
        }
        if (hasError) {
            return this.columnNames.length;
        }
        return this.columnNames.length - 1;
    }

    @Override
    public int getRowCount() {
        return this.recordingList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LiveecgRecording row = this.recordingList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.getPos();
            }
            case 1: {
                return row.getRecordingStartDate();
            }
            case 2: {
                return row.getRecordingStartTime();
            }
            case 3: {
                return row.getRecordingLength();
            }
            case 4: {
                return row.getRecordingSlices();
            }
            case 5: {
                if (row.getErrmsg() != null) {
                    return row.getErrmsg();
                }
                return "";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 1: 
            case 2: {
                LiveecgRecording row = this.recordingList.get(rowIndex);
                return row.getErrmsg() == null;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object val, int rowIndex, int columnIndex) {
        LiveecgRecording row = this.recordingList.get(rowIndex);
        switch (columnIndex) {
            case 1: {
                row.setRecordingStartDate((Date)val);
                break;
            }
            case 2: {
                row.setRecordingStartTime((Date)val);
            }
        }
    }

    public long getCumulatedDuration() {
        long cumulatedLength = 0L;
        for (LiveecgRecording recording : this.recordingList) {
            cumulatedLength += recording.getRecordingLength();
        }
        return cumulatedLength;
    }
}

