/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view;

import com.ibm.icu.text.SimpleDateFormat;
import com.medset.graphics.NeuLookAndFeel;
import com.medset.graphics.PadsyFont;
import com.medset.graphics.TableLayout;
import com.medset.hardware.Device;
import com.medset.hardware.DeviceException;
import com.medset.hardware.DeviceManager;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.oem.OemManager;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyException;
import com.medset.padsy.PadsyImages;
import com.medset.padsy.PadsyText;
import com.medset.padsy.log.LogFileFilter;
import com.medset.software.Anwendung;
import com.medset.software.SoftwareInfo;
import com.medset.software.SoftwareManager;
import com.medset.util.ExtensionFileFilter;
import com.medset.util.Praktisch;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.jdic.desktop.Desktop;
import org.jdesktop.jdic.desktop.Message;

public class LiveecgExceptionView
extends JDialog {
    private static final long serialVersionUID = -255914107679524827L;
    private static final Logger logger = Logger.getLogger(LiveecgExceptionView.class.getName());
    public static final int RETURN_CODE_1 = 0;
    public static final int RETURN_CODE_2 = 1;
    public static final int RETURN_CANCEL_CODE = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int WARN_MESSAGE = 1;
    public static String EMPTY_STRING = "";
    public static String OLD_NEW_LINE = "\n";
    private static int ICON_SIZE = 48;
    static final String EMAIL_PROVIDER_KEY = "email.provider";
    static final String EMAIL_ADDRESS_KEY = "email.address";
    private static final String MAIL_CR = OLD_NEW_LINE;
    private static final Icon errorImage = PadsyImages.getScaledImageIcon((String)"svg/icon-error.svg", (int)ICON_SIZE, (int)ICON_SIZE);
    private static final Icon warningImage = PadsyImages.getScaledImageIcon((String)"svg/icon-warning.svg", (int)ICON_SIZE, (int)ICON_SIZE);
    private JLabel iconLabel;
    private JLabel messageLabel;
    private JTextArea errorLabel;
    private JTextArea questionLabel;
    private JTextArea detailText;
    private JPanel detailPanel;
    Throwable ex = null;
    static int retCode = 2;
    ShowDetailsAction showDetailsAction = new ShowDetailsAction();
    Action printAction = new PrintAction();
    Action saveAction = new SaveAction();
    Action eMailAction = new EMailAction();
    public static DriverBundle DRIVER_TEXT = new DriverBundle(LiveecgDeviceDriver.class);
    ExitAction exit2Action = new ExitAction(DRIVER_TEXT.getText("panel.abort"), 1);
    JButton exit1Button;
    JButton exit2Button;
    JButton detailButton;
    private Date exceptionDate;
    private int lastActionSelected = -1;

    public LiveecgExceptionView(JFrame frame, String titleText, String headingText, String errorText, String questionText, String exit1Text, String exit2Text, String details, int messageType) {
        super((Frame)frame, true);
        this.getRootPane().setName(this.getClass().getName());
        this.initComponents();
        this.setResizable(false);
        this.lastActionSelected = this.showException(titleText, headingText, errorText, questionText, exit1Text, exit2Text, details, messageType);
    }

    private void initComponents() {
        JPanel floorPanel = new JPanel(new GridBagLayout());
        floorPanel.setMaximumSize(new Dimension(500, 1000));
        floorPanel.setRequestFocusEnabled(false);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridheight = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(24, 24, 0, 24);
        gridBagConstraints1.anchor = 18;
        this.iconLabel = new JLabel(warningImage);
        this.iconLabel.setVerticalAlignment(1);
        this.iconLabel.setRequestFocusEnabled(false);
        floorPanel.add((Component)this.iconLabel, gridBagConstraints1);
        this.messageLabel = new JLabel(EMPTY_STRING);
        this.messageLabel.setForeground(Color.black);
        this.messageLabel.setFont(PadsyFont.getBoldFont((float)20.0f));
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setRequestFocusEnabled(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 0);
        floorPanel.add((Component)this.messageLabel, gridBagConstraints1);
        this.errorLabel = new JTextArea(EMPTY_STRING);
        this.errorLabel.setEditable(false);
        this.errorLabel.setLineWrap(true);
        this.errorLabel.setWrapStyleWord(true);
        this.errorLabel.setBackground(this.getBackground());
        this.errorLabel.setForeground(Color.black);
        this.errorLabel.setFont(PadsyFont.getBoldFont((float)18.0f));
        this.errorLabel.setFocusable(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 10);
        floorPanel.add((Component)this.errorLabel, gridBagConstraints1);
        this.questionLabel = new JTextArea(EMPTY_STRING);
        this.questionLabel.setEditable(false);
        this.questionLabel.setLineWrap(true);
        this.questionLabel.setWrapStyleWord(true);
        this.questionLabel.setBackground(this.getBackground());
        this.questionLabel.setForeground(Color.black);
        this.questionLabel.setFont(PadsyFont.getBoldFont((float)18.0f));
        this.questionLabel.setFocusable(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.weightx = 1.0;
        floorPanel.add((Component)this.questionLabel, gridBagConstraints1);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setRequestFocusEnabled(false);
        this.exit2Button = new NewJButton(this.exit2Action);
        this.exit2Button.setFont(PadsyFont.getBoldFont((float)18.0f));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 5);
        buttonPanel.add((Component)this.exit2Button, gridBagConstraints2);
        this.detailButton = new NewJButton(this.showDetailsAction);
        this.detailButton.setFont(PadsyFont.getBoldFont((float)18.0f));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 15, 0, 0);
        buttonPanel.add((Component)this.detailButton, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(10, 10, 15, 34);
        gridBagConstraints1.anchor = 15;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.0;
        floorPanel.add((Component)buttonPanel, gridBagConstraints1);
        this.detailPanel = new JPanel(new BorderLayout());
        this.detailPanel.setBorder(new BevelBorder(1));
        this.detailPanel.setRequestFocusEnabled(false);
        this.detailText = new JTextArea();
        this.detailText.setEditable(false);
        this.detailText.setTabSize(3);
        this.detailText.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane(this.detailText);
        scrollPane.setFocusable(false);
        this.detailPanel.add((Component)scrollPane, "Center");
        boolean space = false;
        JPanel detailButtonPanel = new JPanel((LayoutManager)new TableLayout(new double[]{(double)space, -2.0, -1.0, -2.0, 2.0, -2.0, (double)space}, new double[]{(double)space, -2.0, (double)space}));
        detailButtonPanel.setFocusable(false);
        NewJButton eMailButton = new NewJButton(this.eMailAction);
        eMailButton.setFont(PadsyFont.getBoldFont((float)18.0f));
        detailButtonPanel.add((Component)eMailButton, "1,1");
        NewJButton saveButton = new NewJButton(this.saveAction);
        saveButton.setFont(PadsyFont.getBoldFont((float)18.0f));
        detailButtonPanel.add((Component)saveButton, "3,1");
        NewJButton printButton = new NewJButton(this.printAction);
        printButton.setDefaultCapable(false);
        printButton.setFont(PadsyFont.getBoldFont((float)18.0f));
        detailButtonPanel.add((Component)printButton, "5,1");
        this.detailPanel.add((Component)detailButtonPanel, "South");
        this.detailPanel.setVisible(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        floorPanel.add((Component)this.detailPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.weightx = 0.0;
        gridBagConstraints1.weighty = 0.0;
        floorPanel.add(Box.createHorizontalStrut(500), gridBagConstraints1);
        this.getContentPane().add(floorPanel);
        this.getRootPane().setDefaultButton(this.exit2Button);
    }

    public int showException(String titleText, String headingText, Throwable e, String questionText, String exit1Text, String exit2Text) {
        PadsyException pe;
        int retval = 0;
        this.exceptionDate = new Date();
        CharArrayWriter stackWriter = new CharArrayWriter();
        e.printStackTrace(new PrintWriter(stackWriter));
        retval = e instanceof PadsyException ? this.showException((pe = (PadsyException)e).getTitleText() == null ? titleText : pe.getTitleText(), pe.getHeadingText() == null ? headingText : pe.getHeadingText(), e.getMessage(), pe.getQuestionText() == null ? questionText : pe.getQuestionText(), pe.getExit1Text() == null ? exit1Text : pe.getExit1Text(), pe.getExit2Text() == null ? exit2Text : pe.getExit2Text(), stackWriter.toString(), pe.getType() == 0 ? 1 : 0) : this.showException(titleText, headingText, e.getMessage() == null ? e.toString() : e.getMessage(), questionText, exit1Text, exit2Text, stackWriter.toString(), 0);
        return retval;
    }

    public int showException(String titleText, String headingText, String errorText, String questionText, String exit1Text, String exit2Text, String details, int messageType) {
        this.showDetailsAction.setShow(false);
        this.exceptionDate = new Date();
        if (questionText == null) {
            questionText = EMPTY_STRING;
        }
        this.setTitle(titleText);
        if (messageType == 0) {
            this.getRootPane().setWindowDecorationStyle(4);
            this.iconLabel.setIcon(errorImage);
            this.detailButton.setVisible(true);
        } else {
            this.getRootPane().setWindowDecorationStyle(8);
            this.iconLabel.setIcon(warningImage);
            this.detailButton.setVisible(false);
        }
        this.messageLabel.setText(headingText);
        this.errorLabel.setText(errorText);
        this.questionLabel.setText(questionText);
        if (questionText.length() == 0) {
            this.questionLabel.setVisible(false);
        } else {
            this.questionLabel.setVisible(true);
        }
        this.getRootPane().setDefaultButton(null);
        if (exit2Text != null) {
            this.exit2Action.setName(exit2Text);
            this.exit2Button.setVisible(true);
            if (exit1Text == null) {
                this.getRootPane().setDefaultButton(this.exit2Button);
            }
        } else {
            this.exit2Button.setVisible(false);
        }
        this.detailButton.setSelected(false);
        this.detailText.setText(EMPTY_STRING);
        if (messageType == 0) {
            this.detailPanel.setVisible(true);
            this.pack();
            this.detailText.setText(details);
        }
        this.detailPanel.setVisible(false);
        this.pack();
        this.setSize(500, this.getSize().height);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        return retCode;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    String convertTextToURI(String in) {
        String retval = null;
        try {
            retval = URLEncoder.encode(in, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.WARNING, "Can't decode eMail.", e);
        }
        return retval;
    }

    String createInfoText(String newLine) {
        String retval = "";
        SoftwareManager softwareManager = SoftwareManager.getInstance();
        retval = String.valueOf(retval) + "Betriebssystem: " + newLine + System.getProperty("os.name") + " Version " + System.getProperty("os.version") + newLine + newLine;
        retval = String.valueOf(retval) + "Installierte Software:" + newLine;
        if (softwareManager != null) {
            retval = String.valueOf(retval) + softwareManager.getPadsySoftwareInfo().getProductName() + " V" + softwareManager.getPadsySoftwareInfo().getVersion() + newLine;
            Anwendung[] anwendung = softwareManager.getAnwendungen();
            int i = 0;
            while (i < anwendung.length) {
                SoftwareInfo softwareInfo = anwendung[i].getSoftwareInfo();
                retval = String.valueOf(retval) + softwareInfo.getProductName() + " V" + softwareInfo.getVersion() + newLine;
                ++i;
            }
        } else {
            retval = String.valueOf(retval) + PadsyText.getText((String)"ExceptionViewUnknown") + newLine;
        }
        retval = String.valueOf(retval) + PadsyText.getText((String)"ExceptionViewInstalledDevices") + newLine;
        DeviceManager deviceManager = DeviceManager.getInstance();
        Device[] devices = deviceManager.getDevices(null);
        if (devices != null && devices.length > 0) {
            int i = 0;
            int j = devices.length;
            while (i < j) {
                String deviceName;
                try {
                    deviceName = String.valueOf(devices[i].getDeviceName()) + " V" + devices[i].getDeviceDriver().getVersion();
                }
                catch (DeviceException e) {
                    deviceName = PadsyText.getText((String)"ExceptionViewUnknownDevice");
                }
                retval = String.valueOf(retval) + deviceName + newLine;
                ++i;
            }
        }
        retval = String.valueOf(retval) + newLine + PadsyText.getText((String)"ExceptionTimeLabel") + newLine;
        retval = String.valueOf(retval) + SimpleDateFormat.getDateTimeInstance((int)0, (int)0).format(this.exceptionDate) + newLine;
        return retval;
    }

    public int getActionSelected() {
        return this.lastActionSelected;
    }

    class EMailAction
    extends AbstractAction {
        private static final long serialVersionUID = 4141457193325470254L;
        String provider;
        String address;

        EMailAction() {
            super(PadsyText.getText((String)"ExceptionMailActionName"));
            this.provider = EMPTY_STRING;
            this.address = EMPTY_STRING;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Praktisch.isOSX()) {
                Message message = new Message();
                ArrayList<String> toList = new ArrayList<String>();
                ArrayList<String> attachments = new ArrayList<String>();
                toList.add(OemManager.getOemHandler().getServiceEmail());
                LogFileFilter logFileFilter = new LogFileFilter();
                File[] logFiles = new File(".").listFiles((FilenameFilter)logFileFilter);
                int i = 0;
                while (i < logFiles.length) {
                    attachments.add(logFiles[i].getAbsolutePath());
                    ++i;
                }
                logFiles = new File("Log").listFiles((FilenameFilter)logFileFilter);
                i = 0;
                while (i < logFiles.length) {
                    attachments.add(logFiles[i].getAbsolutePath());
                    ++i;
                }
                message.setToAddrs(toList);
                message.setSubject(PadsyText.getText((String)"ExceptionMailTopic1"));
                message.setBody(String.valueOf(LiveecgExceptionView.this.createInfoText(OLD_NEW_LINE)) + "\n" + LiveecgExceptionView.this.messageLabel.getText() + "\n" + LiveecgExceptionView.this.detailText.getText() + "\n");
                try {
                    message.setAttachments(attachments);
                    Desktop.mail((Message)message);
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "Can't send eMail.", e1);
                    JOptionPane.showMessageDialog((Component)e.getSource(), PadsyText.getText((String)"ExceptionMailError1"));
                }
            } else {
                ArrayList<String> toList = new ArrayList<String>();
                ArrayList<String> attachments = new ArrayList<String>();
                toList.add(OemManager.getOemHandler().getServiceEmail());
                LogFileFilter logFileFilter = new LogFileFilter();
                File[] logFiles = new File(".").listFiles((FilenameFilter)logFileFilter);
                int i = 0;
                while (i < logFiles.length) {
                    attachments.add(logFiles[i].getAbsolutePath());
                    ++i;
                }
                logFiles = new File("Log").listFiles((FilenameFilter)logFileFilter);
                i = 0;
                while (i < logFiles.length) {
                    attachments.add(logFiles[i].getAbsolutePath());
                    ++i;
                }
                String message = "mailto:" + OemManager.getOemHandler().getServiceEmail() + "?subject=" + LiveecgExceptionView.this.convertTextToURI(PadsyText.getText((String)"ExceptionMailTopic1")) + "&body=" + LiveecgExceptionView.this.convertTextToURI(String.valueOf(LiveecgExceptionView.this.createInfoText(MAIL_CR)) + MAIL_CR + LiveecgExceptionView.this.messageLabel.getText() + MAIL_CR + LiveecgExceptionView.this.detailText.getText() + MAIL_CR);
                try {
                    java.awt.Desktop.getDesktop().mail(new URI(message));
                }
                catch (Exception e1) {
                    logger.log(Level.WARNING, "Can't send eMail.", e1);
                    JOptionPane.showMessageDialog((Component)e.getSource(), PadsyText.getText((String)"ExceptionMailError1"));
                }
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 890020469985748051L;
        int code;

        ExitAction(String label, int code) {
            super(label);
            this.code = 0;
            this.code = code;
        }

        public void setName(String text) {
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            retCode = this.code;
            LiveecgExceptionView.this.closeDialog();
        }
    }

    class NewJButton
    extends JButton
    implements NeuLookAndFeel {
        private static final long serialVersionUID = 6999951977299527616L;

        public NewJButton(Action action) {
            super(action);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            min.width = Math.max(min.width, 80);
            return min;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.width = Math.max(pref.width, 80);
            return pref;
        }
    }

    class PrintAction
    extends AbstractAction
    implements Printable {
        private static final long serialVersionUID = 4349840283545367714L;
        private int offsetHead;

        PrintAction() {
            super(PadsyText.getText((String)"ExceptionPrintButtonText"));
            this.offsetHead = 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setPrintable(this);
            printJob.setJobName(PadsyText.getText((String)"ExceptionMailTopic"));
            if (printJob.printDialog()) {
                try {
                    printJob.print(new HashPrintRequestAttributeSet(MediaSizeName.ISO_A4));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        int printHeader(Graphics2D g2d, PageFormat pageFormat, PrintHelper ph, int printPage, int page) {
            Iterator iterator;
            int licencePos;
            int retval = printPage;
            int licenceWidth = 0;
            String name1 = EMPTY_STRING;
            String name2 = EMPTY_STRING;
            String street = EMPTY_STRING;
            String address = EMPTY_STRING;
            String serial = EMPTY_STRING;
            String anAddress = String.valueOf(PadsyText.getText((String)"PrintExTo")) + " ";
            String vonAddress = String.valueOf(PadsyText.getText((String)"PrintExFrom")) + " ";
            FontMetrics fontMetrics = g2d.getFontMetrics();
            vonAddress = String.valueOf(vonAddress) + PadsyText.getText((String)"PrintExStempel") + "   ";
            String datum = PadsyDateFormat.format((Date)Calendar.getInstance().getTime());
            this.offsetHead = 0;
            if (page > 0) {
                licenceWidth = Math.max(fontMetrics.stringWidth(name1), licenceWidth);
                licenceWidth = Math.max(fontMetrics.stringWidth(serial), licenceWidth);
                if (licenceWidth > (int)(2.0 * pageFormat.getImageableWidth() / 3.0)) {
                    licenceWidth = (int)(2.0 * pageFormat.getImageableWidth() / 3.0);
                }
                licencePos = (int)pageFormat.getImageableWidth() - licenceWidth;
                int fontHeight = fontMetrics.getHeight();
                g2d.drawString(PadsyText.getFormattedText((String)"PrintExPage", (Object)String.valueOf(page + 1)), 0, fontHeight);
                g2d.drawString(name1, licencePos, fontHeight);
                g2d.drawString(datum, 0, 2 * fontHeight);
                g2d.drawString(serial, licencePos, 2 * fontHeight);
                this.offsetHead = 2 * fontHeight + 15;
                ph.top = (double)page * (pageFormat.getImageableHeight() - (double)this.offsetHead) + (double)this.offsetHead;
                ph.bottom = (double)(page + 1) * (pageFormat.getImageableHeight() - (double)this.offsetHead) + (double)this.offsetHead;
            }
            licenceWidth = Math.max(fontMetrics.stringWidth(name1), licenceWidth);
            licenceWidth = Math.max(fontMetrics.stringWidth(name2), licenceWidth);
            licenceWidth = Math.max(fontMetrics.stringWidth(street), licenceWidth);
            licenceWidth = Math.max(fontMetrics.stringWidth(address), licenceWidth);
            licenceWidth = Math.max(fontMetrics.stringWidth(serial), licenceWidth);
            if (licenceWidth > (int)(2.0 * pageFormat.getImageableWidth() / 3.0)) {
                licenceWidth = (int)(2.0 * pageFormat.getImageableWidth() / 3.0);
            }
            int anWidth = fontMetrics.stringWidth(anAddress);
            int vonWidth = fontMetrics.stringWidth(vonAddress);
            licencePos = (int)pageFormat.getImageableWidth() - licenceWidth - vonWidth;
            retval = this.drawString(g2d, String.valueOf(anAddress) + OemManager.getOemHandler().getVendorName(), 0, String.valueOf(vonAddress) + name1, licencePos, ph, retval);
            retval = this.drawString(g2d, PadsyText.getText((String)"info.developmentService"), anWidth, name2, licencePos += vonWidth, ph, retval);
            retval = this.drawString(g2d, street, licencePos, ph, retval);
            retval = this.drawString(g2d, String.valueOf(PadsyText.getText((String)"info.telephone")) + " " + OemManager.getOemHandler().getServiceTelefonNo(), anWidth, address, licencePos, ph, retval);
            retval = this.drawString(g2d, String.valueOf(PadsyText.getText((String)"info.fax")) + " " + OemManager.getOemHandler().getFaxNo(), anWidth, serial, licencePos, ph, retval);
            ph.y += 20;
            SoftwareManager softwareManager = SoftwareManager.getInstance();
            String info = PadsyText.getText((String)"ExceptionViewNoSoftware");
            ArrayList<String> info_anwendungen = new ArrayList<String>();
            if (softwareManager != null) {
                info = String.valueOf(softwareManager.getPadsySoftwareInfo().getProductName()) + " V" + softwareManager.getPadsySoftwareInfo().getVersion();
                Anwendung[] anwendung = softwareManager.getAnwendungen();
                int i = 0;
                while (i < anwendung.length) {
                    SoftwareInfo softwareInfo = anwendung[i].getSoftwareInfo();
                    info_anwendungen.add(String.valueOf(softwareInfo.getShortProductName()) + " V" + softwareInfo.getVersion());
                    ++i;
                }
            }
            DeviceManager deviceManager = DeviceManager.getInstance();
            Device[] devices = deviceManager.getDevices(null);
            ArrayList<String> info_devices = new ArrayList<String>();
            if (devices != null && devices.length > 0) {
                int i = 0;
                int j = devices.length;
                while (i < j) {
                    String deviceName;
                    try {
                        deviceName = String.valueOf(devices[i].getDeviceName()) + " V" + devices[i].getDeviceDriver().getVersion();
                    }
                    catch (DeviceException e) {
                        deviceName = PadsyText.getText((String)"ExceptionViewUnknownDevice");
                    }
                    info_devices.add(deviceName);
                    ++i;
                }
            }
            String os = String.valueOf(System.getProperty("os.name")) + " V" + System.getProperty("os.version");
            int datumPos = (int)pageFormat.getImageableWidth() - fontMetrics.stringWidth(datum);
            retval = this.drawString(g2d, info, 0, datum, datumPos, ph, retval);
            if (!info_anwendungen.isEmpty()) {
                iterator = info_anwendungen.iterator();
                while (iterator.hasNext()) {
                    retval = this.drawString(g2d, "  " + (String)iterator.next(), 0, ph, retval);
                }
                ph.y += 5;
            }
            if (!info_devices.isEmpty()) {
                iterator = info_devices.iterator();
                while (iterator.hasNext()) {
                    retval = this.drawString(g2d, "  " + (String)iterator.next(), 0, ph, retval);
                }
                ph.y += 5;
            }
            retval = this.drawString(g2d, os, 0, ph, retval);
            ph.y += 10;
            return retval;
        }

        int drawString(Graphics2D g2d, String text1, int x1, String text2, int x2, PrintHelper ph, int printPage) {
            FontMetrics fontMetrics = g2d.getFontMetrics();
            ph.y += fontMetrics.getHeight();
            int minY = ph.y + fontMetrics.getDescent();
            if ((double)minY >= ph.top && (double)minY < ph.bottom) {
                g2d.drawString(text1, x1, (int)((double)ph.y - ph.top) + this.offsetHead);
                g2d.drawString(text2, x2, (int)((double)ph.y - ph.top) + this.offsetHead);
                printPage = 0;
            }
            return printPage;
        }

        int drawString(Graphics2D g2d, String text, int x, PrintHelper ph, int printPage) {
            FontMetrics fontMetrics = g2d.getFontMetrics();
            ph.y += fontMetrics.getHeight();
            int minY = ph.y + fontMetrics.getDescent();
            if ((double)minY >= ph.top && (double)minY < ph.bottom) {
                g2d.drawString(text, x, (int)((double)ph.y - ph.top) + this.offsetHead);
                printPage = 0;
            }
            return printPage;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int page) {
            int retval = 1;
            PrintHelper ph = new PrintHelper();
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(Color.black);
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Font headerFont = PadsyFont.getBoldFont((float)20.0f);
            Font titleFont = PadsyFont.getBoldFont((float)16.0f);
            Font dataFont = PadsyFont.getPlainFont((float)12.0f);
            Font detailFont = PadsyFont.getPlainFont((float)10.0f);
            ph.y = 0;
            ph.top = (double)page * pageFormat.getImageableHeight();
            ph.bottom = (double)(page + 1) * pageFormat.getImageableHeight();
            g2d.setFont(dataFont);
            retval = this.printHeader(g2d, pageFormat, ph, retval, page);
            g2d.setFont(headerFont);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            String headerText = PadsyText.getText((String)"ExceptionMailTopic");
            int headerPos = (int)(pageFormat.getImageableWidth() - (double)fontMetrics.stringWidth(headerText)) / 2;
            retval = this.drawString(g2d, headerText, headerPos, ph, retval);
            ph.y += 3;
            g2d.setFont(titleFont);
            retval = this.drawString(g2d, PadsyText.getText((String)"ExceptionTimeLabel"), 0, ph, retval);
            retval = this.printBlock(g2d, SimpleDateFormat.getDateTimeInstance((int)0, (int)0).format(LiveecgExceptionView.this.exceptionDate), pageFormat.getImageableWidth(), ph, retval, dataFont);
            g2d.setFont(titleFont);
            retval = this.drawString(g2d, PadsyText.getText((String)"ExceptionMessageLabel"), 0, ph, retval);
            retval = this.printBlock(g2d, LiveecgExceptionView.this.messageLabel.getText(), pageFormat.getImageableWidth(), ph, retval, dataFont);
            g2d.setFont(titleFont);
            retval = this.drawString(g2d, PadsyText.getText((String)"ExceptionErrorLabel"), 0, ph, retval);
            retval = this.printBlock(g2d, LiveecgExceptionView.this.errorLabel.getText(), pageFormat.getImageableWidth(), ph, retval, dataFont);
            g2d.setFont(titleFont);
            retval = this.drawString(g2d, PadsyText.getText((String)"ExceptionDetailsLabel"), 0, ph, retval);
            retval = this.printBlock(g2d, LiveecgExceptionView.this.detailText.getText(), pageFormat.getImageableWidth(), ph, retval, detailFont);
            return retval;
        }

        int printBlock(Graphics2D g2d, String block, double width, PrintHelper ph, int printPage, Font font) {
            int tabOffset = 0;
            StringTokenizer st = new StringTokenizer(block, "\n\t (.", true);
            String nl = EMPTY_STRING;
            String token = EMPTY_STRING;
            String hToken = EMPTY_STRING;
            g2d.setFont(font);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.equals("\t")) {
                    tabOffset += 15;
                    continue;
                }
                if (nextToken.equals("\n")) {
                    nl = String.valueOf(nl) + token;
                    printPage = this.drawString(g2d, nl, 20 + tabOffset, ph, printPage);
                    token = EMPTY_STRING;
                    hToken = EMPTY_STRING;
                    nl = EMPTY_STRING;
                    tabOffset = 0;
                    continue;
                }
                if (nextToken.equals(" ")) {
                    token = String.valueOf(token) + nextToken;
                }
                if (nextToken.equals("(") || nextToken.equals(".")) {
                    token = String.valueOf(token) + nextToken;
                    hToken = String.valueOf(hToken) + nextToken;
                    continue;
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(nl));
                if ((double)(20 + tabOffset + fontMetrics.stringWidth(stringBuilder.append(nextToken).append(token).append(hToken).toString())) < width) {
                    nl = String.valueOf(nl) + token + nextToken;
                } else {
                    printPage = this.drawString(g2d, String.valueOf(nl) + hToken, 20 + tabOffset, ph, printPage);
                    nl = nextToken;
                }
                token = EMPTY_STRING;
                hToken = EMPTY_STRING;
            }
            if ((nl = String.valueOf(nl) + token).length() > 0) {
                printPage = this.drawString(g2d, nl, 20 + tabOffset, ph, printPage);
            }
            return printPage;
        }

        class PrintHelper {
            double top;
            double bottom;
            int y;

            PrintHelper() {
            }

            public String toString() {
                return "Top: " + this.top + " Bottom: " + this.bottom + " Y: " + this.y;
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -6227049957612856862L;

        SaveAction() {
            super(PadsyText.getText((String)"ExceptionSaveText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser(".");
            ExtensionFileFilter filter = new ExtensionFileFilter("erf", "Error Report Files");
            chooser.setFileFilter((FileFilter)filter);
            chooser.setDialogTitle(PadsyText.getText((String)"ExceptionSaveDialogTitle"));
            chooser.setApproveButtonText(PadsyText.getText((String)"ExceptionSaveButtonText"));
            chooser.setSelectedFile(new File("Error.erf"));
            int returnVal = chooser.showOpenDialog((Component)e.getSource());
            if (returnVal == 0) {
                File exportFile = chooser.getSelectedFile();
                if (!chooser.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".erf")) {
                    exportFile = new File(String.valueOf(chooser.getSelectedFile().getAbsolutePath()) + ".erf");
                }
                boolean exportFiles = true;
                if (exportFile.exists()) {
                    int ret = JOptionPane.showConfirmDialog((Component)e.getSource(), PadsyText.getFormattedText((String)"ExceptionSaveError1", (Object)exportFile), PadsyText.getText((String)"OverwriteText"), 2, 2);
                    boolean bl = exportFiles = ret == 0;
                }
                if (exportFiles) {
                    try {
                        PrintWriter pw = new PrintWriter(new FileOutputStream(exportFile), true);
                        pw.println(LiveecgExceptionView.this.createInfoText(OLD_NEW_LINE));
                        pw.println(PadsyText.getText((String)"ExceptionMessageLabel"));
                        pw.println(LiveecgExceptionView.this.messageLabel.getText());
                        pw.println(PadsyText.getText((String)"ExceptionErrorLabel"));
                        pw.println(LiveecgExceptionView.this.errorLabel.getText());
                        pw.println(PadsyText.getText((String)"ExceptionDetailsLabel"));
                        pw.println(LiveecgExceptionView.this.detailText.getText());
                        pw.close();
                    }
                    catch (Exception ex) {
                        JOptionPane.showConfirmDialog((Component)e.getSource(), PadsyText.getFormattedText((String)"ExceptionSaveError2", (Object)exportFile), EMPTY_STRING, 0, 2);
                    }
                }
            }
        }
    }

    class ShowDetailsAction
    extends AbstractAction {
        private static final long serialVersionUID = -4961099354767502650L;
        private boolean show;

        ShowDetailsAction() {
            super(PadsyText.getText((String)"ExceptionDetailsText"));
            this.show = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.show = !this.show;
            LiveecgExceptionView.this.setSize(LiveecgExceptionView.this.getSize().width, LiveecgExceptionView.this.getSize().height + (this.show ? 200 : -200));
            LiveecgExceptionView.this.detailPanel.setVisible(this.show);
            LiveecgExceptionView.this.doLayout();
        }

        public void setShow(boolean show) {
            this.show = show;
        }
    }
}

