/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.device;

import com.medset.graphics.PadsyFont;
import com.medset.graphics.TableLayout;
import com.medset.hardware.DeviceSetupPanel;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.util.Praktisch;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.filechooser.FileSystemView;

public class LiveecgDeviceConfigPanel
extends DeviceSetupPanel {
    private static final long serialVersionUID = 2936933446600736916L;
    private static final String TITLE = LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.properties");
    private static final double[][] LAYOUT_SIZES = new double[][]{{5.0, -2.0, 20.0, -2.0, 20.0, -2.0, 20.0, -2.0, 20.0, -2.0, 20.0, -2.0, -1.0, 5.0}, {5.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, 5.0, -2.0, 5.0}};
    private static final Font smallFont = PadsyFont.getPlainFont((float)14.0f);
    private static final Font titleFont = PadsyFont.getBoldFont((float)15.0f);
    private LiveecgDeviceDriver liveecgDeviceDriver;

    public LiveecgDeviceConfigPanel(LiveecgDeviceDriver liveecgdevicedriver) {
        super((LayoutManager)new TableLayout(LAYOUT_SIZES));
        this.liveecgDeviceDriver = liveecgdevicedriver;
        if (Praktisch.isOSX()) {
            JLabel title = new JLabel(String.valueOf(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.drive")) + ": " + LiveecgDeviceDriver.OSX_DRIVE_NAME);
            title.setFont(titleFont);
            this.add(title, "1,2");
        } else {
            this.liveecgDeviceDriver = liveecgdevicedriver;
            JLabel title = new JLabel(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.drive"));
            title.setFont(titleFont);
            this.add(title, "1,1,3,1");
            String constraints = "";
            File[] files = File.listRoots();
            ArrayList<File> fileList = new ArrayList<File>();
            ButtonGroup buttonGroup = new ButtonGroup();
            int i = 0;
            while (i < files.length) {
                if (FileSystemView.getFileSystemView().isDrive(files[i])) {
                    fileList.add(files[i]);
                    String driveName = files[i].getAbsolutePath();
                    JCheckBox checkBox = this.createCheckBox(new DriveNameAction(driveName), liveecgdevicedriver.getDriveName().equals(driveName));
                    constraints = i < 5 ? "1," + (2 + i) : (i < 10 ? "3," + (2 + i - 5) : (i < 15 ? "5," + (2 + i - 10) : (i < 20 ? "7," + (2 + i - 15) : (i < 25 ? "9," + (2 + i - 20) : "11," + (2 + i - 25)))));
                    buttonGroup.add(checkBox);
                    this.add(checkBox, constraints);
                }
                ++i;
            }
        }
    }

    protected JCheckBox createCheckBox(Action aL, boolean selected) {
        JCheckBox button = new JCheckBox(aL);
        button.setFont(smallFont);
        button.setSelected(selected);
        return button;
    }

    public String getTitle() {
        return TITLE;
    }

    public void saveSettings() {
    }

    class DriveNameAction
    extends AbstractAction {
        private static final long serialVersionUID = -3571945289928292958L;

        DriveNameAction(String driverName) {
            this.putValue("Name", driverName);
            this.putValue("ShortDescription", LiveecgDeviceDriver.DRIVER_TEXT.getFormattedText("device.holter.driveDescription", (Object)driverName));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton cb = (AbstractButton)e.getSource();
            if (cb.isSelected()) {
                LiveecgDeviceConfigPanel.this.liveecgDeviceDriver.setDriveName(cb.getText());
            }
        }
    }
}

