/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.device;

import com.medset.graphics.TableLayout;
import com.medset.hardware.DeviceSetupPanel;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class LongRecordingsSettingsPanel
extends DeviceSetupPanel {
    private static final long serialVersionUID = -7048223837538558458L;
    private static final double[][] LAYOUT_LONG_RECORDINGS_PANEL = new double[][]{{8.0, -2.0, 8.0}, {8.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, -1.0}};
    private final String TITLE = LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.longRecordingsTitle");
    private JRadioButton button24;
    private JRadioButton button48;
    private long splitOfLongRecordingsInMs = 0L;

    public LongRecordingsSettingsPanel() {
        super((LayoutManager)new TableLayout(LAYOUT_LONG_RECORDINGS_PANEL));
        this.init();
    }

    public LongRecordingsSettingsPanel(long splitOfLongRecordingsInMs) {
        super((LayoutManager)new TableLayout(LAYOUT_LONG_RECORDINGS_PANEL));
        this.splitOfLongRecordingsInMs = splitOfLongRecordingsInMs;
        this.init();
    }

    public void init() {
        this.add(new JLabel(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.longRecordingsHint")), "1, 1");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.button24 = new JRadioButton(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.longRecordings1Day"));
        this.button48 = new JRadioButton(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.longRecordings2Days"));
        if (this.splitOfLongRecordingsInMs == 86400000L) {
            this.button24.setSelected(true);
        } else if (this.splitOfLongRecordingsInMs == 172800000L) {
            this.button48.setSelected(true);
        }
        buttonGroup.add(this.button24);
        buttonGroup.add(this.button48);
        this.add(this.button24, "1, 3");
        this.add(this.button48, "1, 5");
    }

    public void saveSettings() {
        if (this.button24.isSelected()) {
            this.splitOfLongRecordingsInMs = 86400000L;
        } else if (this.button48.isSelected()) {
            this.splitOfLongRecordingsInMs = 172800000L;
        }
    }

    public String getTitle() {
        return this.TITLE;
    }

    public long getSplitOfLongRecordingsInMs() {
        return this.splitOfLongRecordingsInMs;
    }
}

