/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.patient;

import com.medset.database.Patient;
import com.medset.database.Record;
import com.medset.graphics.PatientEditView;
import com.medset.graphics.TableLayout;
import com.medset.hardware.ambulant.assistent.AssistantButton;
import com.medset.hardware.ambulant.assistent.AssistantDialog;
import com.medset.hardware.ambulant.assistent.AssistantPanel;
import com.medset.hardware.ambulant.assistent.NewPatientView;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgSelectDbPatientView;
import com.medset.hardware.ambulant.livetec.view.patient.util.actions.LiveecgVoiceMessageAction;
import com.medset.padsy.PadsyException;
import com.medset.padsy.PadsyServerConnection;
import com.medset.padsy.PadsySession;
import com.medset.padsy.PadsyText;
import com.medset.padsy.ServerConnection;
import com.medset.util.textblocks.TextBlockManager;
import com.medset.util.voice.VoiceMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class LiveecgNewDbPatientView
extends AssistantDialog {
    private static final long serialVersionUID = 5632895650159713376L;
    private static final Logger logger = Logger.getLogger(NewPatientView.class.getName());
    private static final double[][] MAIN_LAYOUT = new double[][]{{-1.0}, {-1.0}};
    private static final double[][] CONTROL_LAYOUT = new double[][]{{-2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0}, {12.0, -2.0}};
    private PadsySession padsySession;
    private Patient patient = null;
    private Patient oldPatient = null;
    private RootPanel rootPanel;
    private VoiceMessage voiceMessage;
    private Icon titleIcon = null;
    private String titleString = null;
    private TextBlockManager textBlockManager;
    private boolean switchToDB;
    private AssistantButton dbButton = null;

    public LiveecgNewDbPatientView(PadsySession padsySession, Patient oldPatient, Icon titleIcon, String titleString, TextBlockManager textBlockManager, VoiceMessage voiceMessage, boolean switchToDB) {
        super(padsySession.getMainFrame(), titleIcon, titleString, true);
        this.padsySession = padsySession;
        this.oldPatient = oldPatient;
        this.titleIcon = titleIcon;
        this.titleString = titleString;
        this.textBlockManager = textBlockManager;
        this.voiceMessage = voiceMessage;
        this.switchToDB = switchToDB;
        this.getMainPanel().setLayout(new BorderLayout());
        this.rootPanel = new RootPanel();
        this.getMainPanel().add((Component)((Object)this.rootPanel), "Center");
        this.getMainPanel().add((Component)new ControlPanel(), "South");
        this.getMainPanel().validate();
        this.rootPanel.grabDefaultFocus();
        this.setVisible(true);
    }

    public void disposeMe() {
        this.setVisible(false);
        this.dispose();
    }

    protected Patient getPatient() {
        return this.patient;
    }

    public AssistantButton getDbButton() {
        return this.dbButton;
    }

    class ControlPanel
    extends JPanel {
        private static final long serialVersionUID = 4422391345350911304L;

        public ControlPanel() {
            super((LayoutManager)new TableLayout(CONTROL_LAYOUT));
            this.setOpaque(false);
            this.add((Component)new AssistantButton(1, (Action)new CancelAction()), "0,1");
            if (LiveecgNewDbPatientView.this.voiceMessage != null) {
                this.add((Component)new AssistantButton(1, (Action)new LiveecgVoiceMessageAction(LiveecgNewDbPatientView.this.voiceMessage)), "2,1");
            }
            if (LiveecgNewDbPatientView.this.switchToDB) {
                LiveecgNewDbPatientView.this.dbButton = new AssistantButton(3, (Action)new SelectFromDBAction());
                LiveecgNewDbPatientView.this.dbButton.setVisible(false);
                this.add((Component)LiveecgNewDbPatientView.this.dbButton, "4,1");
            }
            this.add((Component)new AssistantButton(1, (Action)new OkAction()), "6,1");
        }

        class CancelAction
        extends AbstractAction {
            private static final long serialVersionUID = 593225060976372486L;

            CancelAction() {
                super(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveecgNewDbPatientView.this.disposeMe();
            }
        }

        class OkAction
        extends AbstractAction {
            private static final long serialVersionUID = -5913407643664528276L;

            OkAction() {
                super(PadsyText.getText((String)"OK"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LiveecgNewDbPatientView.this.rootPanel.checkInput()) {
                    LiveecgNewDbPatientView.this.disposeMe();
                } else {
                    LiveecgNewDbPatientView.this.rootPanel.grabDefaultFocus();
                }
            }
        }
    }

    class RootPanel
    extends AssistantPanel {
        private static final long serialVersionUID = -3667411912223854004L;
        private PatientEditView patientEditView;

        public RootPanel() {
            this.setLayout((LayoutManager)new TableLayout(MAIN_LAYOUT));
            this.setBackground(Color.WHITE);
            this.setOpaque(false);
            this.createPanel();
        }

        public void grabDefaultFocus() {
            if (this.patientEditView != null) {
                this.patientEditView.grabDefaultFocus();
            }
        }

        private void createPanel() {
            this.patientEditView = new PatientEditView(LiveecgNewDbPatientView.this.textBlockManager);
            this.patientEditView.empty();
            this.add((Component)this.patientEditView, "0,0");
        }

        protected boolean checkInput() {
            boolean retval = false;
            Patient pat = new Patient();
            try {
                ServerConnection serverConnection = PadsyServerConnection.getInstance();
                if (this.patientEditView.testPatient(pat, null, serverConnection.getPadsyDatabase(), LiveecgNewDbPatientView.this.padsySession.getMainFrame(), true)) {
                    serverConnection.getPadsyDatabase().addRecord((Record)pat, LiveecgNewDbPatientView.this.padsySession.getPadsyUser());
                    pat.logPatient("created");
                    LiveecgNewDbPatientView.this.patient = pat;
                    retval = true;
                } else {
                    Object[] options = new String[]{LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.yes"), LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.no")};
                    if (JOptionPane.showOptionDialog((Component)((Object)this), PadsyText.getText((String)"PatientNotCreated"), LiveecgNewDbPatientView.this.titleString, 0, 2, null, options, options[0]) == 1) {
                        retval = true;
                    }
                }
            }
            catch (PadsyException e) {
                logger.log(Level.WARNING, "Error creating new patient: ", e);
                e.setExit1Text(PadsyText.getText((String)"Ok"));
                e.setExit2Text(null);
                e.setQuestionText(" ");
                LiveecgNewDbPatientView.this.padsySession.showException(e.getTitleText(), e.getHeadingText(), (Throwable)e, null, null, null);
            }
            return retval;
        }
    }

    class SelectFromDBAction
    extends AbstractAction {
        private static final long serialVersionUID = 1575068660174590399L;

        SelectFromDBAction() {
            super(PadsyText.getText((String)"AssistentSelectDatabase"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LiveecgNewDbPatientView.this.disposeMe();
            LiveecgSelectDbPatientView selectPatientView = new LiveecgSelectDbPatientView(LiveecgNewDbPatientView.this.padsySession, LiveecgNewDbPatientView.this.oldPatient, LiveecgNewDbPatientView.this.titleIcon, LiveecgNewDbPatientView.this.titleString, LiveecgNewDbPatientView.this.textBlockManager, LiveecgNewDbPatientView.this.voiceMessage);
            if (selectPatientView.getSelectedPatient() != null) {
                LiveecgNewDbPatientView.this.patient = selectPatientView.getSelectedPatient();
            }
        }
    }
}

