/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.patient;

import com.medset.database.DatabaseException;
import com.medset.database.PadsyDatabase;
import com.medset.database.Patient;
import com.medset.graphics.TableLayout;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.assistent.AssistantBorder;
import com.medset.hardware.ambulant.assistent.AssistantButton;
import com.medset.hardware.ambulant.assistent.AssistantDialog;
import com.medset.hardware.ambulant.assistent.AssistantPanel;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgNewDbPatientView;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgAssistantPatientTableAdapter;
import com.medset.hardware.ambulant.livetec.view.patient.util.actions.LiveecgVoiceMessageAction;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyServerConnection;
import com.medset.padsy.PadsySession;
import com.medset.padsy.PadsyText;
import com.medset.util.table.TableAction;
import com.medset.util.textblocks.TextBlockManager;
import com.medset.util.voice.VoiceMessage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class LiveecgSelectDbPatientView
extends AssistantDialog {
    private static final long serialVersionUID = 3226549962158597175L;
    private static final Logger logger = Logger.getLogger(LiveecgSelectDbPatientView.class.getName());
    private PadsySession padsySession;
    private VoiceMessage voiceMessage;
    private LiveecgAssistantPatientTableAdapter tableModel;
    private Patient oldPatient;
    private Patient selectedPatient;
    private String titleString;
    private Icon titleIcon;
    private TextBlockManager textBlockManager;

    public LiveecgSelectDbPatientView(PadsySession padsySession, Patient oldPatient, Icon titleIcon, String titleString, TextBlockManager textBlockManager, VoiceMessage voiceMessage) {
        super(padsySession.getMainFrame(), titleIcon, titleString, true);
        this.oldPatient = oldPatient;
        this.padsySession = padsySession;
        this.titleString = titleString;
        this.titleIcon = titleIcon;
        this.textBlockManager = textBlockManager;
        this.voiceMessage = voiceMessage;
        this.getMainPanel().setLayout(new BorderLayout());
        this.getMainPanel().setBackground(Color.WHITE);
        this.getMainPanel().setOpaque(false);
        this.getMainPanel().add((Component)this.initPanel(), "Center");
        this.getMainPanel().add((Component)new ControlPanel(), "South");
        this.getMainPanel().validate();
        this.setVisible(true);
    }

    public AssistantPanel initPanel() {
        AssistantPanel activePanel = new AssistantPanel();
        activePanel.setLayout((LayoutManager)new BorderLayout());
        activePanel.setBorder((Border)new AssistantBorder(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.AssistentPatientLabel")));
        activePanel.setBackground(Color.WHITE);
        activePanel.setOpaque(false);
        try {
            PadsyDatabase padsyDatabase = PadsyServerConnection.getInstance().getPadsyDatabase();
            this.tableModel = new LiveecgAssistantPatientTableAdapter(padsyDatabase, this.padsySession.getPadsyProperties(), ((Object)((Object)this)).getClass().getName()){

                @Override
                protected void initTableData() throws DatabaseException {
                    ArrayList<Patient> buffData = new ArrayList<Patient>();
                    ArrayList patienten = this.padsyDB.getPatients(null, false);
                    int i = 0;
                    while (i < patienten.size()) {
                        buffData.add((Patient)patienten.get(i));
                        ++i;
                    }
                    this.setData(buffData);
                }
            };
            this.tableModel.getTable().addMouseListener(new PatientTableListener());
            this.tableModel.getTable().getSelectionModel().setSelectionMode(0);
            this.tableModel.getTable().clearSelection();
            JPanel tableComponent = this.tableModel.getFilterView(false);
            tableComponent.setBackground(Color.WHITE);
            activePanel.add((Component)tableComponent, (Object)"Center");
        }
        catch (Exception e) {
            String errmsg = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.patients.database.table.error");
            logger.log(Level.SEVERE, errmsg, e);
            JOptionPane.showMessageDialog(null, errmsg, LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.data.invalid"), 2);
        }
        return activePanel;
    }

    public Patient getSelectedPatient() {
        return this.selectedPatient;
    }

    public class ControlPanel
    extends JPanel {
        private static final long serialVersionUID = -7543862058754772164L;
        private final double[][] LAYOUT_SIZES = new double[][]{{-2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0}, {12.0, -2.0}};

        public ControlPanel() {
            this.setLayout((LayoutManager)new TableLayout(this.LAYOUT_SIZES));
            AssistantButton cancelButton = new AssistantButton(1, (Action)new CancelAction());
            AssistantButton manuellButton = new AssistantButton(3, (Action)new ManuellAction());
            OkAction okAction = new OkAction();
            AssistantButton okButton = new AssistantButton(1, (Action)((Object)okAction));
            LiveecgSelectDbPatientView.this.tableModel.addTableAction(okAction);
            AssistantButton voiceMessageButton = null;
            if (LiveecgSelectDbPatientView.this.voiceMessage != null) {
                voiceMessageButton = new AssistantButton(1, (Action)new LiveecgVoiceMessageAction(LiveecgSelectDbPatientView.this.voiceMessage));
                this.add((Component)voiceMessageButton, "2, 1");
            }
            this.add((Component)cancelButton, "0,1");
            this.add((Component)manuellButton, "4,1");
            this.add((Component)okButton, "6,1");
        }

        class CancelAction
        extends AbstractAction {
            private static final long serialVersionUID = -1185324646453330165L;

            CancelAction() {
                super(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveecgSelectDbPatientView.this.setVisible(false);
                LiveecgSelectDbPatientView.this.dispose();
            }
        }

        class ManuellAction
        extends AbstractAction {
            private static final long serialVersionUID = 4496951354679884428L;

            ManuellAction() {
                super(PadsyText.getText((String)"NewPatient"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveecgSelectDbPatientView.this.setVisible(false);
                LiveecgSelectDbPatientView.this.dispose();
                String heading = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.new.patient.title");
                LiveecgNewDbPatientView newPatientView = new LiveecgNewDbPatientView(LiveecgSelectDbPatientView.this.padsySession, LiveecgSelectDbPatientView.this.oldPatient, LiveecgSelectDbPatientView.this.titleIcon, heading, LiveecgSelectDbPatientView.this.textBlockManager, LiveecgSelectDbPatientView.this.voiceMessage, true);
                Patient patient = newPatientView.getPatient();
                if (patient != null) {
                    LiveecgSelectDbPatientView.this.selectedPatient = patient;
                }
            }
        }

        class OkAction
        extends TableAction {
            private static final long serialVersionUID = 7836246241884747070L;
            final DriverBundle driverBundle;

            OkAction() {
                super(PadsyText.getText((String)"OK"), null, PadsyText.getText((String)"AssistentChoosePatientAction"), true);
                this.driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
                if (LiveecgSelectDbPatientView.this.selectedPatient == null) {
                    this.setEnabled(false);
                }
            }

            public void actionPerformed(ActionEvent e) {
                Patient patient = (Patient)LiveecgSelectDbPatientView.this.tableModel.getSelectedObjects().get(0);
                if (patient == null) {
                    return;
                }
                String gdtNr = patient.getGdtPatientNr() != null ? patient.getGdtPatientNr() : "";
                String errmsg = this.driverBundle.getText("device.holter.livetec.patients.warning.assign.message");
                if (patient.getPatientId() != null && patient.getPatientId().length() > 0) {
                    errmsg = String.valueOf(errmsg) + "  ID: " + patient.getPatientId() + "\n";
                }
                errmsg = String.valueOf(errmsg) + "  Name: " + patient.getLastname() + ", " + patient.getFirstname() + "\n  Geburtsdatum: " + PadsyDateFormat.format((Date)patient.getBirthdate(), (int)100) + (gdtNr.length() > 0 ? "\n  GDT: " + gdtNr : "");
                Object[] options = new String[]{PadsyText.getText((String)"OK"), LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel")};
                if (JOptionPane.showOptionDialog((Component)((Object)LiveecgSelectDbPatientView.this), errmsg, LiveecgSelectDbPatientView.this.titleString, 0, 2, null, options, options[0]) == 0) {
                    LiveecgSelectDbPatientView.this.setVisible(false);
                    LiveecgSelectDbPatientView.this.dispose();
                    LiveecgSelectDbPatientView.this.selectedPatient = patient;
                    if (LiveecgSelectDbPatientView.this.selectedPatient != null) {
                        LiveecgSelectDbPatientView.this.selectedPatient.logPatient("selected");
                    }
                } else {
                    LiveecgSelectDbPatientView.this.selectedPatient = null;
                }
            }

            public void objectModified(Object record) {
                super.objectModified(record);
            }

            public void selectionChanged(ArrayList records) {
                super.selectionChanged(records);
            }
        }
    }

    protected class PatientTableListener
    extends MouseAdapter {
        protected PatientTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isConsumed()) {
                if (e.getClickCount() == 2 && LiveecgSelectDbPatientView.this.tableModel.getSelectedObjects().size() > 0) {
                    LiveecgSelectDbPatientView.this.selectedPatient = (Patient)LiveecgSelectDbPatientView.this.tableModel.getSelectedObjects().get(0);
                    if (LiveecgSelectDbPatientView.this.selectedPatient != null) {
                        LiveecgSelectDbPatientView.this.selectedPatient.logPatient("selected");
                    }
                    LiveecgSelectDbPatientView.this.setVisible(false);
                    LiveecgSelectDbPatientView.this.dispose();
                }
                e.consume();
            }
        }
    }
}

