/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.patient;

import com.medset.database.Patient;
import com.medset.graphics.PadsyFrameTitle;
import com.medset.graphics.TableLayout;
import com.medset.hardware.DeviceException;
import com.medset.hardware.ambulant.assistent.AssistantDialog;
import com.medset.hardware.ambulant.assistent.AssistantFrame;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgSelectPatientListMainPanel;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgColor;
import com.medset.oem.OemManager;
import com.medset.padsy.PadsySession;
import com.medset.padsy.PadsyText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class LiveecgSelectPatientListDialog
extends AssistantDialog {
    private static final long serialVersionUID = -3071635400429206938L;
    private static final Logger logger = Logger.getLogger(LiveecgSelectPatientListDialog.class.getName());
    private PadsyFrameTitle frameTitlePanel;
    private static final double[][] LAYOUT_FRAME_CONTENT_PANE = new double[][]{{-1.0}, {34.0, -1.0}};
    private LiveecgDeviceDriver liveecgDriver;
    private Patient liveecgPatient = null;
    private boolean carryOn = true;
    private LiveecgSelectPatientListMainPanel mainPanel;

    public LiveecgSelectPatientListDialog(PadsySession padsySession, JFrame parent, String title, Icon icon, Patient liveecgPatient, Patient gdtPatient, LiveecgDeviceDriver liveecgdriver) {
        super(padsySession.getMainFrame(), icon, PadsyText.getFormattedText((String)"AssistentNewPatientFor", (Object)title), true);
        this.liveecgPatient = liveecgPatient;
        this.liveecgDriver = liveecgdriver;
        this.getContentPane().setLayout((LayoutManager)new TableLayout(LAYOUT_FRAME_CONTENT_PANE));
        this.getContentPane().setBackground(LiveecgColor.HELLES_GRAU);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setIconImage(OemManager.getOemHandler().getWindowIcon());
        this.setResizable(true);
        this.frameTitlePanel = new PadsyFrameTitle((Window)((Object)this));
        this.getContentPane().add((Component)this.frameTitlePanel, "0,0");
        this.frameTitlePanel.setTitle(icon, title);
        this.mainPanel = new LiveecgSelectPatientListMainPanel(this, title, icon, liveecgPatient, gdtPatient);
        this.getContentPane().add((Component)((Object)this.mainPanel), "0,1");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.addKeyAction(new EscapeKeyAction());
        this.centerFrame();
        this.setVisible(true);
        this.toFront();
        this.requestFocusInWindow();
    }

    private void centerFrame() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screen.width / 2 - this.getWidth() / 2, screen.height / 2 - this.getHeight() / 2);
    }

    public void dispose() {
        this.setVisible(false);
        if (this.carryOn) {
            this.centerParent();
        }
        super.dispose();
    }

    public void setCarryOn(boolean carryOn) {
        this.carryOn = carryOn;
        this.dispose();
        if (!carryOn) {
            this.disconnectDevice();
        }
    }

    private void centerParent() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.getParent().setLocation(screen.width / 2 - this.getParent().getWidth() / 2, screen.height / 2 - this.getParent().getHeight() / 2);
        ((AssistantFrame)this.getParent()).toFront();
    }

    public void addKeyAction(Action action) {
        this.getRootPane().getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("Name"));
        this.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public Patient getOldPatient() {
        return this.liveecgPatient;
    }

    public LiveecgDeviceDriver getDeviceDriver() {
        return this.liveecgDriver;
    }

    public void disconnectDevice() {
        try {
            this.liveecgDriver.disconnect();
        }
        catch (DeviceException e) {
            String errmsg = "Unable to disconnect the current device.";
            logger.log(Level.SEVERE, errmsg, e);
            JOptionPane.showMessageDialog(null, errmsg, LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.patients.database.device.error"), 2);
        }
    }

    private class EscapeKeyAction
    extends AbstractAction {
        private static final long serialVersionUID = -6771606568736778307L;

        private EscapeKeyAction() {
            super("AssistantDialogEscapeAction");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LiveecgSelectPatientListDialog.this.setCarryOn(false);
        }
    }
}

