/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.patient;

import com.medset.database.PadsyDatabase;
import com.medset.database.Patient;
import com.medset.graphics.TableLayout;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.assistent.AssistantBorder;
import com.medset.hardware.ambulant.assistent.AssistantButton;
import com.medset.hardware.ambulant.assistent.AssistantMessage;
import com.medset.hardware.ambulant.assistent.AssistantPanel;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgSelectDbPatientView;
import com.medset.hardware.ambulant.livetec.view.patient.LiveecgSelectPatientListDialog;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgAssistantPatientTableAdapter;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgDbPatientSelect;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgRowColPatientIdRenderer;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgRowColTypeRenderer;
import com.medset.hardware.ambulant.livetec.view.patient.util.LiveecgSpecialRowCellRenderer;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyServerConnection;
import com.medset.padsy.PadsyText;
import com.medset.util.table.TableAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LiveecgSelectPatientListMainPanel
extends AssistantPanel {
    private static final long serialVersionUID = 5449403559519849850L;
    private static final Logger logger = Logger.getLogger(LiveecgSelectPatientListMainPanel.class.getName());
    private final double[][] LAYOUT_MAIN_PANEL = new double[][]{{12.0, -1.0, 12.0, 117.0, 12.0}, {12.0, 57.0, 12.0, -1.0, 12.0, -2.0, 12.0}};
    private static final double[][] LAYOUT_ACTION_PANEL = new double[][]{{-2.0, -1.0, -3.0, -1.0, -2.0}, {-2.0}};
    private LiveecgSelectPatientListDialog liveecgPatientSelectDialog = null;
    private Icon icon = null;
    private String title = "";
    LiveecgAssistantPatientTableAdapter tableModel = null;
    private AssistantButton okButton = null;
    private AssistantButton cancelButton = null;
    private AssistantButton newPatientButton = null;
    private AssistantMessage message = null;
    private Patient liveecgPatient;
    private Patient gdtPatient;
    private Patient selectedPatient;

    public LiveecgSelectPatientListMainPanel(LiveecgSelectPatientListDialog liveecgPatientSelectDialog, String title, Icon icon, Patient liveecgPatient, Patient gdtPatient) {
        this.liveecgPatientSelectDialog = liveecgPatientSelectDialog;
        this.icon = icon;
        this.title = title;
        this.liveecgPatient = liveecgPatient;
        this.gdtPatient = gdtPatient;
        this.setLayout((LayoutManager)new TableLayout(this.LAYOUT_MAIN_PANEL));
        this.setOpaque(false);
        this.init();
    }

    private void init() {
        this.removeAll();
        this.message = new AssistantMessage(""){
            private static final long serialVersionUID = 4422068348493240139L;
            private boolean fsttime;
            private String myText;
            {
                this.fsttime = true;
                this.myText = "";
            }

            public void setAlertText(String text) {
                this.myText = text;
            }

            public void setText(String text) {
                this.myText = text;
            }

            public String getText() {
                if (this.fsttime) {
                    this.fsttime = false;
                    return this.myText.length() > 120 ? this.myText.substring(0, 120) : this.myText;
                }
                return this.myText;
            }

            public Rectangle getBounds() {
                return new Rectangle(0, 0, 770, 50);
            }

            public void setBounds(Rectangle bounds) {
            }
        };
        AssistantPanel patientListPanel = this.createPatientListPanel();
        JPanel actionPanel = this.createActionPanel();
        actionPanel.setBounds(0, 0, 0, 0);
        this.add((Component)this.message, "1,1,3,1");
        this.add((Component)patientListPanel, "1,3,3,3");
        this.add(actionPanel, "1,5,3,5");
        this.okButton.setEnabled(this.selectedPatient != null);
        this.validate();
        if (this.tableModel.getFullObjectCount() > 0) {
            this.message.setText(LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.patients.selection.match.message"));
        } else {
            this.message.setText(LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.patients.selection.nomatch.message"));
        }
    }

    private JPanel createActionPanel() {
        final DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
        JPanel retval = new JPanel((LayoutManager)new TableLayout(LAYOUT_ACTION_PANEL));
        retval.setOpaque(false);
        OkAction okAction = new OkAction();
        this.okButton = new AssistantButton(1, (Action)((Object)okAction)){
            private static final long serialVersionUID = 5466598532175944349L;

            public void setEnabled(boolean enable) {
                super.setEnabled(enable);
            }
        };
        this.tableModel.addTableAction(okAction);
        this.cancelButton = new AssistantButton(1, (Action)new AbstractAction(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel")){
            private static final long serialVersionUID = 5104535433171858848L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String errmsg = driverBundle.getText("device.holter.livetec.patients.warning.message");
                Object[] options = new String[]{LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.yes"), LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.no")};
                if (JOptionPane.showOptionDialog((Component)((Object)LiveecgSelectPatientListMainPanel.this.liveecgPatientSelectDialog), errmsg, LiveecgSelectPatientListMainPanel.this.title, 0, 0, null, options, options[0]) == 0) {
                    LiveecgSelectPatientListMainPanel.this.liveecgPatientSelectDialog.setCarryOn(false);
                }
            }
        });
        this.newPatientButton = new AssistantButton(1, (Action)new AbstractAction(PadsyText.getText((String)"AssistentSelectDatabase")){
            private static final long serialVersionUID = -7582345874549539602L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveecgSelectPatientListMainPanel.this.selectDbOrNewPatientStep();
            }
        });
        this.newPatientButton.setToolTipText(driverBundle.getText("device.holter.livetec.recordings.db.new.patient"));
        this.cancelButton.setEnabled(true);
        this.newPatientButton.setEnabled(true);
        this.okButton.setEnabled(true);
        retval.add((Component)this.cancelButton, "0,0");
        retval.add((Component)this.newPatientButton, "2,0");
        retval.add((Component)this.okButton, "4,0");
        retval.setVisible(true);
        return retval;
    }

    public void selectDbOrNewPatientStep() {
        String heading = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.db.patient.title");
        LiveecgSelectDbPatientView newDbPatientView = new LiveecgSelectDbPatientView(this.liveecgPatientSelectDialog.getDeviceDriver().getPadsySession(), this.liveecgPatient, this.icon, heading, null, null);
        if (newDbPatientView.getSelectedPatient() != null) {
            this.registerPatient(newDbPatientView.getSelectedPatient());
            this.liveecgPatientSelectDialog.dispose();
        }
    }

    private void registerPatient(Patient newPatient) {
        if (newPatient != null) {
            this.liveecgPatientSelectDialog.getDeviceDriver().setPatient(newPatient);
            this.liveecgPatientSelectDialog.getDeviceDriver().setPatientFirstName(newPatient.getFirstname());
            this.liveecgPatientSelectDialog.getDeviceDriver().setPatientLastName(newPatient.getLastname());
            this.liveecgPatientSelectDialog.getDeviceDriver().setPatientId(newPatient.getPatientId());
            this.liveecgPatientSelectDialog.getDeviceDriver().setBirthDate(newPatient.getBirthdate());
            this.liveecgPatientSelectDialog.getDeviceDriver().getAmbulantDeviceAssistant().setPatient(newPatient);
            logger.log(Level.INFO, "!!!!!!!!! Driver: " + this.liveecgPatientSelectDialog.getDeviceDriver());
            logger.log(Level.INFO, "!!!!!!!!! Assistant: " + this.liveecgPatientSelectDialog.getDeviceDriver().getAmbulantDeviceAssistant());
        }
    }

    public AssistantPanel createPatientListPanel() {
        AssistantPanel activePanel = new AssistantPanel();
        activePanel.setLayout((LayoutManager)new BorderLayout());
        activePanel.setBorder((Border)new AssistantBorder(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.AssistentPatientLabel")));
        activePanel.setBackground(Color.WHITE);
        activePanel.setOpaque(false);
        try {
            PadsyDatabase padsyDatabase = PadsyServerConnection.getInstance().getPadsyDatabase();
            this.tableModel = new LiveecgAssistantPatientTableAdapter(padsyDatabase, this.liveecgPatientSelectDialog.getDeviceDriver().getAmbulantDeviceAssistant().getPadsySession().getPadsyProperties(), ((Object)((Object)this)).getClass().getName());
            this.tableModel.getTable().addMouseListener(new PatientTableListener());
            this.tableModel.getTable().getSelectionModel().setSelectionMode(0);
            this.tableModel.getTable().clearSelection();
            JPanel tableComponent = this.tableModel.getFilterView(false);
            tableComponent.setBackground(Color.WHITE);
            activePanel.add((Component)tableComponent, (Object)"Center");
            List<Patient> matchPatients = LiveecgDbPatientSelect.getMatchPatients(this.liveecgPatient);
            LiveecgDbPatientSelect.addPatientsByPatientIdOrGdtIdToMatchPatientList(padsyDatabase, this.liveecgPatient.getPdbKey(), this.gdtPatient != null ? this.gdtPatient.getGdtPatientNr() : null, matchPatients);
            this.tableModel.setData((ArrayList)matchPatients);
            this.setupSpecialRowsRenderer();
            this.tableModel.getTable().clearSelection();
        }
        catch (Exception e) {
            String errmsg = LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.patients.database.table.error");
            logger.log(Level.SEVERE, errmsg, e);
            JOptionPane.showMessageDialog(null, errmsg, LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.data.invalid"), 2);
        }
        this.tableModel.getTable().removeMouseListener(this.tableModel.getTable().getMouseListeners()[2]);
        return activePanel;
    }

    private void setupSpecialRowsRenderer() {
        block10: {
            TableColumn column;
            int colinx;
            int bestmatchCnt;
            Patient[] bestmatchPatient;
            int liveecgMatchCnt;
            JTable table;
            block9: {
                table = this.tableModel.getTable();
                TableColumn tableColumn = new TableColumn();
                tableColumn.sizeWidthToFit();
                tableColumn.setIdentifier("Type");
                tableColumn.setHeaderValue(LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.newpatient.datasource"));
                table.getColumnModel().addColumn(tableColumn);
                Font font = table.getFont();
                Font fonttable = new Font(font.getFamily(), 0, 16);
                int colinx2 = 0;
                while (colinx2 < table.getColumnModel().getColumnCount()) {
                    LiveecgRowColTypeRenderer cellRenderer = colinx2 == 6 ? new LiveecgRowColTypeRenderer() : (colinx2 == 5 ? new LiveecgRowColPatientIdRenderer() : new LiveecgSpecialRowCellRenderer());
                    cellRenderer.setTableModel(this.tableModel);
                    cellRenderer.setFont(fonttable);
                    TableColumn column2 = table.getColumnModel().getColumn(colinx2);
                    column2.setCellRenderer((TableCellRenderer)((Object)cellRenderer));
                    ++colinx2;
                }
                liveecgMatchCnt = 0;
                int patientcnt = this.tableModel.getObjectCount();
                bestmatchPatient = new Patient[patientcnt];
                bestmatchCnt = 0;
                int rowinx = 0;
                while (rowinx < patientcnt) {
                    Patient pat = (Patient)this.tableModel.getObjectAt(rowinx);
                    if (this.gdtPatient != null && this.gdtPatient.getGdtPatientNr().equals(pat.getGdtPatientNr())) {
                        int colinx3 = 0;
                        while (colinx3 < table.getColumnModel().getColumnCount()) {
                            TableColumn column3 = table.getColumnModel().getColumn(colinx3);
                            ((LiveecgSpecialRowCellRenderer)((Object)column3.getCellRenderer())).setGdtRow(pat);
                            ++colinx3;
                        }
                    } else if (pat.getFirstname().equalsIgnoreCase(this.liveecgPatient.getFirstname()) && pat.getLastname().equalsIgnoreCase(this.liveecgPatient.getLastname()) && pat.getBirthdate().equals(this.liveecgPatient.getBirthdate())) {
                        ++liveecgMatchCnt;
                        if (pat.getPatientId().equalsIgnoreCase(this.liveecgPatient.getPdbKey())) {
                            bestmatchPatient[bestmatchCnt++] = pat;
                        }
                    }
                    ++rowinx;
                }
                if (liveecgMatchCnt != 0) break block9;
                this.tableModel.addObject(this.liveecgPatient);
                colinx = 0;
                while (colinx < table.getColumnModel().getColumnCount()) {
                    column = table.getColumnModel().getColumn(colinx);
                    ((LiveecgSpecialRowCellRenderer)((Object)column.getCellRenderer())).setLiveecgRow(this.liveecgPatient);
                    ++colinx;
                }
                break block10;
            }
            if (liveecgMatchCnt < true || bestmatchCnt != true) break block10;
            colinx = 0;
            while (colinx < table.getColumnModel().getColumnCount()) {
                column = table.getColumnModel().getColumn(colinx);
                ((LiveecgSpecialRowCellRenderer)((Object)column.getCellRenderer())).setLiveecgRow(bestmatchPatient[bestmatchCnt - 1]);
                ++colinx;
            }
        }
    }

    private boolean isUndefinedLiveecgPatient(Patient patient) {
        return patient.getLastname().equalsIgnoreCase("Default") && patient.getFirstname().equalsIgnoreCase("Default") && this.liveecgPatient.equals((Object)patient);
    }

    private String getPatientId(Patient selectedPatient) {
        String patientid = !(selectedPatient.getPatientId() != null && selectedPatient.getPatientId().length() != 0 || selectedPatient.getPdbKey() == null && selectedPatient.getPdbKey().startsWith("PDB-") || selectedPatient.getGdtPatientNr() != null && selectedPatient.getGdtPatientNr().length() != 0) ? selectedPatient.getPdbKey() : selectedPatient.getPatientId();
        return patientid != null && patientid.startsWith("PDB-") ? "" : patientid;
    }

    class OkAction
    extends TableAction {
        private static final long serialVersionUID = 7836246241884747070L;
        final DriverBundle driverBundle;

        OkAction() {
            super(PadsyText.getText((String)"OK"), null, PadsyText.getText((String)"AssistentChoosePatientAction"), true);
            this.driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
            if (LiveecgSelectPatientListMainPanel.this.selectedPatient == null) {
                this.setEnabled(false);
            }
        }

        public void objectModified(Object record) {
            super.objectModified(record);
        }

        public void selectionChanged(ArrayList records) {
            if (records != null && records.size() > 0 && records.get(0) instanceof Patient) {
                LiveecgSelectPatientListMainPanel.this.selectedPatient = (Patient)records.get(0);
            }
            super.selectionChanged(records);
        }

        public void actionPerformed(ActionEvent arg0) {
            String gdtNr = LiveecgSelectPatientListMainPanel.this.selectedPatient.getGdtPatientNr() != null ? LiveecgSelectPatientListMainPanel.this.selectedPatient.getGdtPatientNr() : "";
            String errmsg = this.driverBundle.getText("device.holter.livetec.patients.warning.assign.message");
            if (LiveecgSelectPatientListMainPanel.this.selectedPatient.getPatientId() != null && LiveecgSelectPatientListMainPanel.this.selectedPatient.getPatientId().length() > 0) {
                errmsg = String.valueOf(errmsg) + "  ID: " + LiveecgSelectPatientListMainPanel.this.selectedPatient.getPatientId() + "\n";
            }
            errmsg = String.valueOf(errmsg) + "  Name: " + LiveecgSelectPatientListMainPanel.this.selectedPatient.getLastname() + ", " + LiveecgSelectPatientListMainPanel.this.selectedPatient.getFirstname() + "\n  Geburtsdatum: " + PadsyDateFormat.format((Date)LiveecgSelectPatientListMainPanel.this.selectedPatient.getBirthdate(), (int)100) + (gdtNr.length() > 0 ? "\n  GDT: " + gdtNr : "");
            Object[] options = new String[]{PadsyText.getText((String)"OK"), LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel")};
            if (JOptionPane.showOptionDialog((Component)((Object)LiveecgSelectPatientListMainPanel.this.liveecgPatientSelectDialog), errmsg, LiveecgSelectPatientListMainPanel.this.title, 0, 2, null, options, options[0]) == 0) {
                LiveecgSelectPatientListMainPanel.this.registerPatient(LiveecgSelectPatientListMainPanel.this.selectedPatient);
                logger.log(Level.INFO, "selected Patient: " + LiveecgSelectPatientListMainPanel.this.selectedPatient.getRecordID() + " " + LiveecgSelectPatientListMainPanel.this.selectedPatient.getLastname());
                LiveecgSelectPatientListMainPanel.this.liveecgPatientSelectDialog.dispose();
            }
        }
    }

    protected class PatientTableListener
    extends MouseAdapter {
        protected PatientTableListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Patient patient;
            if (LiveecgSelectPatientListMainPanel.this.tableModel.getSelectedObjects().size() > 0 && (patient = (Patient)LiveecgSelectPatientListMainPanel.this.tableModel.getSelectedObjects().get(0)) != null) {
                if (LiveecgSelectPatientListMainPanel.this.isUndefinedLiveecgPatient(patient)) {
                    LiveecgSelectPatientListMainPanel.this.selectDbOrNewPatientStep();
                    LiveecgSelectPatientListMainPanel.this.tableModel.setSelectedObjects(null);
                } else {
                    LiveecgSelectPatientListMainPanel.this.selectedPatient = patient;
                    LiveecgSelectPatientListMainPanel.this.selectedPatient.logPatient("selected");
                }
            }
        }
    }
}

