/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.patient.util;

import com.medset.database.DatabaseException;
import com.medset.database.GdtPatientFilter;
import com.medset.database.PadsyDatabase;
import com.medset.database.Patient;
import com.medset.database.PatientIdFilter;
import com.medset.database.PatientIgnoreCaseFilter;
import com.medset.database.RecordFilter;
import com.medset.padsy.PadsyServerConnection;
import com.medset.padsy.ServerConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class LiveecgDbPatientSelect {
    private static final Logger logger = Logger.getLogger(LiveecgDbPatientSelect.class.getName());

    public static List<Patient> getMatchPatients(Patient patient) {
        ArrayList matchPatientList = new ArrayList();
        String patientId = patient.getPdbKey();
        try {
            ServerConnection padsyServerConnection = PadsyServerConnection.getInstance();
            PadsyDatabase padsyDatabase = padsyServerConnection.getPadsyDatabase();
            Object filter = null;
            filter = patient.getLastname().equalsIgnoreCase("Default") && patient.getFirstname().equalsIgnoreCase("Default") ? new PatientIdFilter(patient.getPatientId()) : new PatientIgnoreCaseFilter(patient.getLastname(), patient.getFirstname(), patient.getBirthdate());
            matchPatientList = padsyDatabase.getPatients((RecordFilter)filter, true);
        }
        catch (Exception e) {
            String errmsg = "Fehler bei Patientensuche im Datenbank mit PatientId<" + patientId + ">\n";
            logger.severe(errmsg);
            throw new RuntimeException(errmsg, e);
        }
        return matchPatientList;
    }

    public static List<Patient> addPatientsByPatientIdOrGdtIdToMatchPatientList(PadsyDatabase padsyDatabase, String patientId, String gdtId, List<Patient> patientList) {
        if (patientId == null || patientId.length() == 0) {
            return patientList;
        }
        try {
            GdtPatientFilter filter = null;
            filter = new GdtPatientFilter(patientId);
            ArrayList gdtList = padsyDatabase.getPatients((RecordFilter)filter, true);
            patientList.addAll(gdtList);
        }
        catch (DatabaseException e) {
            String errmsg = "Fehler bei Patientensuche im Datenbank mit PatientId<" + patientId + ">\n";
            logger.severe(errmsg);
            throw new RuntimeException(errmsg, e);
        }
        return patientList;
    }
}

