/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording;

import com.medset.database.Patient;
import com.medset.graphics.PadsyFrameTitle;
import com.medset.hardware.ambulant.assistent.AssistantFrame;
import com.medset.hardware.ambulant.assistent.RecordPanel;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecordingTableModel;
import com.medset.hardware.ambulant.livetec.view.recording.LiveecgRecordingsMainPanel;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgColor;
import com.medset.oem.OemManager;
import com.medset.padsy.PadsyText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class LiveecgRecordingsDialog
extends JDialog {
    private static final long serialVersionUID = 3076397766086355778L;
    private PadsyFrameTitle frameTitlePanel;
    private static final double[][] LAYOUT_FRAME_CONTENT_PANE = new double[][]{{-1.0}, {34.0, -1.0}};
    private LiveecgRecordingTableModel model;
    private LiveecgDeviceDriver liveecgDriver;
    private boolean autoCalcOld = false;
    private boolean autoCalc = false;

    public LiveecgRecordingsDialog(JFrame parent, String title, Icon icon, Patient patient, LiveecgDeviceDriver liveecgdriver, List<LiveecgRecording> liveecgrecording, boolean autocalc) {
        super((Frame)parent, false);
        this.liveecgDriver = liveecgdriver;
        this.autoCalcOld = autocalc;
        this.setAutoCalc(autocalc);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(LiveecgColor.HELLES_GRAU);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        this.setIconImage(OemManager.getOemHandler().getWindowIcon());
        this.setResizable(true);
        this.frameTitlePanel = new PadsyFrameTitle((Window)this);
        this.getContentPane().add((Component)this.frameTitlePanel, "North");
        this.frameTitlePanel.setTitle(icon, title);
        this.frameTitlePanel.setPatient(patient);
        this.model = new LiveecgRecordingTableModel(liveecgrecording);
        this.getContentPane().add((Component)new LiveecgRecordingsMainPanel(this, this.model, title), "Center");
        this.setDefaultCloseOperation(2);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screen.width / 2 - this.getWidth() / 2, screen.height / 2 - this.getHeight() / 2);
        this.addKeyboardAction(new EscapeAction());
        this.setVisible(true);
        this.toFront();
        this.requestFocusInWindow();
    }

    @Override
    public void dispose() {
        if (this.autoCalcOld != this.isAutoCalc()) {
            this.liveecgDriver.setAutoCalc(this.isAutoCalc(), true);
        }
        this.setVisible(false);
        this.centerParent();
        super.dispose();
    }

    private void centerParent() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.getParent().setLocation(screen.width / 2 - this.getParent().getWidth() / 2, screen.height / 2 - this.getParent().getHeight() / 2);
        ((AssistantFrame)this.getParent()).toFront();
    }

    public void addKeyboardAction(Action action) {
        this.getRootPane().getInputMap(2).put((KeyStroke)action.getValue("AcceleratorKey"), action.getValue("Name"));
        this.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    public void setAutoCalc(boolean autocalc) {
        this.autoCalc = autocalc;
    }

    public boolean isAutoCalc() {
        return this.autoCalc;
    }

    public void changeAssistantStartDateTime(long ldate, long ltime) {
        Date date = new Date(ldate);
        Date time = new Date(ltime);
        String sdate = new SimpleDateFormat("dd.MM.yyyy").format(date);
        String stime = new SimpleDateFormat("HH:mm:ss").format(time);
        RecordPanel recordpanel = this.liveecgDriver.getRecordPanel();
        JPanel applicationPanel = (JPanel)recordpanel.getComponents()[0];
        JPanel panel = (JPanel)applicationPanel.getComponents()[0];
        JLabel label = (JLabel)panel.getComponents()[1];
        label.setText(String.valueOf(sdate) + " " + stime);
    }

    private String formatRecordingLength(int length) {
        int dauerInSec = length / 1000;
        if (dauerInSec < 60) {
            return String.valueOf(String.valueOf(dauerInSec)) + " " + PadsyText.getText((String)"AssistentSekAbbreviation");
        }
        int hour = dauerInSec / 60 / 60;
        int min = dauerInSec / 60 % 60;
        DecimalFormat df = new DecimalFormat("00");
        String dauerParam = String.valueOf(df.format(hour)) + ":" + df.format(min);
        return dauerParam;
    }

    public void changeAssistantDuration(int duration) {
        RecordPanel recordpanel = this.liveecgDriver.getRecordPanel();
        JPanel durationPanel = (JPanel)recordpanel.getComponents()[0];
        JPanel panel = (JPanel)durationPanel.getComponents()[1];
        JLabel label = (JLabel)panel.getComponents()[1];
        label.setText(this.formatRecordingLength(duration));
    }

    public void createSelectPatientView() {
        this.liveecgDriver.createSelectPatientView();
    }

    public void setGdtPatientActive() {
        this.liveecgDriver.setGdtPatientActive();
    }

    public boolean isGdtPatientDiff() {
        return this.liveecgDriver.isGdtPatientDiff();
    }

    public String getGdtPatientProfile() {
        return this.liveecgDriver.getGdtPatientProfile();
    }

    public void stopOperation() {
        this.setVisible(false);
        AssistantFrame assistant = (AssistantFrame)this.getParent();
        assistant.dispose();
        super.dispose();
    }

    private class EscapeAction
    extends AbstractAction {
        private static final long serialVersionUID = -1710321034342467878L;

        private EscapeAction() {
            super("AssistantDialogEscapeAction");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LiveecgRecordingsDialog.this.dispose();
        }
    }
}

