/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording;

import com.medset.graphics.TableLayout;
import com.medset.hardware.DriverBundle;
import com.medset.hardware.ambulant.assistent.AssistantButton;
import com.medset.hardware.ambulant.assistent.AssistantMessage;
import com.medset.hardware.ambulant.livetec.LiveecgDeviceDriver;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecording;
import com.medset.hardware.ambulant.livetec.model.LiveecgRecordingTableModel;
import com.medset.hardware.ambulant.livetec.view.recording.LiveecgRecordingsDialog;
import com.medset.hardware.ambulant.livetec.view.recording.LivetecAssistantMessage;
import com.medset.hardware.ambulant.livetec.view.recording.LivetecErrorTableCellRenderer;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgColor;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgDateOnlyCellRenderer;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgDatePickerCellEditor;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgRecordingLengthRenderer;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgTimeEditor;
import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgTimeOnlyCellRenderer;
import com.medset.padsy.PadsyDateFormat;
import com.medset.padsy.PadsyText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LiveecgRecordingsMainPanel
extends JPanel
implements ListSelectionListener {
    private static Logger logger = Logger.getLogger(LiveecgRecordingsMainPanel.class.getName());
    private static final long serialVersionUID = -9114476524670411895L;
    private final double[][] LAYOUT_MAIN_PANEL = new double[][]{{12.0, -1.0, 12.0, 117.0, 12.0}, {12.0, 77.0, 12.0, -1.0, 12.0, -2.0, 12.0}};
    private static final double[][] LAYOUT_ACTION_PANEL = new double[][]{{-2.0, -1.0, -2.0, -1.0, -2.0}, {-2.0}};
    private LiveecgRecordingTableModel model = null;
    private LiveecgRecordingsDialog parentDialog = null;
    private JTable table = null;
    private String title = "";
    private JButton autocalcButton = null;
    private AssistantMessage message = null;
    private AssistantButton defaultButton = null;
    private AssistantButton cancelButton = null;
    private AssistantButton resetButton = null;
    private int lastSelectionIndex = -1;
    private SimpleDateFormat timeDateFormat = new SimpleDateFormat("HH:mm:ss");
    private boolean inputModified = false;
    private LiveecgTimeEditor timeeditor = null;
    private LiveecgDatePickerCellEditor datepickereditor = null;

    public LiveecgRecordingsMainPanel(LiveecgRecordingsDialog parent, LiveecgRecordingTableModel model, String title) {
        this.setLayout((LayoutManager)new TableLayout(this.LAYOUT_MAIN_PANEL));
        this.setOpaque(false);
        this.model = model;
        this.parentDialog = parent;
        this.title = title;
        this.init();
    }

    public void init() {
        this.removeAll();
        DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
        this.message = new LivetecAssistantMessage("");
        this.message.setBounds(0, 0, 0, 0);
        JPanel cbpanel = new JPanel();
        cbpanel.setLayout(new BorderLayout());
        cbpanel.setBackground(LiveecgColor.DUNKLES_GRAU);
        final JCheckBox cb = new JCheckBox("");
        cb.setVisible(true);
        cb.setAction(new AbstractAction(driverBundle.getText("device.holter.livetec.recordings.autocalcison")){
            private static final long serialVersionUID = -879778769095011702L;

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveecgRecordingsMainPanel.this.parentDialog.setAutoCalc(cb.isSelected());
                LiveecgRecordingsMainPanel.this.autocalcButton.setEnabled(!cb.isSelected());
                if (cb.isSelected()) {
                    LiveecgRecordingsMainPanel.this.stopTableEdition();
                    LiveecgRecordingsMainPanel.this.autoRecalc(true, true);
                    LiveecgRecordingsMainPanel.this.parentDialog.setAutoCalc(true);
                }
            }
        });
        cb.setSelected(this.parentDialog.isAutoCalc());
        cb.setBackground(LiveecgColor.DUNKLES_GRAU);
        this.autocalcButton = new AssistantButton(1, (Action)new AbstractAction(driverBundle.getText("device.holter.livetec.recordings.autocalc")){
            private static final long serialVersionUID = -5380410296998902387L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LiveecgRecordingsMainPanel.this.getTable() != null) {
                    LiveecgRecordingsMainPanel.this.stopTableEdition();
                    LiveecgRecordingsMainPanel.this.autoRecalc(false, true);
                }
            }
        });
        this.autocalcButton.setToolTipText(driverBundle.getText("device.holter.livetec.recordings.autocalc.presstoactivate"));
        if (this.model.getLiveecgRecordings().size() <= 1) {
            this.autocalcButton.setEnabled(false);
            cb.setVisible(false);
        } else {
            this.autocalcButton.setEnabled(true);
            cb.setEnabled(true);
        }
        cbpanel.add((Component)this.autocalcButton, "South");
        cbpanel.add((Component)cb, "North");
        JPanel actionPanel = this.createActionPanel();
        actionPanel.setBounds(0, 0, 0, 0);
        JScrollPane scrollPane = new JScrollPane(this.createTable());
        scrollPane.setBounds(0, 0, 0, 0);
        this.add((Component)this.message, "1,1");
        this.add((Component)cbpanel, "3,1");
        this.add((Component)scrollPane, "1,3,3,3");
        this.add((Component)actionPanel, "1,5,3,5");
        this.validate();
        if (this.parentDialog.isAutoCalc()) {
            this.recalcTimings(0, false);
        }
        this.validateRecordings();
    }

    private void stopTableEdition() {
        if (this.table.isEditing()) {
            this.table.editingCanceled(null);
        }
    }

    private JTable createTable() {
        this.table = new JTable(this.model);
        this.table.setRowHeight(30);
        Font font = this.table.getFont();
        Font fonttable = new Font(font.getFamily(), 0, 15);
        this.table.setFont(fonttable);
        Font fontheader = new Font(font.getFamily(), 1, 15);
        this.table.getTableHeader().setFont(fontheader);
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(this);
        CellEditorListener celleditorlistener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                Object ed;
                int oldrow = LiveecgRecordingsMainPanel.this.table.getSelectedRow();
                int oldcol = LiveecgRecordingsMainPanel.this.table.getSelectedColumn();
                logger.finest("++++++ editingStopped < " + e.getSource() + "> " + oldrow + " " + oldcol);
                if (oldcol == 1) {
                    ed = (LiveecgDatePickerCellEditor)((Object)LiveecgRecordingsMainPanel.this.table.getCellEditor(oldrow, oldcol));
                    Date newDate = ed.getCellEditorValue();
                    Calendar now = Calendar.getInstance();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(newDate);
                    if (cal.compareTo(now) >= 0) {
                        Date oldValue = ((LiveecgDatePickerCellEditor)ed).getOldValue();
                        LiveecgRecordingsMainPanel.this.table.setValueAt(oldValue, oldrow, oldcol);
                    }
                }
                if (oldcol == 2) {
                    ed = (LiveecgTimeEditor)LiveecgRecordingsMainPanel.this.table.getCellEditor(oldrow, oldcol);
                    ((LiveecgTimeEditor)ed).checkTextValid();
                    String newtime = ((LiveecgTimeEditor)ed).getTime();
                    Date setdtime = (Date)LiveecgRecordingsMainPanel.this.table.getColumnModel().getColumn(oldcol).getCellEditor().getCellEditorValue();
                    String settime = LiveecgRecordingsMainPanel.this.timeDateFormat.format(setdtime);
                    if (newtime != null && !newtime.isEmpty() && !newtime.equals(settime)) {
                        try {
                            logger.finest("++++++ table.setValueAt <" + e.getSource() + "> " + newtime);
                            LiveecgRecordingsMainPanel.this.table.setValueAt(LiveecgRecordingsMainPanel.this.timeDateFormat.parse(newtime), oldrow, oldcol);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ((LiveecgTimeEditor)ed).setTime(null);
                }
                LiveecgRecordingsMainPanel.this.setInputModified(true);
                int lasterrrow = LiveecgRecordingsMainPanel.this.getLastErrorRow();
                if (LiveecgRecordingsMainPanel.this.parentDialog.isAutoCalc()) {
                    LiveecgRecordingsMainPanel.this.autoRecalc(true, false);
                }
                LiveecgRecordingsMainPanel.this.validateRecordings();
                int errrow = LiveecgRecordingsMainPanel.this.getErrorRowInx(LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings());
                if (errrow != -1 && oldrow != errrow && lasterrrow != errrow) {
                    LiveecgRecordingsMainPanel.this.table.editCellAt(errrow, 1);
                    LiveecgRecordingsMainPanel.this.table.transferFocus();
                    LiveecgRecordingsMainPanel.this.table.setRowSelectionInterval(errrow, errrow);
                }
                ((AbstractTableModel)LiveecgRecordingsMainPanel.this.table.getModel()).fireTableDataChanged();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                logger.finest("++++++++++ editingCanceled <" + e.getSource() + ">");
                if (LiveecgRecordingsMainPanel.this.parentDialog.isAutoCalc()) {
                    LiveecgRecordingsMainPanel.this.autoRecalc(true, false);
                }
                LiveecgRecordingsMainPanel.this.validateRecordings();
            }
        };
        CellEditorListener timeCelleditorlistener = new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                int oldrow = LiveecgRecordingsMainPanel.this.table.getSelectedRow();
                int oldcol = LiveecgRecordingsMainPanel.this.table.getSelectedColumn();
                logger.finest("++++++ editingStopped < " + e.getSource() + "> " + oldrow + " " + oldcol);
                if (oldcol == 2) {
                    LiveecgTimeEditor ed = (LiveecgTimeEditor)LiveecgRecordingsMainPanel.this.table.getCellEditor(oldrow, oldcol);
                    ed.checkTextValid();
                    String newtime = ed.getTime();
                    Date setdtime = (Date)LiveecgRecordingsMainPanel.this.table.getColumnModel().getColumn(oldcol).getCellEditor().getCellEditorValue();
                    String settime = LiveecgRecordingsMainPanel.this.timeDateFormat.format(setdtime);
                    if (newtime != null && !newtime.isEmpty() && !newtime.equals(settime)) {
                        try {
                            logger.finest("++++++ table.setValueAt <" + e.getSource() + "> " + newtime);
                            LiveecgRecordingsMainPanel.this.table.setValueAt(LiveecgRecordingsMainPanel.this.timeDateFormat.parse(newtime), oldrow, oldcol);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ed.setTime(null);
                }
                LiveecgRecordingsMainPanel.this.setInputModified(true);
                int lasterrrow = LiveecgRecordingsMainPanel.this.getLastErrorRow();
                if (LiveecgRecordingsMainPanel.this.parentDialog.isAutoCalc()) {
                    LiveecgRecordingsMainPanel.this.autoRecalc(true, false);
                }
                LiveecgRecordingsMainPanel.this.validateRecordings();
                int errrow = LiveecgRecordingsMainPanel.this.getErrorRowInx(LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings());
                if (errrow != -1 && oldrow != errrow && lasterrrow != errrow) {
                    LiveecgRecordingsMainPanel.this.table.editCellAt(errrow, 1);
                    LiveecgRecordingsMainPanel.this.table.transferFocus();
                    LiveecgRecordingsMainPanel.this.table.setRowSelectionInterval(errrow, errrow);
                }
                ((AbstractTableModel)LiveecgRecordingsMainPanel.this.table.getModel()).fireTableDataChanged();
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                logger.finest("++++++++++ editingCanceled <" + e.getSource() + ">");
                if (LiveecgRecordingsMainPanel.this.parentDialog.isAutoCalc()) {
                    LiveecgRecordingsMainPanel.this.autoRecalc(true, false);
                }
                LiveecgRecordingsMainPanel.this.validateRecordings();
            }
        };
        TableColumn column = this.table.getColumnModel().getColumn(0);
        LivetecErrorTableCellRenderer posrenderer = new LivetecErrorTableCellRenderer();
        posrenderer.setHorizontalAlignment(0);
        column.setCellRenderer(posrenderer);
        column.setMinWidth(60);
        LiveecgDateOnlyCellRenderer daterenderer = new LiveecgDateOnlyCellRenderer();
        daterenderer.setHorizontalAlignment(0);
        daterenderer.setFont(fonttable);
        column = this.table.getColumnModel().getColumn(1);
        column.setCellRenderer(daterenderer);
        column.setMinWidth(100);
        this.datepickereditor = new LiveecgDatePickerCellEditor();
        this.datepickereditor.addCellEditorListener(celleditorlistener);
        column = this.table.getColumnModel().getColumn(1);
        column.setCellEditor((TableCellEditor)((Object)this.datepickereditor));
        this.datepickereditor.setClickCountToStart(1);
        column = this.table.getColumnModel().getColumn(2);
        LiveecgTimeOnlyCellRenderer timerenderer = new LiveecgTimeOnlyCellRenderer();
        timerenderer.setHorizontalAlignment(0);
        column.setCellRenderer((TableCellRenderer)((Object)timerenderer));
        column.setMinWidth(100);
        ChangeListener timeChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LiveecgRecordingsMainPanel.this.setInputModified(true);
            }
        };
        this.timeeditor = new LiveecgTimeEditor("HH:mm:ss", timeChangeListener);
        this.timeeditor.addCellEditorListener(timeCelleditorlistener);
        column = this.table.getColumnModel().getColumn(2);
        column.setCellRenderer((TableCellRenderer)((Object)timerenderer));
        column.setCellEditor(this.timeeditor);
        LiveecgRecordingLengthRenderer lengthrenderer = new LiveecgRecordingLengthRenderer();
        lengthrenderer.setHorizontalAlignment(0);
        column = this.table.getColumnModel().getColumn(3);
        column.setCellRenderer(lengthrenderer);
        column.setMinWidth(100);
        column = this.table.getColumnModel().getColumn(4);
        LivetecErrorTableCellRenderer slicerenderer = new LivetecErrorTableCellRenderer();
        slicerenderer.setHorizontalAlignment(2);
        column.setCellRenderer(slicerenderer);
        column.setMinWidth(100);
        slicerenderer.setToolTipText(LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.tooltip.slice"));
        if (this.model.getColumnCount() > 5) {
            column = this.table.getColumnModel().getColumn(5);
            LivetecErrorTableCellRenderer errorrenderer = new LivetecErrorTableCellRenderer();
            errorrenderer.setHorizontalAlignment(2);
            column.setCellRenderer(errorrenderer);
            column.setMinWidth(120);
        }
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(9, 64), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 64), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(13, 0), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(13, 64), "none");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int row = LiveecgRecordingsMainPanel.this.table.rowAtPoint(evt.getPoint());
                int col = LiveecgRecordingsMainPanel.this.table.columnAtPoint(evt.getPoint());
                if (row >= 0 && col >= 0 && LiveecgRecordingsMainPanel.this.table.isEditing()) {
                    LiveecgRecordingsMainPanel.this.table.getCellEditor().stopCellEditing();
                }
            }
        });
        return this.table;
    }

    private void setInputModified(boolean modified) {
        this.inputModified = modified;
        this.resetButton.setEnabled(modified);
    }

    private int getLastErrorRow() {
        LiveecgDateOnlyCellRenderer dateRenderer = (LiveecgDateOnlyCellRenderer)this.table.getColumnModel().getColumn(1).getCellRenderer();
        if (dateRenderer != null) {
            return dateRenderer.getErrorRow();
        }
        return -1;
    }

    private void autoRecalc(boolean useselrow, boolean validate) {
        int errinx = this.getErrorRowInx(this.model.getLiveecgRecordings());
        if (errinx > 0) {
            this.recalcTimings(errinx - 1, false);
        } else if (useselrow) {
            this.recalcTimings(this.getTable().getSelectedRow(), true);
        } else {
            this.recalcTimings(0, false);
        }
        if (validate) {
            this.validateRecordings();
        }
        this.setInputModified(true);
    }

    public JTable getTable() {
        return this.table;
    }

    private JPanel createActionPanel() {
        final DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
        JPanel retval = new JPanel((LayoutManager)new TableLayout(LAYOUT_ACTION_PANEL));
        retval.setOpaque(false);
        this.defaultButton = new AssistantButton(1, (Action)new AbstractAction(PadsyText.getText((String)"OK")){
            private static final long serialVersionUID = -8454055313156433071L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean doUpdate = false;
                if (!LiveecgRecordingsMainPanel.this.validateRecordings() || LiveecgRecordingsMainPanel.this.inputModified) {
                    String errmsg = !LiveecgRecordingsMainPanel.this.validateRecordings() ? String.valueOf(driverBundle.getText("device.holter.livetec.recordings.validationerror")) + "\n" : "";
                    errmsg = String.valueOf(errmsg) + driverBundle.getText("device.holter.livetec.recordings.datause") + "\n" + driverBundle.getText("device.holter.livetec.recordings.okconfirm");
                    Object[] options = new String[]{PadsyText.getText((String)"OK"), driverBundle.getText("panel.cancel")};
                    if (JOptionPane.showOptionDialog(LiveecgRecordingsMainPanel.this.parentDialog, errmsg, String.valueOf(LiveecgRecordingsMainPanel.this.title) + " " + driverBundle.getText("device.holter.livetec.recordings.aufnahme.liveecg"), 0, 2, null, options, options[0]) == 0) {
                        doUpdate = true;
                    }
                } else {
                    doUpdate = true;
                }
                if (doUpdate) {
                    int startIndex = 0;
                    boolean error = true;
                    while (error && startIndex < LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings().size()) {
                        LiveecgRecording recording = LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings().get(startIndex);
                        if (recording.getErrmsg() == null) {
                            error = false;
                            break;
                        }
                        ++startIndex;
                    }
                    if (startIndex < LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings().size()) {
                        List<LiveecgRecording> recordings = LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings();
                        int i = 0;
                        while (i < startIndex) {
                            recordings.remove(0);
                            ++i;
                        }
                        long ldate = LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings().get(0).getRecordingStartDate().getTime();
                        long ltime = LiveecgRecordingsMainPanel.this.model.getLiveecgRecordings().get(0).getRecordingStartDateTime().getTime();
                        LiveecgRecordingsMainPanel.this.parentDialog.changeAssistantStartDateTime(ldate, ltime);
                        LiveecgRecordingsMainPanel.this.parentDialog.changeAssistantDuration((int)LiveecgRecordingsMainPanel.this.model.getCumulatedDuration());
                        LiveecgRecordingsMainPanel.this.parentDialog.dispose();
                        String errmsg = driverBundle.getFormattedText("device.holter.livetec.patients.gdt.selection.message", (Object)LiveecgRecordingsMainPanel.this.parentDialog.getGdtPatientProfile());
                        LiveecgRecordingsMainPanel.this.parentDialog.createSelectPatientView();
                    } else {
                        LiveecgRecordingsMainPanel.this.parentDialog.stopOperation();
                    }
                }
            }
        });
        this.cancelButton = new AssistantButton(1, (Action)new AbstractAction(LiveecgDeviceDriver.DRIVER_TEXT.getText("panel.cancel")){
            private static final long serialVersionUID = -6946591854786962151L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LiveecgRecordingsMainPanel.this.parentDialog.stopOperation();
            }
        });
        this.resetButton = new AssistantButton(1, (Action)new AbstractAction(driverBundle.getText("device.holter.livetec.recordings.revert")){
            private static final long serialVersionUID = -6324106257336249711L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = driverBundle.getText("device.holter.livetec.recordings.confirmreset");
                Object[] options = new String[]{PadsyText.getText((String)"OK"), driverBundle.getText("panel.cancel")};
                if (JOptionPane.showOptionDialog(LiveecgRecordingsMainPanel.this.parentDialog, msg, LiveecgRecordingsMainPanel.this.title, 0, 2, null, options, options[0]) == 0) {
                    LiveecgRecordingsMainPanel.this.datepickereditor.stopCellEditing();
                    LiveecgRecordingsMainPanel.this.timeeditor.stopCellEditing();
                    LiveecgRecordingsMainPanel.this.revert();
                }
            }
        });
        this.resetButton.setToolTipText(driverBundle.getText("device.holter.livetec.recordings.reset"));
        this.resetButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.defaultButton.setEnabled(true);
        retval.add((Component)this.cancelButton, "0,0");
        retval.add((Component)this.resetButton, "2,0");
        retval.add((Component)this.defaultButton, "4,0");
        retval.setVisible(true);
        return retval;
    }

    public String getErrors(List<LiveecgRecording> liveecgRecordings) {
        long olddatetime = 0L;
        String errmsg = "";
        int errrow = -1;
        int finx = 0;
        while (liveecgRecordings != null && finx < liveecgRecordings.size()) {
            Date startdate = liveecgRecordings.get(finx).getRecordingStartDateTime();
            if (startdate == null || startdate.getTime() < olddatetime) {
                DriverBundle driverBundle = LiveecgDeviceDriver.DRIVER_TEXT;
                errmsg = String.valueOf(driverBundle.getText("device.holter.livetec.recordings.pos")) + " " + (finx + 1) + ": " + driverBundle.getFormattedText("device.holter.livetec.recordings.starttimewrong", (Object)PadsyDateFormat.format((Date)startdate, (int)10)) + "\n" + driverBundle.getText("device.holter.livetec.recordings.korrektur");
                errrow = finx;
                break;
            }
            olddatetime = startdate.getTime() + liveecgRecordings.get(finx).getRecordingLength();
            ++finx;
        }
        if (errmsg.length() > 0) {
            this.selectErrorDateTime(errrow);
            return errmsg;
        }
        this.selectErrorDateTime(-1);
        return "";
    }

    private void revert() {
        LiveecgRecording.revert(this.model.getLiveecgRecordings());
        this.model.fireTableDataChanged();
        this.validateRecordings();
        this.setInputModified(false);
    }

    public int getErrorRowInx(List<LiveecgRecording> liveecgRecordings) {
        long olddatetime = 0L;
        int finx = 0;
        while (finx < liveecgRecordings.size()) {
            Date startdate = liveecgRecordings.get(finx).getRecordingStartDateTime();
            if (startdate == null || startdate.getTime() < olddatetime) {
                return finx;
            }
            olddatetime = startdate.getTime() + liveecgRecordings.get(finx).getRecordingLength();
            ++finx;
        }
        return -1;
    }

    private boolean validateRecordings() {
        boolean success = true;
        this.message.setAlertText("");
        String errmsg = this.getErrors(this.model.getLiveecgRecordings());
        boolean bl = success = errmsg.length() <= 0;
        if (!success) {
            this.message.setAlertText(errmsg);
        } else {
            this.message.setText("O.K.                                                        ");
        }
        this.defaultButton.setEnabled(success);
        return success;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, LiveecgColor.DUNKLES_GRAU, 0.0f, this.getSize().height, LiveecgColor.HELLES_GRAU);
        ((Graphics2D)g).setPaint(gradientPaint);
        ((Graphics2D)g).fill(new Rectangle(new Point(0, 0), this.getSize()));
    }

    public void selectErrorDateTime(int rowinx) {
        TableColumnModel columnmodel = this.table.getColumnModel();
        LiveecgDateOnlyCellRenderer rendererdate = (LiveecgDateOnlyCellRenderer)columnmodel.getColumn(1).getCellRenderer();
        rendererdate.setErrorRow(rowinx);
        LiveecgTimeOnlyCellRenderer renderertime = (LiveecgTimeOnlyCellRenderer)((Object)columnmodel.getColumn(2).getCellRenderer());
        renderertime.setErrorRow(rowinx);
    }

    private void recalcTimings(int selrowinx, boolean checkerrors) {
        int fromrowinx;
        int errorrowinx;
        if (this.model.getLiveecgRecordings().size() <= 1) {
            return;
        }
        if (checkerrors && (errorrowinx = this.getErrorRowInx(this.model.getLiveecgRecordings())) == selrowinx) {
            return;
        }
        List<LiveecgRecording> recordings = this.model.getLiveecgRecordings();
        int i = fromrowinx = selrowinx + 1;
        while (i < recordings.size()) {
            Date prevdate = recordings.get(i - 1).getRecordingStartDateTime();
            if (prevdate == null) {
                this.message.setAlertText(LiveecgDeviceDriver.DRIVER_TEXT.getText("device.holter.livetec.recordings.autocalc.notpossible"));
                return;
            }
            long nexttimems = prevdate.getTime() + recordings.get(i - 1).getRecordingLength();
            Date nextdate = new Date(nexttimems);
            recordings.get(i).setRecordingStartDate(nextdate);
            recordings.get(i).setRecordingStartTime(nextdate);
            ++i;
        }
        this.model.fireTableDataChanged();
        this.setInputModified(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int index = event.getFirstIndex();
        if (index != -1) {
            LiveecgRecording recording = this.model.getLiveecgRecordings().get(index);
            if (recording.getErrmsg() != null) {
                if (this.lastSelectionIndex != -1) {
                    ListSelectionModel selectionModel = this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(this.lastSelectionIndex, this.lastSelectionIndex);
                }
            } else {
                this.lastSelectionIndex = index;
            }
        }
    }
}

