/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording;

import com.medset.graphics.PadsyFont;
import com.medset.hardware.ambulant.assistent.AssistantMessage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LivetecAssistantMessage
extends AssistantMessage {
    private static final long serialVersionUID = 1098997276132228208L;
    private List<String> textlines;
    private Color textColor = TEXT_DEFAULT_COLOR;

    public LivetecAssistantMessage(String string) {
        super(string);
        this.generateTextLines(string);
    }

    private void generateTextLines(String text) {
        this.textlines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        while (tokenizer.hasMoreElements()) {
            this.textlines.add(tokenizer.nextToken().trim());
        }
    }

    public void setAlertText(String text) {
        this.textColor = TEXT_ALERT_COLOR;
        super.setAlertText(text);
        this.generateTextLines(text);
    }

    public void setText(String text) {
        this.textColor = TEXT_DEFAULT_COLOR;
        super.setText(text);
        this.generateTextLines(text);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D graphics2D = (Graphics2D)g;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point textLoc = new Point();
        Font font = g.getFont();
        Color color = g.getColor();
        Rectangle rec = this.getBounds();
        RoundRectangle2D.Double area = new RoundRectangle2D.Double(0.0, 0.0, rec.width, rec.height, 20.0, 20.0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(area);
        if (this.textlines.size() > 0) {
            g.setColor(this.textColor);
            g.setFont(PadsyFont.getBoldFont((float)16.0f));
            FontMetrics fm = g.getFontMetrics();
            int textHeight = fm.getHeight();
            int ascent = fm.getAscent();
            int maxSize = this.getBounds().width - 24;
            String text1 = this.textlines.get(0);
            String text2 = null;
            textLoc.y = (37 + ascent - 4) / 2;
            textLoc.x = 12;
            if (fm.stringWidth(this.getText()) > maxSize) {
                g.setFont(PadsyFont.getBoldFont((float)14.0f));
                fm = g.getFontMetrics();
                textHeight = fm.getHeight();
                String[] strings = text1.split("\\s");
                text1 = strings[0];
                int index = 1;
                while (index < strings.length && fm.stringWidth(text1) <= maxSize) {
                    text1 = String.valueOf(text1) + " " + strings[index++];
                }
                if (index == strings.length && fm.stringWidth(text1) <= maxSize) {
                    ++index;
                }
                text1 = "";
                int i = 0;
                while (i < index - 1) {
                    text1 = String.valueOf(text1) + strings[i] + " ";
                    ++i;
                }
                if (index - 1 < strings.length) {
                    text2 = "";
                    i = index - 1;
                    while (i < strings.length) {
                        text2 = String.valueOf(text2) + strings[i] + " ";
                        ++i;
                    }
                    textLoc.y -= textHeight / 2;
                }
            }
            int i = 0;
            while (i < this.textlines.size()) {
                g.drawString(this.textlines.get(i), textLoc.x, textLoc.y);
                textLoc.y += textHeight - 1;
                ++i;
            }
        }
        g.setFont(font);
        g.setColor(color);
    }
}

