/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording;

import com.medset.util.table.SortedTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class LivetecErrorTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 7915532901376758899L;
    private boolean isErrorRecording = false;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            String error = (String)table.getModel().getValueAt(row, 5);
            if (error != null && error.length() > 0) {
                super.setForeground(Color.BLACK);
                this.isErrorRecording = false;
                super.setBackground(Color.LIGHT_GRAY);
            } else {
                super.setForeground(Color.WHITE);
                super.setBackground(SortedTableModel.BACKGROUND_SELCTED_COLOR);
            }
        } else {
            String error = (String)table.getModel().getValueAt(row, 5);
            super.setForeground(Color.BLACK);
            if (error != null && error.length() > 0) {
                this.isErrorRecording = false;
                super.setBackground(Color.LIGHT_GRAY);
            } else if (row % 2 == 1) {
                super.setBackground(SortedTableModel.BACKGROUND_NORMAL_COLOR_1);
            } else {
                super.setBackground(SortedTableModel.BACKGROUND_NORMAL_COLOR_2);
            }
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), UIManager.getBorder("Table.focusCellHighlightBorder")));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), noFocusBorder));
        }
        this.setValue(value);
        return this;
    }

    public boolean isErrorRecording() {
        return this.isErrorRecording;
    }
}

