/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording.util;

import com.medset.hardware.ambulant.livetec.view.recording.util.LiveecgDateTimeInterface;
import com.medset.padsy.ProgramSettingsManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.table.DatePickerCellEditor;

public class LiveecgDatePickerCellEditor
extends DatePickerCellEditor
implements LiveecgDateTimeInterface {
    private static final long serialVersionUID = 6848273002181624119L;
    private static Logger logger = Logger.getLogger(LiveecgDatePickerCellEditor.class.getName());
    Date oldValue = null;
    private int lastKeyPressed = 0;
    private boolean shiftPressed = false;

    public LiveecgDatePickerCellEditor() {
        super((DateFormat)new SimpleDateFormat(ProgramSettingsManager.getInstance().getDateOutputFormat()));
        this.datePicker.getEditor().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (LiveecgDatePickerCellEditor.this.getOldValue() == null) {
                    LiveecgDatePickerCellEditor.this.setOldValue((Date)LiveecgDatePickerCellEditor.this.datePicker.getEditor().getValue());
                }
                if (e.getKeyCode() == 9) {
                    LiveecgDatePickerCellEditor.this.stopCellEditing();
                }
                if (e.getKeyCode() == 27) {
                    LiveecgDatePickerCellEditor.this.datePicker.getEditor().setValue(LiveecgDatePickerCellEditor.this.getOldValue());
                    LiveecgDatePickerCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    public Date getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Date oldval) {
        this.oldValue = oldval;
    }

    protected boolean commitChange() {
        Date date = (Date)this.datePicker.getEditor().getValue();
        Calendar now = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.compareTo(now) >= 0) {
            this.datePicker.getEditor().setValue(this.oldValue);
            return false;
        }
        return super.commitChange();
    }

    public boolean stopCellEditing() {
        Date date = (Date)this.datePicker.getEditor().getValue();
        Calendar now = Calendar.getInstance();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.compareTo(now) >= 0) {
            this.datePicker.getEditor().setValue(this.oldValue);
            return false;
        }
        return super.stopCellEditing();
    }

    public JXDatePicker getJXDatePicker() {
        return this.datePicker;
    }

    @Override
    public boolean wasShiftPressed() {
        return this.shiftPressed;
    }

    @Override
    public int getLastKeyPressed() {
        return this.lastKeyPressed;
    }
}

