/*
 * Decompiled with CFR 0.152.
 */
package com.medset.hardware.ambulant.livetec.view.recording.util;

import com.medset.hardware.ambulant.livetec.util.Trace;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LiveecgTimeEditor
extends DefaultCellEditor {
    private static Logger logger = Logger.getLogger(LiveecgTimeEditor.class.getName());
    private static final long serialVersionUID = 3466055543761891563L;
    private JSpinner.DateEditor dateEditor;
    private JSpinner spinner;
    private JFormattedTextField timeField;
    private boolean valueSet = false;
    private String timeFormat = null;
    private String tempTime = null;
    private JFormattedTextField lastSelectedTimeField;
    private JSpinner lastSelectedSpinner;
    private SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    private Object currentValue;
    private SpinnerDateModel timemodel;
    private ChangeListener externalChangeListener;

    public LiveecgTimeEditor(String timeformat, ChangeListener externalChangeListener) {
        super(new JTextField());
        this.timeFormat = timeformat;
        this.externalChangeListener = externalChangeListener;
        this.init();
    }

    private void init() {
        Time time = new Time(0L);
        this.timemodel = new SpinnerDateModel(time, null, null, 12);
        this.spinner = new JSpinner(this.timemodel);
        this.dateEditor = new JSpinner.DateEditor(this.spinner, this.timeFormat);
        this.spinner.setEditor(this.dateEditor);
        this.dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        this.timeField = this.dateEditor.getTextField();
        this.setupTimeField();
    }

    private void init(Time time) {
        this.timemodel = new SpinnerDateModel(time, null, null, 12);
        this.spinner = new JSpinner(this.timemodel);
        this.dateEditor = new JSpinner.DateEditor(this.spinner, this.timeFormat);
        this.spinner.setEditor(this.dateEditor);
        this.dateEditor = (JSpinner.DateEditor)this.spinner.getEditor();
        this.timeField = this.dateEditor.getTextField();
        this.setupTimeField();
    }

    private void setupTimeField() {
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                logger.info("+++++++ " + LiveecgTimeEditor.this.timeField.getText());
                LiveecgTimeEditor.this.setTime(null);
                if (LiveecgTimeEditor.this.externalChangeListener != null) {
                    LiveecgTimeEditor.this.externalChangeListener.stateChanged(e);
                }
            }
        });
        this.timeField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusevent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveecgTimeEditor.this.valueSet) {
                            logger.info("++++ focusGained() +++ " + LiveecgTimeEditor.this.timeField.getText());
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent focusevent) {
            }
        });
        this.timeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LiveecgTimeEditor.this.stopCellEditing();
            }
        });
        this.timeField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                LiveecgTimeEditor.this.setTime(LiveecgTimeEditor.this.timeField.getText());
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e == null) {
                    return;
                }
                if (e.getKeyCode() == 9 || e.getKeyCode() == 10) {
                    e.setKeyCode(10);
                    LiveecgTimeEditor.this.checkTextValid();
                    LiveecgTimeEditor.this.stopCellEditing();
                }
                if (e.getKeyCode() == 27) {
                    LiveecgTimeEditor.this.setTime(null);
                }
            }
        });
    }

    public void checkTextValid() {
        String s = this.getTime();
        if (s == null) {
            return;
        }
        if (!Trace.containsDigits(s, ':')) {
            return;
        }
        String[] vals = s.split("[:]");
        if (vals.length == 1) {
            this.setTime(String.valueOf(vals[0]) + ":00:00");
        } else if (vals.length == 2) {
            this.setTime(String.valueOf(vals[0]) + ":" + vals[1] + ":00");
        }
    }

    public void setTime(String temptime) {
        this.tempTime = temptime;
    }

    public String getTime() {
        return this.tempTime;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isselected, int row, int col) {
        if (row == 0) {
            this.lastSelectedSpinner = this.spinner;
        }
        if (value != null && value instanceof Time) {
            this.init((Time)value);
        } else {
            this.init();
        }
        if (!this.valueSet) {
            if (value == null) {
                try {
                    value = this.timeFormatter.parse("00:00:00");
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.currentValue = value;
            this.spinner.setValue(value);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveecgTimeEditor.this.timeField.requestFocus();
            }
        });
        return this.spinner;
    }

    @Override
    public boolean isCellEditable(EventObject eventobject) {
        this.valueSet = eventobject instanceof KeyEvent;
        if (this.valueSet) {
            logger.info("+++++++ " + this.timeField.getName() + " " + String.valueOf(((KeyEvent)eventobject).getKeyChar()));
            this.timeField.setText(String.valueOf(((KeyEvent)eventobject).getKeyChar()));
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        logger.info("+++++++ " + this.spinner.getValue());
        return this.spinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        this.currentValue = this.spinner.getValue();
        JTextField textField = (JTextField)this.getComponent();
        textField.setText(this.timeFormatter.format(this.spinner.getValue()));
        logger.info("+++++++ " + textField.getText());
        if (this.dateEditor != null) {
            this.timeField = this.dateEditor.getTextField();
        }
        return true;
    }
}

