/*
 * Decompiled with CFR 0.152.
 */
package com.medset;

import com.medset.padsy.PadsyClassLoader;
import com.medset.padsy.PadsyLogManager;
import com.medset.plaf.PadsyLookAndFeel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class DatabaseRepairTool {
    private static final Logger logger = Logger.getLogger(DatabaseRepairTool.class.getName());
    private static String OUTPUT_STRING = "output";
    private static String OUTPUT_TRACE_STRING = "trace";
    static String PADSY_OUTLOG_FILE = "padsy.out";
    static String PADSY_ERRLOG_FILE = "padsy.err";
    static String PADSY_LOG = ".log";
    static String PADSY_OUTPUT_DIR = "Log";

    public static void main(String[] args) {
        PadsyLogManager.getInstance();
        boolean output = false;
        boolean trace = false;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(OUTPUT_STRING)) {
                    output = true;
                } else if (args[i].equals(OUTPUT_TRACE_STRING)) {
                    trace = true;
                }
                ++i;
            }
        }
        if (trace) {
            String date = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss").format(Calendar.getInstance().getTime());
            try {
                new File(PADSY_OUTPUT_DIR).mkdirs();
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTPUT_DIR) + File.separator + PADSY_OUTLOG_FILE + date + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTPUT_DIR) + File.separator + PADSY_ERRLOG_FILE + date + PADSY_LOG)));
            }
            catch (Exception exception) {}
        } else if (!output) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTLOG_FILE) + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PADSY_ERRLOG_FILE) + PADSY_LOG)));
            }
            catch (Exception date) {
                // empty catch block
            }
        }
        try {
            URL[] baseURL;
            if (args.length > 0 && args[0].compareToIgnoreCase("EW") == 0) {
                logger.fine("EW-Modus");
                File currentDir = new File(".");
                String path = currentDir.getAbsolutePath();
                if (path.endsWith(String.valueOf(File.separator) + ".")) {
                    logger.fine("Remove dot from Path: " + path);
                    path = path.substring(0, path.length() - 2);
                }
                baseURL = new URL[]{new File(path).toURL()};
                logger.fine("addUrl: " + baseURL[0].toString());
            } else {
                baseURL = new URL[]{};
            }
            ClassLoader padsyClassLoader = PadsyClassLoader.createInstance(baseURL);
            try {
                UIManager.setLookAndFeel(new PadsyLookAndFeel());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Class<?> databaseRepairToolClass = padsyClassLoader.loadClass("com.medset.database.DatabaseTool");
            Method mainMethod = DatabaseRepairTool.findMethode(databaseRepairToolClass, "main");
            mainMethod.invoke(null, new Object[1]);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cant start DatabaseRepairTool.", e);
            JOptionPane.showMessageDialog(null, "DatabaseRepairTool could not be started.\nPlease look into the log files.", "Error", 0);
        }
    }

    public static Method findMethode(Class clazz, String name) {
        Method retval = null;
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                retval = methods[i];
                break;
            }
            ++i;
        }
        return retval;
    }
}

