/*
 * Decompiled with CFR 0.152.
 */
package com.medset;

import com.medset.padsy.PadsyClassLoader;
import com.medset.padsy.PadsyLogManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class PadsyServerService
implements WrapperListener {
    private static final Logger logger = Logger.getLogger(PadsyServerService.class.getName());
    private static String OUTPUT_STRING = "output";
    private static String OUTPUT_TRACE_STRING = "trace";
    private static String PADSY_OUTLOG_FILE = "padsy.out";
    private static String PADSY_ERRLOG_FILE = "padsy.err";
    private static String PADSY_LOG = ".log";
    private static String PADSY_OUTPUT_DIR = "Log";
    private Object server;
    private Class serverClass;
    private Method startMethode;
    private Method stopMethode;

    private PadsyServerService() {
        try {
            ClassLoader padsyClassLoader = PadsyClassLoader.createInstance(new URL[0]);
            this.serverClass = padsyClassLoader.loadClass("com.medset.padsy.remote.RmiPadsyServerImpl");
            this.startMethode = this.findMethode(this.serverClass, "publishServer");
            this.stopMethode = this.findMethode(this.serverClass, "shutDown");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Cant find PADSY-Server class.", e);
        }
    }

    public Integer start(String[] args) {
        try {
            this.server = this.serverClass.newInstance();
            this.startMethode.invoke(this.server, new Object[0]);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Can't start PADSY server.", e);
        }
        return null;
    }

    public int stop(int exitCode) {
        if (this.server != null) {
            try {
                this.stopMethode.invoke(this.server, new Object[0]);
                this.server = null;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Can't start PADSY server.", e);
            }
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
            WrapperManager.stop((int)0);
        }
    }

    public Method findMethode(Class clazz, String name) {
        Method retval = null;
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                retval = methods[i];
                break;
            }
            ++i;
        }
        return retval;
    }

    public static void main(String[] args) {
        boolean useOldSocketType;
        logger.info("java.vendor=" + System.getProperty("java.vendor"));
        logger.info("java.runtime.version=" + System.getProperty("java.runtime.version"));
        logger.info("java.library.path=" + System.getProperty("java.library.path"));
        logger.info("os.name=" + System.getProperty("os.name"));
        logger.info("os.arch=" + System.getProperty("os.arch"));
        logger.info("os.version=" + System.getProperty("os.version"));
        logger.info("user.dir=" + System.getProperty("user.dir"));
        logger.info("user.country=" + System.getProperty("user.country"));
        logger.info("user.language=" + System.getProperty("user.language"));
        logger.info("user.timezone=" + System.getProperty("user.timezone"));
        logger.info("file.encoding=" + System.getProperty("file.encoding"));
        if (System.getProperty("os.name").startsWith("Mac")) {
            TimeZone tz;
            if (System.getProperty("os.version").startsWith("10.13")) {
                tz = TimeZone.getTimeZone("Europe/Berlin");
                TimeZone.setDefault(tz);
            } else if (System.getProperty("os.version").startsWith("10.14")) {
                tz = TimeZone.getTimeZone("Europe/Berlin");
                TimeZone.setDefault(tz);
            }
        }
        Calendar c = Calendar.getInstance();
        logger.info("system date: " + c.getTime().toString());
        System.setProperty("com.medset.padsy.logger.console", "true");
        PadsyLogManager.getInstance();
        boolean output = false;
        boolean trace = false;
        boolean bl = useOldSocketType = !Boolean.getBoolean("com.medset.padsy.remote.proxy");
        if (useOldSocketType) {
            logger.fine("Use old SocketConnection");
            ProxySelector.setDefault(null);
        }
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(OUTPUT_STRING)) {
                    output = true;
                } else if (args[i].equals(OUTPUT_TRACE_STRING)) {
                    trace = true;
                }
                ++i;
            }
        }
        if (trace) {
            String date = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss").format(Calendar.getInstance().getTime());
            try {
                new File(PADSY_OUTPUT_DIR).mkdirs();
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTPUT_DIR) + File.separator + PADSY_OUTLOG_FILE + date + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTPUT_DIR) + File.separator + PADSY_ERRLOG_FILE + date + PADSY_LOG)));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Can't create logfiles.", e);
            }
        } else if (!output) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PADSY_OUTLOG_FILE) + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PADSY_ERRLOG_FILE) + PADSY_LOG)));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Can't create logfiles.", e);
            }
        }
        try {
            URL[] baseURL;
            if (args.length > 0 && args[0].compareToIgnoreCase("EW") == 0) {
                logger.fine("EW-Modus");
                File currentDir = new File(".");
                String path = currentDir.getAbsolutePath();
                if (path.endsWith(String.valueOf(File.separator) + ".")) {
                    logger.fine("Remove dot from Path: " + path);
                    path = path.substring(0, path.length() - 2);
                }
                baseURL = new URL[]{new File(path).toURI().toURL()};
                logger.fine("addUrl: " + baseURL[0].toString());
            } else {
                baseURL = new URL[]{};
            }
            PadsyClassLoader.createInstance(baseURL);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Cant start PADSY-Server.", e);
        }
        WrapperManager.start((WrapperListener)new PadsyServerService(), (String[])args);
    }
}

