/*
 * Decompiled with CFR 0.152.
 */
package com.medset;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import com.medset.PadsyUncaughtExceptionHandler;
import com.medset.graphics.CheckThreadViolationRepaintManager;
import com.medset.padsy.PadsyClassLoader;
import com.medset.padsy.PadsyLogManager;
import com.medset.plaf.PadsyLookAndFeel;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class PadsyStarter {
    private static final Logger logger = Logger.getLogger(PadsyStarter.class.getName());
    public static final String INSTALL_PATH = "Installation";
    public static final String UNINSTALL_PATH = "UnInstallation";
    public static final String JNI_FILE_PATH = "JniFiles";
    public static final String MISSING_TEXT = "!Text missing: ";
    static String OUTPUT_STRING = "output";
    static String JUST_GUI_STRING = "justgui";
    static String OUTPUT_TRACE_STRING = "trace";
    static String EMPTY_STRING = "";
    static String PADSY_OUTLOG_FILE = "padsy.out";
    static String PADSY_ERRLOG_FILE = "padsy.err";
    static String PADSY_LOG = ".log";
    static String PADSY_OUTPUT_DIR = "Log";
    static String PADSY_TEMP_DIR = "Temp";
    private static final boolean isOSX = System.getProperty("os.name").toUpperCase().equalsIgnoreCase("MAC OS X");
    private static final boolean isLinux = System.getProperty("os.name").toUpperCase().equalsIgnoreCase("LINUX");
    private static byte[] copyBuffer = new byte[32768];

    public static void main(String[] args) {
        File logPath;
        PadsyLogManager.getInstance();
        Lm.verifyLicense((String)"Medset Medizintechnik GmbH", (String)"PADSY", (String)"xxNEy:jCfDUM.lo0tZprxmRtymO0UR52");
        boolean output = false;
        boolean trace = false;
        boolean useOldSocketType = !Boolean.getBoolean("com.medset.padsy.remote.proxy");
        Thread.setDefaultUncaughtExceptionHandler(new PadsyUncaughtExceptionHandler());
        if (useOldSocketType) {
            logger.fine("Use old SocketConnection");
            ProxySelector.setDefault(null);
        }
        logger.info("java.vendor=" + System.getProperty("java.vendor"));
        logger.info("java.runtime.version=" + System.getProperty("java.runtime.version"));
        logger.info("java.library.path=" + System.getProperty("java.library.path"));
        logger.info("os.name=" + System.getProperty("os.name"));
        logger.info("os.arch=" + System.getProperty("os.arch"));
        logger.info("os.version=" + System.getProperty("os.version"));
        logger.info("user.dir=" + System.getProperty("user.dir"));
        logger.info("user.country=" + System.getProperty("user.country"));
        logger.info("user.language=" + System.getProperty("user.language"));
        logger.info("user.timezone=" + System.getProperty("user.timezone"));
        logger.info("file.encoding=" + System.getProperty("file.encoding"));
        try {
            String line;
            Process process = Runtime.getRuntime().exec("whoami");
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                logger.info("current user=" + line);
            }
            in.close();
            if (System.getProperty("os.name").startsWith("Mac")) {
                TimeZone tz;
                if (System.getProperty("os.version").startsWith("10.13")) {
                    tz = TimeZone.getTimeZone("Europe/Berlin");
                    TimeZone.setDefault(tz);
                } else if (System.getProperty("os.version").startsWith("10.14")) {
                    tz = TimeZone.getTimeZone("Europe/Berlin");
                    TimeZone.setDefault(tz);
                }
            }
            Calendar c = Calendar.getInstance();
            logger.info("system date: " + c.getTime().toString());
        }
        catch (Exception e) {
            logger.severe("could not determine user");
        }
        boolean checkRepaint = Boolean.getBoolean("com.medset.check.repaint");
        if (checkRepaint) {
            logger.info("Repaint checker enabled");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
        File tempDir = new File(PadsyStarter.getPadsyIoPath(), PADSY_TEMP_DIR);
        tempDir.mkdirs();
        PadsyStarter.deleteTemporaryFiles(tempDir);
        System.setProperty("java.io.tmpdir", tempDir.getAbsolutePath());
        PadsyStarter.removeFiles();
        PadsyStarter.copyFiles();
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals(OUTPUT_STRING)) {
                    output = true;
                } else if (args[i].equals(OUTPUT_TRACE_STRING)) {
                    trace = true;
                }
                ++i;
            }
        }
        if (!(logPath = new File(String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + PADSY_OUTPUT_DIR)).exists()) {
            logPath.mkdirs();
        }
        if (trace) {
            String date = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss").format(Calendar.getInstance().getTime());
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + PADSY_OUTPUT_DIR + File.separator + PADSY_OUTLOG_FILE + date + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + PADSY_OUTPUT_DIR + File.separator + PADSY_ERRLOG_FILE + date + PADSY_LOG)));
            }
            catch (Exception exception) {}
        } else if (!output) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + PADSY_OUTLOG_FILE + PADSY_LOG)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + PADSY_ERRLOG_FILE + PADSY_LOG)));
            }
            catch (Exception date) {
                // empty catch block
            }
        }
        try {
            URL[] baseURL;
            if (args.length > 0 && args[0].compareToIgnoreCase("EW") == 0) {
                logger.fine("EW mode");
                File currentDir = new File("bin");
                String path = currentDir.getAbsolutePath();
                if (path.endsWith(String.valueOf(File.separator) + ".")) {
                    logger.fine("remove dot from path: " + path);
                    path = path.substring(0, path.length() - 2);
                }
                baseURL = new URL[]{new File(path).toURL()};
                logger.fine("addUrl: " + baseURL[0].toString());
            } else {
                baseURL = new URL[]{};
            }
            ClassLoader padsyClassLoader = PadsyClassLoader.createInstance(baseURL);
            PadsyStarter.selectLocale(padsyClassLoader);
            try {
                UIManager.setLookAndFeel(new PadsyLookAndFeel());
                LookAndFeelFactory.installJideExtension();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Can't set PADSY Look&Feel.", e);
            }
            if (PadsyStarter.isDemo() && !PadsyStarter.startFromCD()) {
                PadsyStarter.hideSplashScreen(padsyClassLoader);
                logger.log(Level.SEVERE, "Can't start PADSY DEMO");
                JOptionPane.showMessageDialog(null, "PADSY could not be started.\nPlease check the PADSY LOG messages.", "Error", 0);
                System.exit(0);
            }
            PadsyStarter.showSplashMessage(padsyClassLoader, PadsyStarter.getPadsyText("splash.searchUpdates", padsyClassLoader));
            Class<?> updateServiceClass = padsyClassLoader.loadClass("com.medset.padsy.UpdateService");
            Object updateService = updateServiceClass.newInstance();
            Method updateMethod = PadsyStarter.findMethode(updateServiceClass, "update");
            Boolean updated = (Boolean)updateMethod.invoke(updateService, null);
            if (!updated.booleanValue()) {
                PadsyStarter.showSplashMessage(padsyClassLoader, PadsyStarter.getPadsyText("splash.startSystem", padsyClassLoader));
                Class<?> serverClass = padsyClassLoader.loadClass("com.medset.kern.PadsyKernel");
                Object server = serverClass.newInstance();
                Method startMethod = PadsyStarter.findMethode(serverClass, "startup");
                Method waitMethod = PadsyStarter.findMethode(serverClass, "waitForFinish");
                SwingUtilities.invokeLater(new KernelStarter(server, startMethod));
                waitMethod.invoke(server, null);
                logger.info("Kernel is finished.");
                System.exit(0);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "can't start PADSY quick starter", e);
            JOptionPane.showMessageDialog(null, "PADSY could not be started.\nPlease check the PADSY LOG messages.", "Error", 0);
            System.exit(0);
        }
    }

    protected static boolean hideSplashScreen(ClassLoader padsyClassLoader) {
        boolean retval = false;
        try {
            Class<?> splashScreenClass = padsyClassLoader.loadClass("com.install4j.api.launcher.SplashScreen");
            Method hideMethod = PadsyStarter.findMethode(splashScreenClass, "hide");
            hideMethod.invoke(null, new Object[0]);
            retval = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't hide splashscreen", e);
        }
        return retval;
    }

    protected static boolean showSplashMessage(ClassLoader padsyClassLoader, String message) {
        boolean retval = false;
        try {
            Class<?> splashScreenClass = padsyClassLoader.loadClass("com.install4j.api.launcher.SplashScreen");
            Method hideMethod = PadsyStarter.findMethode(splashScreenClass, "writeMessage");
            hideMethod.invoke(null, message);
            retval = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't hide splashscreen", e);
        }
        return retval;
    }

    private static void selectLocale(ClassLoader padsyClassLoader) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> programSettingsManagerClass = padsyClassLoader.loadClass("com.medset.padsy.ProgramSettingsManager");
        Method getInstanceMethod = PadsyStarter.findMethode(programSettingsManagerClass, "getInstance");
        getInstanceMethod.invoke(null, null);
    }

    public static String getPadsyIoPath() {
        File ioPath = new File(".");
        if (PadsyStarter.isDemo() || PadsyStarter.isJustGui()) {
            ioPath = new File(String.valueOf(System.getProperty("user.home")) + File.separator + ".PADSY");
        }
        return ioPath.getPath();
    }

    public static Object startPadsyGui(ClassLoader padsyClassLoader) {
        Object retval = null;
        try {
            Class<?> padsyMainClass = padsyClassLoader.loadClass("com.medset.PadsyMain");
            Object padsyMain = padsyMainClass.newInstance();
            Method startApplication = PadsyStarter.findMethode(padsyMainClass, "startApplication");
            startApplication.invoke(padsyMain, null);
            Method getProgramManager = PadsyStarter.findMethode(padsyMainClass, "getProgramManager");
            Object programManager = getProgramManager.invoke(padsyMain, null);
            Method getPadsySession = PadsyStarter.findMethode(programManager.getClass(), "getPadsySession");
            retval = getPadsySession.invoke(programManager, null);
            try {
                String line;
                Process process = Runtime.getRuntime().exec("whoami");
                BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = in.readLine()) != null) {
                    logger.info("user=" + line);
                }
                in.close();
            }
            catch (Exception e) {
                logger.severe("could not determine user");
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't start PADSY user interface", e);
        }
        return retval;
    }

    public static void stopPadsyGui(ClassLoader padsyClassLoader) {
        try {
            Class<?> padsyMainClass = padsyClassLoader.loadClass("com.medset.PadsyMain");
            Object padsyMain = padsyMainClass.newInstance();
            Method startMethode = PadsyStarter.findMethode(padsyMainClass, "stopApplication");
            startMethode.invoke(padsyMain, null);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't stop PADSY user interface", e);
        }
    }

    public static void stopTerminalApplication(ClassLoader padsyClassLoader) {
        try {
            Class<?> padsyMainClass = padsyClassLoader.loadClass("com.medset.PadsyMain");
            Object padsyMain = padsyMainClass.newInstance();
            Method startMethode = PadsyStarter.findMethode(padsyMainClass, "stopTerminalApplication");
            startMethode.invoke(padsyMain, null);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't stop PADSY GUI", e);
        }
    }

    private static void deleteTemporaryFiles(File tempDir) {
        File[] files = tempDir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                PadsyStarter.deleteTemporaryFiles(files[i]);
            }
            if (files[i].delete()) {
                logger.log(Level.WARNING, "can't delete temporary file \"" + files[i].getAbsolutePath() + "\"");
            }
            ++i;
        }
    }

    public static Method findMethode(Class clazz, String name) {
        Method retval = null;
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                retval = methods[i];
                break;
            }
            ++i;
        }
        return retval;
    }

    private static void copyFiles() {
        ArrayList fileList = PadsyStarter.findAllFiles(INSTALL_PATH);
        int i = 0;
        while (i < fileList.size()) {
            File sourceFile = (File)fileList.get(i);
            File destFile = PadsyStarter.createDestFile(sourceFile);
            if (!destFile.getParentFile().exists()) {
                logger.log(Level.INFO, "Create directory \"" + destFile.getParentFile() + "\"");
                destFile.getParentFile().mkdirs();
            }
            if (destFile.getParentFile().exists() && destFile.getParentFile().isDirectory()) {
                if (destFile.exists()) {
                    try {
                        logger.log(Level.INFO, "Move \"" + sourceFile + "\" to \"" + destFile);
                        PadsyStarter.moveFile(sourceFile, destFile);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "File \"" + sourceFile.getAbsolutePath() + "\" could not be copied", e);
                    }
                } else {
                    logger.log(Level.INFO, "Rename \"" + sourceFile + "\" to \"" + destFile);
                    if (!sourceFile.renameTo(destFile)) {
                        logger.log(Level.SEVERE, "File \"" + sourceFile.getAbsolutePath() + "\" could not be copied");
                    }
                }
            } else {
                logger.log(Level.SEVERE, "\"" + destFile.getParentFile().getAbsolutePath() + "\" isn't a directory");
            }
            ++i;
        }
    }

    private static File createDestFile(File sourceFile) {
        String filename = sourceFile.getAbsolutePath();
        String destName = filename.replaceFirst(INSTALL_PATH + (isOSX | isLinux ? File.separator : String.valueOf(File.separator) + File.separator), "");
        return new File(destName);
    }

    private static File createRemoveFile(File sourceFile) {
        String filename = sourceFile.getAbsolutePath();
        String destName = filename.replaceFirst(UNINSTALL_PATH + (isOSX | isLinux ? File.separator : String.valueOf(File.separator) + File.separator), "");
        return new File(destName);
    }

    private static void moveFile(File source, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        byte[] data = new byte[4096];
        int read = 0;
        long readed = 0L;
        long toRead = source.length();
        if (toRead > 0L) {
            logger.info("Move " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + " [" + toRead + " bytes]");
            do {
                read = ((InputStream)in).read(data);
                ((OutputStream)out).write(data, 0, read);
            } while ((readed += (long)read) < toRead);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        source.delete();
    }

    private static void removeFiles() {
        ArrayList fileList = PadsyStarter.findAllFiles(UNINSTALL_PATH);
        int i = 0;
        while (i < fileList.size()) {
            File file = (File)fileList.get(i);
            File removeFile = PadsyStarter.createRemoveFile(file);
            if (!file.delete() || !removeFile.delete()) {
                logger.log(Level.SEVERE, "File \"" + file.getAbsolutePath() + "\" could not be deleted");
            }
            ++i;
        }
    }

    private static ArrayList findAllFiles(String path) {
        ArrayList<File> retval = new ArrayList<File>();
        File base = new File(path);
        File[] files = base.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    retval.addAll(PadsyStarter.findAllFiles(files[i].getAbsolutePath()));
                } else if (files[i].isFile()) {
                    retval.add(files[i]);
                }
                ++i;
            }
        }
        return retval;
    }

    public static void startRemoteErgoView(ClassLoader padsyClassLoader) {
        PadsyStarter.startRemoteErgoView(null, padsyClassLoader);
    }

    public static void startRemoteErgoView(Object padsySession, ClassLoader padsyClassLoader) {
        try {
            Class<?> remoteErgoClass = padsyClassLoader.loadClass("com.medset.ergolight.remote.RemoteViewerTask");
            Class<?> padsySessionClass = padsyClassLoader.loadClass("com.medset.padsy.PadsySession");
            Constructor<?> constructor = remoteErgoClass.getConstructor(padsySessionClass);
            Object remoteTask = constructor.newInstance(padsySession);
            Method startRemoteViewMethod = PadsyStarter.findMethode(remoteErgoClass, "startTask");
            startRemoteViewMethod.invoke(remoteTask, null);
        }
        catch (Throwable ta) {
            logger.log(Level.WARNING, "can't start RemoteErgoViewer");
        }
    }

    public static void startMemoryMonitor(ClassLoader padsyClassLoader) {
        try {
            Class<?> memoryMonitorClass = padsyClassLoader.loadClass("com.medset.util.MemoryMonitor");
            Object memoryMonitor = memoryMonitorClass.newInstance();
            Method startTaskMethod = PadsyStarter.findMethode(memoryMonitorClass, "startTask");
            startTaskMethod.invoke(memoryMonitor, null);
        }
        catch (Throwable ta) {
            logger.log(Level.SEVERE, "can't start MemoryMonitor", ta);
        }
    }

    public static void startMediarchScanner(ClassLoader padsyClassLoader) {
        try {
            Class<?> mediArchScannerClass = padsyClassLoader.loadClass("com.medset.telemetrie.mediarch.MediarchScanner");
            Object mediArchScanner = mediArchScannerClass.newInstance();
            Method startTaskMethod = PadsyStarter.findMethode(mediArchScannerClass, "startTask");
            startTaskMethod.invoke(mediArchScanner, null);
        }
        catch (Throwable ta) {
            logger.log(Level.SEVERE, "can't start MediarchScanner", ta);
        }
    }

    public static void startAmbulantAssistant(ClassLoader padsyClassLoader) {
        try {
            Class<?> assistantClass = padsyClassLoader.loadClass("com.medset.hardware.ambulant.assistent.AmbulantDeviceAssistant");
            assistantClass.newInstance();
        }
        catch (Throwable ta) {
            logger.log(Level.SEVERE, "can't start AmbulantDeviceFinder", ta);
        }
    }

    public static void startPadsyCenter(ClassLoader padsyClassLoader) {
        try {
            Class<?> padsyCenterClass = padsyClassLoader.loadClass("com.medset.planet.RmiPadsyCenterImpl");
            Method getInstanceMethod = PadsyStarter.findMethode(padsyCenterClass, "getInstance");
            getInstanceMethod.invoke(null, null);
        }
        catch (Throwable ta) {
            logger.log(Level.WARNING, "can't start PADSY center");
        }
    }

    public static void startGDT(ClassLoader padsyClassLoader) {
        try {
            Class<?> gdtClass = padsyClassLoader.loadClass("com.medset.gdt.GDT");
            Method getInstanceMethod = PadsyStarter.findMethode(gdtClass, "getInstance");
            Object gdt = getInstanceMethod.invoke(null, null);
            Method startTaskMethod = PadsyStarter.findMethode(gdtClass, "startTask");
            startTaskMethod.invoke(gdt, null);
        }
        catch (Throwable ta) {
            logger.log(Level.SEVERE, "can't start GDT server", ta);
        }
    }

    public static void startServerConnection(ClassLoader padsyClassLoader) {
        try {
            Class<?> serverConnectionClass = padsyClassLoader.loadClass("com.medset.padsy.PadsyServerConnection");
            Method getInstanceMethod = PadsyStarter.findMethode(serverConnectionClass, "getInstance");
            getInstanceMethod.invoke(null, null);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't connect to PADSY server", e);
        }
    }

    public static void stopServerConnection(ClassLoader padsyClassLoader) {
        try {
            Class<?> serverConnectionClass = padsyClassLoader.loadClass("com.medset.padsy.PadsyServerConnection");
            Method getInstanceMethod = PadsyStarter.findMethode(serverConnectionClass, "getInstance");
            Object serverConnection = getInstanceMethod.invoke(null, null);
            Method closeMethod = PadsyStarter.findMethode(serverConnectionClass, "close");
            closeMethod.invoke(serverConnection, null);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't disconnect from PADSY server", e);
        }
    }

    public static void stopTaskManager(ClassLoader padsyClassLoader) {
        try {
            Class<?> taskManagerClass = padsyClassLoader.loadClass("com.medset.task.TaskManager");
            Method getInstanceMethod = PadsyStarter.findMethode(taskManagerClass, "getInstance");
            Object taskManager = getInstanceMethod.invoke(null, null);
            Method stopAllTasksMethod = PadsyStarter.findMethode(taskManagerClass, "stopAllTasks");
            stopAllTasksMethod.invoke(taskManager, null);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "can't stop TaskManager", e);
        }
    }

    public static boolean isJustGui() {
        return Boolean.getBoolean("com.medset.padsy.JustGui");
    }

    public static boolean isDemo() {
        return Boolean.getBoolean("com.medset.padsy.Demo");
    }

    public static String getPadsyText(String textKey, ClassLoader padsyClassLoader) {
        try {
            Class<?> padsyTextClass = padsyClassLoader.loadClass("com.medset.padsy.PadsyText");
            Method padsyTextMethod = PadsyStarter.findMethode(padsyTextClass, "getText");
            return (String)padsyTextMethod.invoke((Object)padsyTextMethod, textKey);
        }
        catch (Throwable ta) {
            logger.log(Level.WARNING, "can't get PADSY text key: " + textKey);
            return MISSING_TEXT + textKey;
        }
    }

    public static void copyTree(File sourceDir, File destDir) {
        if (sourceDir.exists()) {
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            File[] files = sourceDir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    try {
                        PadsyStarter.copyFile(files[i], new File(destDir, files[i].getName()));
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "Can't copy filetree.", e);
                    }
                } else if (files[i].isDirectory()) {
                    PadsyStarter.copyTree(files[i], new File(destDir, files[i].getName()));
                }
                ++i;
            }
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        int read = 0;
        long readed = 0L;
        long toRead = source.length();
        if (toRead > 0L) {
            logger.info("Move " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + " [" + toRead + " bytes]");
            do {
                read = ((InputStream)in).read(copyBuffer);
                ((OutputStream)out).write(copyBuffer, 0, read);
            } while ((readed += (long)read) < toRead);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static boolean startFromCD() {
        boolean retval = false;
        try {
            File root = new File(new File("").getAbsolutePath());
            FileSystemView fileSystemView = FileSystemView.getFileSystemView();
            File testFile = new File(root, "DEMO_TEST");
            boolean canWrite = false;
            try {
                if (testFile.createNewFile()) {
                    canWrite = true;
                    testFile.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            retval = !(!fileSystemView.isFileSystemRoot(root) && !isOSX || !fileSystemView.getSystemDisplayName(root).startsWith("PADSY DEMO") && !fileSystemView.getSystemDisplayName(root).endsWith("PADSY DEMO") || canWrite);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Can't check Device.", e);
        }
        return retval;
    }

    static class FinishAction
    extends AbstractAction {
        private static final long serialVersionUID = 792027777088904465L;
        private ClassLoader padsyClassLoader;

        public FinishAction(ClassLoader padsyClassLoader) {
            super(PadsyStarter.getPadsyText("PadsyStarterQuitAction", padsyClassLoader));
            this.padsyClassLoader = padsyClassLoader;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PadsyStarter.stopTerminalApplication(this.padsyClassLoader);
        }
    }

    static class KernelStarter
    implements Runnable {
        private Object server;
        private Method startMethod;

        public KernelStarter(Object server, Method startMethod) {
            this.server = server;
            this.startMethod = startMethod;
        }

        @Override
        public void run() {
            try {
                this.startMethod.invoke(this.server, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "can't start PADSY quick starter", e);
                JOptionPane.showMessageDialog(null, "PADSY could not be started.\nPlease check the PADSY LOG messages.", "Error", 0);
                System.exit(0);
            }
        }
    }
}

