/*
 * Decompiled with CFR 0.152.
 */
package com.medset.database;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class RepairToolFormatter
extends Formatter {
    private static final String STR_SPACE = " ";
    private static final String STR_TAB = "\t";
    private static final String STR_RET = "\n";

    RepairToolFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        Throwable th;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(record.getMillis());
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        String datum = df.format(cal.getTime());
        String className = record.getSourceClassName();
        if (className.startsWith("com.medset.")) {
            className = className.substring(11);
        }
        if (className.startsWith("database.")) {
            className = className.substring(9);
        }
        String retval = String.valueOf(datum) + STR_SPACE + className + STR_SPACE + record.getSourceMethodName() + STR_RET;
        retval = String.valueOf(retval) + STR_TAB + record.getLevel().getName() + ": " + record.getMessage() + STR_RET;
        Object[] param = record.getParameters();
        if (param != null) {
            int i = 0;
            while (i < param.length) {
                retval = String.valueOf(retval) + "\t(" + (i + 1) + ")=" + param[i].toString() + STR_RET;
                ++i;
            }
        }
        if ((th = record.getThrown()) != null) {
            CharArrayWriter stackWriter = new CharArrayWriter();
            th.printStackTrace(new PrintWriter(stackWriter));
            retval = String.valueOf(retval) + "\t*** Error:" + stackWriter.toString();
        }
        return retval;
    }
}

