/*
 * Decompiled with CFR 0.152.
 */
package com.medset.graphics;

import com.medset.graphics.PadsyFontFamily;
import java.awt.Font;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class PadsyFont {
    private static Logger logger = Logger.getLogger("com.medset.graphics.PadsyFont");
    private static final String PADSY_ROOT = "padsy";
    private static final String FONT_KEY = "fontfamily";
    private static PadsyFontFamily selectedFontFamily;

    static {
        PadsyFont.init();
    }

    private static void init() {
        String language = Locale.getDefault().getLanguage();
        PadsyFontFamily[] availFontFamilies = PadsyFontFamily.getAvailableFonts(language);
        Preferences prefs = Preferences.userRoot().node(PADSY_ROOT);
        String selectedFont = prefs.get(FONT_KEY, null);
        if (selectedFont == null) {
            selectedFontFamily = availFontFamilies[0];
        } else {
            selectedFontFamily = PadsyFontFamily.getFontFamily(selectedFont);
            if (selectedFontFamily == null) {
                logger.info("Unknown fontfamily \"" + selectedFont + "\". Use default font.");
                selectedFontFamily = availFontFamilies[0];
            } else {
                boolean fontFound = false;
                int i = 0;
                while (i < availFontFamilies.length) {
                    if (selectedFontFamily == availFontFamilies[i]) {
                        fontFound = true;
                        break;
                    }
                    ++i;
                }
                if (!fontFound) {
                    logger.info("Selected font is not available. Use default font.");
                    selectedFontFamily = availFontFamilies[0];
                }
            }
        }
    }

    public static boolean isCeFont(String fontname) {
        return PadsyFontFamily.isCeFont(fontname);
    }

    public static boolean isCyFont(String fontname) {
        return PadsyFontFamily.isCyFont(fontname);
    }

    public static boolean isArFont(String fontname) {
        return PadsyFontFamily.isArFont(fontname);
    }

    public static boolean isNormalFont(String fontname) {
        return PadsyFontFamily.isNormalFont(fontname);
    }

    public static Font getPlainFont(float size) {
        return selectedFontFamily.getPlainFont().deriveFont(0, size);
    }

    public static Font getBoldFont(float size) {
        return selectedFontFamily.getBoldFont().deriveFont(0, size);
    }

    public static String getFontName() {
        return selectedFontFamily.getPlainFont().getFontName();
    }

    public static void setFontFamily(PadsyFontFamily padsyFontFamily) {
        Preferences prefs = Preferences.userRoot().node(PADSY_ROOT);
        prefs.put(FONT_KEY, padsyFontFamily.getType());
        selectedFontFamily = padsyFontFamily;
    }

    public static PadsyFontFamily getFontFamily() {
        return selectedFontFamily;
    }

    public static PadsyFontFamily[] getAvailableFonts(String languageCode) {
        return PadsyFontFamily.getAvailableFonts(languageCode);
    }
}

