/*
 * Decompiled with CFR 0.152.
 */
package com.medset.graphics;

import com.medset.PadsyStarter;
import com.medset.graphics.PadsyFont;
import com.medset.padsy.PadsyClassLoader;
import java.awt.Font;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PadsyFontFamily {
    private static final Logger logger = Logger.getLogger(PadsyFontFamily.class.getName());
    private static final String WEST_EUROPEAN = "westeuropean";
    private static final String CENTRAL_EUROPEAN = "centraleuropean";
    private static final String CYRILLIC = "cyrillic";
    private static final String ARABIC = "arabic";
    private static final String PADSY_PLAIN_FONT_FILE = "/com/medset/resources/fonts/OWBK____.TTF";
    private static final String PADSY_PLAIN_FONT_NAME = "ITC Officina Sans Book";
    private static final String PADSY_BOLD_FONT_FILE = "/com/medset/resources/fonts/OWB_____.TTF";
    private static final String PADSY_BOLD_FONT_NAME = "ITC Officina Sans Bold";
    private static final String CE_PLAIN_FONT_FILE = "/com/medset/resources/fonts/centraleuropean/OWBK____.TTF";
    private static final String CE_PLAIN_FONT_NAME = "OfficinaSansBookETT";
    private static final String CE_BOLD_FONT_FILE = "/com/medset/resources/fonts/centraleuropean/OWB_____.TTF";
    private static final String CE_BOLD_FONT_NAME = "OfficinaSansBoldETT";
    private static final String CY_PLAIN_FONT_FILE = "/com/medset/resources/fonts/cyrillic/OWBK____.TTF";
    private static final String CY_PLAIN_FONT_NAME = "OfficinaSansBookCTT";
    private static final String CY_BOLD_FONT_FILE = "/com/medset/resources/fonts/cyrillic/OWB_____.TTF";
    private static final String CY_BOLD_FONT_NAME = "OfficinaSansBoldCTT";
    private static final String AR_PLAIN_FONT_FILE = "/com/medset/resources/fonts/arabic/tahoma.ttf";
    private static final String AR_PLAIN_FONT_NAME = "Tahoma";
    private static final String AR_BOLD_FONT_FILE = "/com/medset/resources/fonts/arabic/tahomabd.ttf";
    private static final String AR_BOLD_FONT_NAME = "Tahoma Fett";
    public static PadsyFontFamily cyrillic;
    public static PadsyFontFamily centraleuropean;
    public static PadsyFontFamily westeuropean;
    public static PadsyFontFamily arabic;
    public static PadsyFontFamily[] EN_FONTS;
    public static PadsyFontFamily[] DE_FONTS;
    public static PadsyFontFamily[] FR_FONTS;
    public static PadsyFontFamily[] CS_FONTS;
    public static PadsyFontFamily[] PL_FONTS;
    public static PadsyFontFamily[] CY_FONTS;
    public static PadsyFontFamily[] AR_FONTS;
    private static Hashtable<String, PadsyFontFamily[]> fontMap;
    private Font plainFont;
    private Font boldFont;
    private String name;
    private String type;

    static {
        try {
            ClassLoader classLoader = PadsyClassLoader.getInstance();
            cyrillic = new PadsyFontFamily(PadsyStarter.getPadsyText("FontFamilyCyrillicName", classLoader), CYRILLIC, CY_PLAIN_FONT_FILE, CY_PLAIN_FONT_NAME, CY_BOLD_FONT_FILE, CY_BOLD_FONT_NAME);
            centraleuropean = new PadsyFontFamily(PadsyStarter.getPadsyText("FontFamilyCentralEuropeName", classLoader), CENTRAL_EUROPEAN, CE_PLAIN_FONT_FILE, CE_PLAIN_FONT_NAME, CE_BOLD_FONT_FILE, CE_BOLD_FONT_NAME);
            westeuropean = new PadsyFontFamily(PadsyStarter.getPadsyText("FontFamilyWestEuropeName", classLoader), WEST_EUROPEAN, PADSY_PLAIN_FONT_FILE, PADSY_PLAIN_FONT_NAME, PADSY_BOLD_FONT_FILE, PADSY_BOLD_FONT_NAME);
            arabic = new PadsyFontFamily(PadsyStarter.getPadsyText("FontFamilyArabicName", classLoader), ARABIC, AR_PLAIN_FONT_FILE, AR_PLAIN_FONT_NAME, AR_BOLD_FONT_FILE, AR_BOLD_FONT_NAME);
        }
        catch (InstantiationException e) {
            logger.log(Level.SEVERE, "error while instantiating PadsyFontFamilies", e);
        }
        EN_FONTS = new PadsyFontFamily[]{westeuropean, centraleuropean, cyrillic, arabic};
        DE_FONTS = new PadsyFontFamily[]{westeuropean, centraleuropean};
        FR_FONTS = new PadsyFontFamily[]{westeuropean, centraleuropean};
        CS_FONTS = new PadsyFontFamily[]{centraleuropean};
        PL_FONTS = new PadsyFontFamily[]{centraleuropean};
        CY_FONTS = new PadsyFontFamily[]{cyrillic};
        AR_FONTS = new PadsyFontFamily[]{arabic};
        fontMap = new Hashtable();
        fontMap.put("en", EN_FONTS);
        fontMap.put("de", DE_FONTS);
        fontMap.put("fr", FR_FONTS);
        fontMap.put("cs", CS_FONTS);
        fontMap.put("pl", PL_FONTS);
        fontMap.put("ru", CY_FONTS);
        fontMap.put("ar", AR_FONTS);
    }

    private PadsyFontFamily(String name, String type, String plainFontFile, String plainFontName, String boldFontFile, String boldFontName) {
        this.name = name;
        this.type = type;
        this.plainFont = this.createFont(plainFontFile, plainFontName);
        this.boldFont = this.createFont(boldFontFile, boldFontName);
    }

    public static PadsyFontFamily[] getAvailableFonts(String languageCode) {
        PadsyFontFamily[] retval = null;
        retval = fontMap.get(languageCode);
        if (retval == null) {
            retval = EN_FONTS;
        }
        return retval;
    }

    public static PadsyFontFamily getFontFamily(String type) {
        PadsyFontFamily retval = null;
        if (WEST_EUROPEAN.compareToIgnoreCase(type) == 0) {
            retval = westeuropean;
        } else if (CENTRAL_EUROPEAN.compareToIgnoreCase(type) == 0) {
            retval = centraleuropean;
        } else if (CYRILLIC.compareToIgnoreCase(type) == 0) {
            retval = cyrillic;
        } else if (ARABIC.compareToIgnoreCase(type) == 0) {
            retval = arabic;
        }
        return retval;
    }

    private Font createFont(String fontFile, String fontName) {
        Font retval = null;
        try {
            logger.fine("Create Font from JAR");
            URL url = PadsyFont.class.getResource(fontFile);
            retval = Font.createFont(0, url.openStream());
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Can't create Font from JAR: ", e);
            retval = new Font(fontName, 0, 1);
            logger.fine("Create Font from OS");
        }
        return retval;
    }

    public String getName() {
        return this.name;
    }

    public Font getPlainFont() {
        return this.plainFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public static boolean isCeFont(String fontname) {
        return CE_BOLD_FONT_NAME.compareTo(fontname) == 0 || CE_PLAIN_FONT_NAME.compareTo(fontname) == 0;
    }

    public static boolean isArFont(String fontname) {
        return AR_BOLD_FONT_NAME.compareTo(fontname) == 0 || AR_PLAIN_FONT_NAME.compareTo(fontname) == 0;
    }

    public static boolean isCyFont(String fontname) {
        return CY_BOLD_FONT_NAME.compareTo(fontname) == 0 || CY_PLAIN_FONT_NAME.compareTo(fontname) == 0;
    }

    public static boolean isNormalFont(String fontname) {
        return PADSY_BOLD_FONT_NAME.compareTo(fontname) == 0 || PADSY_PLAIN_FONT_NAME.compareTo(fontname) == 0;
    }

    public String getType() {
        return this.type;
    }
}

