/*
 * Decompiled with CFR 0.152.
 */
package com.medset.graphics;

import com.medset.graphics.TableLayoutConstants;
import com.medset.graphics.TableLayoutConstraints;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected static final int C = 0;
    protected static final int R = 1;
    protected static boolean checkForComponentOrientationSupport = true;
    protected static Method methodGetComponentOrientation;
    protected double[][] crSpec = new double[2][];
    protected int[][] crSize = new int[2][];
    protected int[][] crOffset = new int[2][];
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;
    protected int hGap;
    protected int vGap;

    public TableLayout() {
        this.init(defaultSize[0], defaultSize[1]);
    }

    public TableLayout(double[][] size) {
        if (size == null || size.length != 2) {
            throw new IllegalArgumentException("Parameter size should be an array, a[2], where a[0] is the is an array of column widths and a[1] is an array or row heights.");
        }
        this.init(size[0], size[1]);
    }

    public TableLayout(double[] col, double[] row) {
        this.init(col, row);
    }

    protected void init(double[] col, double[] row) {
        if (col == null) {
            throw new IllegalArgumentException("Parameter col cannot be null");
        }
        if (row == null) {
            throw new IllegalArgumentException("Parameter row cannot be null");
        }
        this.crSpec[0] = new double[col.length];
        this.crSpec[1] = new double[row.length];
        System.arraycopy(col, 0, this.crSpec[0], 0, this.crSpec[0].length);
        System.arraycopy(row, 0, this.crSpec[1], 0, this.crSpec[1].length);
        int counter = 0;
        while (counter < this.crSpec[0].length) {
            if (this.crSpec[0][counter] < 0.0 && this.crSpec[0][counter] != -1.0 && this.crSpec[0][counter] != -2.0 && this.crSpec[0][counter] != -3.0) {
                this.crSpec[0][counter] = 0.0;
            }
            ++counter;
        }
        counter = 0;
        while (counter < this.crSpec[1].length) {
            if (this.crSpec[1][counter] < 0.0 && this.crSpec[1][counter] != -1.0 && this.crSpec[1][counter] != -2.0 && this.crSpec[1][counter] != -3.0) {
                this.crSpec[1][counter] = 0.0;
            }
            ++counter;
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.cr1[0], entry.cr1[1], entry.cr2[0], entry.cr2[1], entry.alignment[0], entry.alignment[1]);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints constraint) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (constraint == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.component != component) continue;
            iterator.set(new Entry(component, constraint));
        }
    }

    public void setColumn(double[] column) {
        this.setCr(0, column);
    }

    public void setRow(double[] row) {
        this.setCr(1, row);
    }

    protected void setCr(int z, double[] size) {
        this.crSpec[z] = new double[size.length];
        System.arraycopy(size, 0, this.crSpec[z], 0, this.crSpec[z].length);
        int counter = 0;
        while (counter < this.crSpec[z].length) {
            if (this.crSpec[z][counter] < 0.0 && this.crSpec[z][counter] != -1.0 && this.crSpec[z][counter] != -2.0 && this.crSpec[z][counter] != -3.0) {
                this.crSpec[z][counter] = 0.0;
            }
            ++counter;
        }
        this.dirty = true;
    }

    public void setColumn(int i, double size) {
        this.setCr(0, i, size);
    }

    public void setRow(int i, double size) {
        this.setCr(1, i, size);
    }

    protected void setCr(int z, int i, double size) {
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        this.crSpec[z][i] = size;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] column = new double[this.crSpec[0].length];
        System.arraycopy(this.crSpec[0], 0, column, 0, column.length);
        return column;
    }

    public double[] getRow() {
        double[] row = new double[this.crSpec[1].length];
        System.arraycopy(this.crSpec[1], 0, row, 0, row.length);
        return row;
    }

    public double getColumn(int i) {
        return this.crSpec[0][i];
    }

    public double getRow(int i) {
        return this.crSpec[1][i];
    }

    public int getNumColumn() {
        return this.crSpec[0].length;
    }

    public int getNumRow() {
        return this.crSpec[1].length;
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }

    public void setHGap(int hGap) {
        if (hGap < 0) {
            throw new IllegalArgumentException("Parameter hGap must be non-negative.");
        }
        this.hGap = hGap;
    }

    public void setVGap(int vGap) {
        if (vGap < 0) {
            throw new IllegalArgumentException("Parameter vGap must be non-negative.");
        }
        this.vGap = vGap;
    }

    public void insertColumn(int i, double size) {
        this.insertCr(0, i, size);
    }

    public void insertRow(int i, double size) {
        this.insertCr(1, i, size);
    }

    public void insertCr(int z, int i, double size) {
        if (i < 0 || i > this.crSpec[z].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + this.crSpec[z].length + "].");
        }
        if (size < 0.0 && size != -1.0 && size != -2.0 && size != -3.0) {
            size = 0.0;
        }
        double[] cr = new double[this.crSpec[z].length + 1];
        System.arraycopy(this.crSpec[z], 0, cr, 0, i);
        System.arraycopy(this.crSpec[z], i, cr, i + 1, this.crSpec[z].length - i);
        cr[i] = size;
        this.crSpec[z] = cr;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.cr1[z] >= i) {
                int n = z;
                entry.cr1[n] = entry.cr1[n] + 1;
            }
            if (entry.cr2[z] < i) continue;
            int n = z;
            entry.cr2[n] = entry.cr2[n] + 1;
        }
        this.dirty = true;
    }

    public void deleteColumn(int i) {
        this.deleteCr(0, i);
    }

    public void deleteRow(int i) {
        this.deleteCr(1, i);
    }

    protected void deleteCr(int z, int i) {
        if (i < 0 || i >= this.crSpec[z].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + i + ".  Valid range is [0, " + (this.crSpec[z].length - 1) + "].");
        }
        double[] cr = new double[this.crSpec[z].length - 1];
        System.arraycopy(this.crSpec[z], 0, cr, 0, i);
        System.arraycopy(this.crSpec[z], i + 1, cr, i, this.crSpec[z].length - i - 1);
        this.crSpec[z] = cr;
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.cr1[z] > i) {
                int n = z;
                entry.cr1[n] = entry.cr1[n] - 1;
            }
            if (entry.cr2[z] <= i) continue;
            int n = z;
            entry.cr2[n] = entry.cr2[n] - 1;
        }
        this.dirty = true;
    }

    public String toString() {
        int counter;
        String value = "TableLayout {{";
        if (this.crSpec[0].length > 0) {
            counter = 0;
            while (counter < this.crSpec[0].length - 1) {
                value = String.valueOf(value) + this.crSpec[0][counter] + ", ";
                ++counter;
            }
            value = String.valueOf(value) + this.crSpec[0][this.crSpec[0].length - 1] + "}, {";
        } else {
            value = String.valueOf(value) + "}, {";
        }
        if (this.crSpec[1].length > 0) {
            counter = 0;
            while (counter < this.crSpec[1].length - 1) {
                value = String.valueOf(value) + this.crSpec[1][counter] + ", ";
                ++counter;
            }
            value = String.valueOf(value) + this.crSpec[1][this.crSpec[1].length - 1] + "}}";
        } else {
            value = String.valueOf(value) + "}}";
        }
        return value;
    }

    public List getInvalidEntry() {
        LinkedList<Object> listInvalid = new LinkedList<Object>();
        try {
            ListIterator iterator = this.list.listIterator(0);
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.cr1[1] >= 0 && entry.cr1[0] >= 0 && entry.cr2[1] < this.crSpec[1].length && entry.cr2[0] < this.crSpec[0].length) continue;
                listInvalid.add(entry.copy());
            }
        }
        catch (CloneNotSupportedException error) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return listInvalid;
    }

    public List getOverlappingEntry() {
        LinkedList<Object> listOverlapping = new LinkedList<Object>();
        try {
            int numEntry = this.list.size();
            if (numEntry == 0) {
                return listOverlapping;
            }
            Entry[] entry = this.list.toArray(new Entry[numEntry]);
            int knowUnique = 1;
            while (knowUnique < numEntry) {
                int checking = knowUnique - 1;
                while (checking >= 0) {
                    if (entry[checking].cr1[0] >= entry[knowUnique].cr1[0] && entry[checking].cr1[0] <= entry[knowUnique].cr2[0] && entry[checking].cr1[1] >= entry[knowUnique].cr1[1] && entry[checking].cr1[1] <= entry[knowUnique].cr2[1] || entry[checking].cr2[0] >= entry[knowUnique].cr1[0] && entry[checking].cr2[0] <= entry[knowUnique].cr2[0] && entry[checking].cr2[1] >= entry[knowUnique].cr1[1] && entry[checking].cr2[1] <= entry[knowUnique].cr2[1]) {
                        listOverlapping.add(entry[checking].copy());
                    }
                    --checking;
                }
                ++knowUnique;
            }
        }
        catch (CloneNotSupportedException error) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return listOverlapping;
    }

    protected void calculateSize(Container container) {
        Insets inset = container.getInsets();
        Dimension d = container.getSize();
        int availableWidth = d.width - inset.left - inset.right;
        int availableHeight = d.height - inset.top - inset.bottom;
        if (this.crSpec[0].length > 0) {
            availableWidth -= this.hGap * (this.crSpec[0].length - 1);
        }
        if (this.crSpec[1].length > 0) {
            availableHeight -= this.vGap * (this.crSpec[1].length - 1);
        }
        this.crSize[0] = new int[this.crSpec[0].length];
        this.crSize[1] = new int[this.crSpec[1].length];
        availableWidth = this.assignAbsoluteSize(0, availableWidth);
        availableHeight = this.assignAbsoluteSize(1, availableHeight);
        availableWidth = this.assignPrefMinSize(0, availableWidth, -3.0);
        availableWidth = this.assignPrefMinSize(0, availableWidth, -2.0);
        availableHeight = this.assignPrefMinSize(1, availableHeight, -3.0);
        availableHeight = this.assignPrefMinSize(1, availableHeight, -2.0);
        availableWidth = this.assignRelativeSize(0, availableWidth);
        availableHeight = this.assignRelativeSize(1, availableHeight);
        this.assignFillSize(0, availableWidth);
        this.assignFillSize(1, availableHeight);
        this.calculateOffset(0, inset);
        this.calculateOffset(1, inset);
        this.dirty = false;
        this.oldWidth = d.width;
        this.oldHeight = d.height;
    }

    protected int assignAbsoluteSize(int z, int availableSize) {
        int numCr = this.crSpec[z].length;
        int counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] >= 1.0 || this.crSpec[z][counter] == 0.0) {
                this.crSize[z][counter] = (int)(this.crSpec[z][counter] + 0.5);
                availableSize -= this.crSize[z][counter];
            }
            ++counter;
        }
        return availableSize;
    }

    protected int assignRelativeSize(int z, int availableSize) {
        int relativeSize = availableSize < 0 ? 0 : availableSize;
        int numCr = this.crSpec[z].length;
        int counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] > 0.0 && this.crSpec[z][counter] < 1.0) {
                this.crSize[z][counter] = (int)(this.crSpec[z][counter] * (double)relativeSize + 0.5);
                availableSize -= this.crSize[z][counter];
            }
            ++counter;
        }
        return availableSize;
    }

    protected void assignFillSize(int z, int availableSize) {
        if (availableSize <= 0) {
            return;
        }
        int numFillSize = 0;
        int numCr = this.crSpec[z].length;
        int counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] == -1.0) {
                ++numFillSize;
            }
            ++counter;
        }
        int slackSize = availableSize;
        int counter2 = 0;
        while (counter2 < numCr) {
            if (this.crSpec[z][counter2] == -1.0) {
                this.crSize[z][counter2] = availableSize / numFillSize;
                slackSize -= this.crSize[z][counter2];
            }
            ++counter2;
        }
        counter2 = numCr - 1;
        while (counter2 >= 0 && slackSize > 0) {
            if (this.crSpec[z][counter2] == -1.0) {
                int[] nArray = this.crSize[z];
                int n = counter2;
                nArray[n] = nArray[n] + 1;
                --slackSize;
            }
            --counter2;
        }
    }

    protected void calculateOffset(int z, Insets inset) {
        int numCr = this.crSpec[z].length;
        this.crOffset[z] = new int[numCr + 1];
        this.crOffset[z][0] = z == 0 ? inset.left : inset.top;
        int counter = 0;
        while (counter < numCr) {
            this.crOffset[z][counter + 1] = this.crOffset[z][counter] + this.crSize[z][counter];
            ++counter;
        }
    }

    protected int assignPrefMinSize(int z, int availableSize, double typeOfSize) {
        int numCr = this.crSpec[z].length;
        int counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] == typeOfSize) {
                int maxSize = 0;
                ListIterator iterator = this.list.listIterator(0);
                block1: while (iterator.hasNext()) {
                    int entryCr;
                    Dimension p;
                    Entry entry = (Entry)iterator.next();
                    if (entry.cr1[z] < 0 || entry.cr2[z] >= numCr || entry.cr1[z] > counter || entry.cr2[z] < counter) continue;
                    Dimension dimension = p = typeOfSize == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                    int size = p == null ? 0 : (z == 0 ? p.width : p.height);
                    int numAdjustable = 0;
                    if (typeOfSize == -2.0) {
                        entryCr = entry.cr1[z];
                        while (entryCr <= entry.cr2[z]) {
                            if (this.crSpec[z][entryCr] >= 0.0 || this.crSpec[z][entryCr] == -3.0) {
                                size -= this.crSize[z][entryCr];
                            } else if (this.crSpec[z][entryCr] == -2.0) {
                                ++numAdjustable;
                            } else if (this.crSpec[z][entryCr] == -1.0) continue block1;
                            ++entryCr;
                        }
                    } else {
                        entryCr = entry.cr1[z];
                        while (entryCr <= entry.cr2[z]) {
                            if (this.crSpec[z][entryCr] >= 0.0) {
                                size -= this.crSize[z][entryCr];
                            } else if (this.crSpec[z][entryCr] == -2.0 || this.crSpec[z][entryCr] == -3.0) {
                                ++numAdjustable;
                            } else if (this.crSpec[z][entryCr] == -1.0) continue block1;
                            ++entryCr;
                        }
                    }
                    size = (int)Math.ceil((double)size / (double)numAdjustable);
                    if (maxSize >= size) continue;
                    maxSize = size;
                }
                this.crSize[z][counter] = maxSize;
                availableSize -= maxSize;
            }
            ++counter;
        }
        return availableSize;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension d = container.getSize();
        if (this.dirty || d.width != this.oldWidth || d.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] component = container.getComponents();
        int counter = 0;
        while (counter < component.length) {
            try {
                ListIterator iterator = this.list.listIterator(0);
                Entry entry = null;
                while (iterator.hasNext()) {
                    entry = (Entry)iterator.next();
                    if (entry.component == component[counter]) break;
                    entry = null;
                }
                if (entry == null) {
                    component[counter].setBounds(0, 0, 0, 0);
                } else {
                    int preferredWidth = 0;
                    int preferredHeight = 0;
                    if (entry.alignment[0] != 2 || entry.alignment[1] != 2) {
                        Dimension preferredSize = component[counter].getPreferredSize();
                        preferredWidth = preferredSize.width;
                        preferredHeight = preferredSize.height;
                    }
                    int[] value = this.calculateSizeAndOffset(entry, preferredWidth, true);
                    int x = value[0];
                    int w = value[1];
                    value = this.calculateSizeAndOffset(entry, preferredHeight, false);
                    int y = value[0];
                    int h = value[1];
                    ComponentOrientation co = this.getComponentOrientation(container);
                    if (!co.isLeftToRight()) {
                        x = d.width - x - w;
                    }
                    component[counter].setBounds(x, y, w, h);
                }
            }
            catch (Exception error) {
                component[counter].setBounds(0, 0, 0, 0);
            }
            ++counter;
        }
    }

    protected ComponentOrientation getComponentOrientation(Container container) {
        ComponentOrientation co = null;
        try {
            if (checkForComponentOrientationSupport) {
                methodGetComponentOrientation = Class.forName("java.awt.Container").getMethod("getComponentOrientation", new Class[0]);
            }
            if (methodGetComponentOrientation != null) {
                co = (ComponentOrientation)methodGetComponentOrientation.invoke((Object)container, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return co;
    }

    protected int[] calculateSizeAndOffset(Entry entry, int preferredSize, boolean isColumn) {
        int offset;
        int[] crOffset = isColumn ? this.crOffset[0] : this.crOffset[1];
        int entryAlignment = isColumn ? entry.alignment[0] : entry.alignment[1];
        int cellSetSize = isColumn ? crOffset[entry.cr2[0] + 1] - crOffset[entry.cr1[0]] : crOffset[entry.cr2[1] + 1] - crOffset[entry.cr1[1]];
        int size = entryAlignment == 2 || cellSetSize < preferredSize ? cellSetSize : preferredSize;
        if (isColumn && entryAlignment == 4) {
            entryAlignment = 0;
        }
        if (isColumn && entryAlignment == 5) {
            entryAlignment = 3;
        }
        switch (entryAlignment) {
            case 0: {
                offset = crOffset[isColumn ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            case 3: {
                offset = crOffset[(isColumn ? entry.cr2[0] : entry.cr2[1]) + 1] - size;
                break;
            }
            case 1: {
                offset = crOffset[isColumn ? entry.cr1[0] : entry.cr1[1]] + (cellSetSize - size >> 1);
                break;
            }
            case 2: {
                offset = crOffset[isColumn ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            default: {
                offset = 0;
            }
        }
        if (isColumn) {
            offset += this.hGap * entry.cr1[0];
            size += this.hGap * (entry.cr2[0] - entry.cr1[0]);
        } else {
            offset += this.vGap * entry.cr1[1];
            size += this.hGap * (entry.cr2[1] - entry.cr1[1]);
        }
        int[] value = new int[]{offset, size};
        return value;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -2.0);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -3.0);
    }

    protected Dimension calculateLayoutSize(Container container, double typeOfSize) {
        Entry[] entryList = this.list.toArray(new Entry[this.list.size()]);
        int numEntry = entryList.length;
        Dimension[] prefMinSize = new Dimension[numEntry];
        int i = 0;
        while (i < numEntry) {
            prefMinSize[i] = typeOfSize == -2.0 ? entryList[i].component.getPreferredSize() : entryList[i].component.getMinimumSize();
            ++i;
        }
        int width = this.calculateLayoutSize(container, 0, typeOfSize, entryList, prefMinSize);
        int height = this.calculateLayoutSize(container, 1, typeOfSize, entryList, prefMinSize);
        Insets inset = container.getInsets();
        return new Dimension(width += inset.left + inset.right, height += inset.top + inset.bottom);
    }

    protected int calculateLayoutSize(Container container, int z, double typeOfSize, Entry[] entryList, Dimension[] prefMinSize) {
        int scaledSize = 0;
        int numCr = this.crSpec[z].length;
        double fillSizeRatio = 1.0;
        int numFillSize = 0;
        int counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] > 0.0 && this.crSpec[z][counter] < 1.0) {
                fillSizeRatio -= this.crSpec[z][counter];
            } else if (this.crSpec[z][counter] == -1.0) {
                ++numFillSize;
            }
            ++counter;
        }
        if (numFillSize > 1) {
            fillSizeRatio /= (double)numFillSize;
        }
        if (fillSizeRatio < 0.0) {
            fillSizeRatio = 0.0;
        }
        this.crSize[z] = new int[numCr];
        this.assignAbsoluteSize(z, 0);
        this.assignPrefMinSize(z, 0, typeOfSize);
        int[] crPrefMin = new int[numCr];
        counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] == -2.0 || this.crSpec[z][counter] == -3.0) {
                crPrefMin[counter] = this.crSize[z][counter];
            }
            ++counter;
        }
        int numColumn = this.crSpec[0].length;
        int numRow = this.crSpec[1].length;
        int numEntry = entryList.length;
        int entryCounter = 0;
        while (entryCounter < numEntry) {
            Entry entry = entryList[entryCounter];
            if (entry.cr1[0] >= 0 && entry.cr1[0] < numColumn && entry.cr2[0] < numColumn && entry.cr1[1] >= 0 && entry.cr1[1] < numRow && entry.cr2[1] < numRow) {
                Dimension size = prefMinSize[entryCounter];
                int scalableSize = z == 0 ? size.width : size.height;
                counter = entry.cr1[z];
                while (counter <= entry.cr2[z]) {
                    if (this.crSpec[z][counter] >= 1.0) {
                        scalableSize = (int)((double)scalableSize - this.crSpec[z][counter]);
                    } else if (this.crSpec[z][counter] == -2.0 || this.crSpec[z][counter] == -3.0) {
                        scalableSize -= crPrefMin[counter];
                    }
                    ++counter;
                }
                double relativeSize = 0.0;
                counter = entry.cr1[z];
                while (counter <= entry.cr2[z]) {
                    if (this.crSpec[z][counter] > 0.0 && this.crSpec[z][counter] < 1.0) {
                        relativeSize += this.crSpec[z][counter];
                    } else if (this.crSpec[z][counter] == -1.0 && fillSizeRatio != 0.0) {
                        relativeSize += fillSizeRatio;
                    }
                    ++counter;
                }
                int temp = relativeSize == 0.0 ? 0 : (int)((double)scalableSize / relativeSize + 0.5);
                if (scaledSize < temp) {
                    scaledSize = temp;
                }
            }
            ++entryCounter;
        }
        int totalSize = scaledSize;
        counter = 0;
        while (counter < numCr) {
            if (this.crSpec[z][counter] >= 1.0) {
                totalSize += (int)(this.crSpec[z][counter] + 0.5);
            } else if (this.crSpec[z][counter] == -2.0 || this.crSpec[z][counter] == -3.0) {
                totalSize += crPrefMin[counter];
            }
            ++counter;
        }
        if (numCr > 0) {
            totalSize += (z == 0 ? this.hGap : this.vGap) * (numCr - 1);
        }
        return totalSize;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
        this.addLayoutComponent(component, name);
    }

    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        if (constraint instanceof String) {
            constraint = new TableLayoutConstraints((String)constraint);
            this.list.add(new Entry(component, (TableLayoutConstraints)constraint));
            this.dirty = true;
        } else if (constraint instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)constraint));
            this.dirty = true;
        } else {
            if (constraint == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + constraint.getClass());
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        ListIterator iterator = this.list.listIterator(0);
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.component != component) continue;
            iterator.remove();
        }
        this.dirty = true;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.dirty = true;
    }

    public static class Entry
    implements Cloneable {
        public Component component;
        public int[] cr1;
        public int[] cr2;
        public int[] alignment;

        public Entry(Component component, TableLayoutConstraints constraint) {
            int[] cr1 = new int[]{constraint.col1, constraint.row1};
            int[] cr2 = new int[]{constraint.col2, constraint.row2};
            int[] alignment = new int[]{constraint.hAlign, constraint.vAlign};
            this.cr1 = cr1;
            this.cr2 = cr2;
            this.alignment = alignment;
            this.component = component;
        }

        public Object copy() throws CloneNotSupportedException {
            return this.clone();
        }

        public String toString() {
            TableLayoutConstraints c = new TableLayoutConstraints(this.cr1[0], this.cr1[1], this.cr2[0], this.cr2[1], this.alignment[0], this.alignment[1]);
            return "(" + c + ") " + this.component;
        }
    }
}

