/*
 * Decompiled with CFR 0.152.
 */
package com.medset.graphics;

import com.medset.graphics.TableLayoutConstants;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class TableLayoutConstraints
implements TableLayoutConstants {
    public int col1;
    public int row1;
    public int col2;
    public int row2;
    public int hAlign;
    public int vAlign;

    public TableLayoutConstraints() {
        this.col2 = 0;
        this.col2 = 0;
        this.row1 = 0;
        this.col1 = 0;
        this.vAlign = 2;
        this.hAlign = 2;
    }

    public TableLayoutConstraints(String constraints) {
        block24: {
            this.col1 = 0;
            this.row1 = 0;
            this.col2 = 0;
            this.row2 = 0;
            this.hAlign = 2;
            this.vAlign = 2;
            StringTokenizer st = new StringTokenizer(constraints, ", ");
            int numToken = st.countTokens();
            try {
                if (numToken != 2 && numToken != 4 && numToken != 6) {
                    throw new RuntimeException();
                }
                String tokenA = st.nextToken();
                this.col2 = this.col1 = new Integer(tokenA).intValue();
                String tokenB = st.nextToken();
                this.row2 = this.row1 = new Integer(tokenB).intValue();
                tokenA = st.nextToken();
                tokenB = st.nextToken();
                try {
                    this.col2 = new Integer(tokenA);
                    this.row2 = new Integer(tokenB);
                    tokenA = st.nextToken();
                    tokenB = st.nextToken();
                }
                catch (NumberFormatException error) {
                    this.col2 = this.col1;
                    this.row2 = this.row1;
                }
                if (tokenA.equalsIgnoreCase("L") || tokenA.equalsIgnoreCase("LEFT")) {
                    this.hAlign = 0;
                } else if (tokenA.equalsIgnoreCase("C") || tokenA.equalsIgnoreCase("CENTER")) {
                    this.hAlign = 1;
                } else if (tokenA.equalsIgnoreCase("F") || tokenA.equalsIgnoreCase("FULL")) {
                    this.hAlign = 2;
                } else if (tokenA.equalsIgnoreCase("R") || tokenA.equalsIgnoreCase("RIGHT")) {
                    this.hAlign = 3;
                } else if (tokenA.equalsIgnoreCase("LD") || tokenA.equalsIgnoreCase("LEADING")) {
                    this.hAlign = 4;
                } else if (tokenA.equalsIgnoreCase("TL") || tokenA.equalsIgnoreCase("TRAILING")) {
                    this.hAlign = 5;
                } else {
                    throw new RuntimeException();
                }
                if (tokenB.equalsIgnoreCase("T") || tokenB.equalsIgnoreCase("TOP")) {
                    this.vAlign = 0;
                    break block24;
                }
                if (tokenB.equalsIgnoreCase("C") || tokenB.equalsIgnoreCase("CENTER")) {
                    this.vAlign = 1;
                    break block24;
                }
                if (tokenB.equalsIgnoreCase("F") || tokenB.equalsIgnoreCase("FULL")) {
                    this.vAlign = 2;
                    break block24;
                }
                if (tokenB.equalsIgnoreCase("B") || tokenB.equalsIgnoreCase("BOTTOM")) {
                    this.vAlign = 3;
                    break block24;
                }
                throw new RuntimeException();
            }
            catch (NoSuchElementException tokenA) {
            }
            catch (RuntimeException error) {
                throw new IllegalArgumentException("Expected constraints in one of the following formats:\n  col1, row1\n  col1, row1, col2, row2\n  col1, row1, hAlign, vAlign\n  col1, row1, col2, row2, hAlign, vAlign\nConstraints provided '" + constraints + "'");
            }
        }
        if (this.row2 < this.row1) {
            this.row2 = this.row1;
        }
        if (this.col2 < this.col1) {
            this.col2 = this.col1;
        }
    }

    public TableLayoutConstraints(int col1, int row1, int col2, int row2, int hAlign, int vAlign) {
        this.col1 = col1;
        this.row1 = row1;
        this.col2 = col2;
        this.row2 = row2;
        this.hAlign = hAlign < 0 || hAlign > 3 ? 2 : hAlign;
        this.vAlign = vAlign < 0 || vAlign > 3 ? 2 : vAlign;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.col1);
        buffer.append(", ");
        buffer.append(this.row1);
        buffer.append(", ");
        buffer.append(this.col2);
        buffer.append(", ");
        buffer.append(this.row2);
        buffer.append(", ");
        String[] h = new String[]{"left", "center", "full", "right"};
        String[] v = new String[]{"top", "center", "full", "bottom"};
        buffer.append(h[this.hAlign]);
        buffer.append(", ");
        buffer.append(v[this.vAlign]);
        return buffer.toString();
    }
}

