/*
 * Decompiled with CFR 0.152.
 */
package com.medset.padsy;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PadsyClassLoader
extends URLClassLoader {
    public static final String COM_MEDSET_PADSY_NETPATH = "com.medset.padsy.NetPath";
    private static Logger logger = Logger.getLogger(PadsyClassLoader.class.getName());
    static final String PADSY_EXT_PATH = "JarFiles";
    static ClassLoader loader = null;
    File extPath = null;

    public static ClassLoader getInstance() throws InstantiationException {
        if (loader == null) {
            logger.warning("PadsyClassLoader not initialized. Use default classloader");
            loader = PadsyClassLoader.class.getClassLoader();
        }
        return loader;
    }

    public static ClassLoader createInstance(URL[] urls) throws InstantiationException {
        if (loader == null) {
            loader = new PadsyClassLoader(urls);
        }
        return loader;
    }

    private PadsyClassLoader(URL[] urls) throws InstantiationException {
        super(urls);
        try {
            String netPath = System.getProperty(COM_MEDSET_PADSY_NETPATH);
            this.extPath = netPath != null ? new File(netPath, PADSY_EXT_PATH) : new File(PADSY_EXT_PATH);
            logger.fine("Lese JarFiles Verzeichnis: " + this.extPath.getAbsolutePath());
            if (!this.extPath.exists()) {
                logger.fine("Erzeuge JarFiles Verzeichnis");
                if (!this.extPath.mkdir()) {
                    throw new InstantiationException("Verzeichnis \"" + this.extPath.getPath() + "\" konnte nicht erzeugt werden.");
                }
            } else if (!this.extPath.isDirectory()) {
                throw new InstantiationException("\"" + this.extPath.getPath() + "\" ist kein Verzeichnis");
            }
            File[] jarFiles = this.extPath.listFiles(new JarFileFilter());
            int i = 0;
            while (i < jarFiles.length) {
                URL url = new URL("file:" + this.extPath.getPath() + "/" + jarFiles[i].getName());
                logger.fine(String.valueOf(String.valueOf(i)) + ". Ext: " + url);
                this.addURL(url);
                ++i;
            }
        }
        catch (Exception e) {
            throw new InstantiationException("Fehler beim initialisieren des ClassLoaders: " + e.getMessage());
        }
    }

    public void installNewUrl(String jarFileName, byte[] jarFileData) throws Exception {
        try {
            File newJarFile = new File(String.valueOf(this.extPath.getPath()) + File.separator + jarFileName);
            if (newJarFile.exists()) {
                logger.log(Level.WARNING, "Jar Datei ist bereits installiert wird aber \u00fcberschrieben");
            }
            FileOutputStream fOut = new FileOutputStream(newJarFile);
            fOut.write(jarFileData);
            fOut.close();
            URL url = new URL("file:" + this.extPath.getPath() + "/" + newJarFile.getName());
            logger.fine("Install: " + url);
            this.addURL(url);
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Fehler beim installieren eines neuen Archives: " + jarFileName);
        }
        catch (FileNotFoundException e) {
            throw new InstantiationException("Fehler beim installieren eines neuen Archives: " + jarFileName);
        }
        catch (IOException e) {
            throw new InstantiationException("Fehler beim installieren eines neuen Archives: " + e.getMessage());
        }
    }

    public void loadNewUrl(String jarFileName) throws InstantiationException {
        try {
            File newJarFile = new File(String.valueOf(this.extPath.getPath()) + File.separator + jarFileName);
            URL url = new URL("file:" + this.extPath.getPath() + "/" + newJarFile.getName());
            logger.fine("Install: " + url);
            this.addURL(url);
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Fehler beim installieren eines neuen Archives: " + jarFileName);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String newName = name;
        try {
            newName = name.replace('\\', '/');
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getResourceAsStream(newName);
    }

    class JarFileFilter
    implements FileFilter {
        JarFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            int dot;
            boolean retval = false;
            String name = pathname.getName().toUpperCase();
            String extention = name.substring((dot = name.lastIndexOf(46)) + 1);
            if (extention.equals("JAR")) {
                retval = true;
            }
            return retval;
        }
    }
}

