/*
 * Decompiled with CFR 0.152.
 */
package com.medset.padsy;

import com.kitfox.svg.app.beans.SVGIcon;
import com.medset.padsy.PadsyClassLoader;
import java.awt.Dimension;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PadsyImages {
    private static Logger logger = Logger.getLogger(PadsyImages.class.getName());
    private static ImageIcon defaultImageIcon = PadsyImages.createImageIcon("defaultimage.gif");
    private static Hashtable<String, ImageIcon> imageTable = new Hashtable();

    public static ImageIcon getImageIcon(String name) {
        ImageIcon retval = imageTable.get(name);
        if (retval == null) {
            retval = PadsyImages.createImageIcon(name);
            if (retval == null) {
                retval = defaultImageIcon;
            } else {
                imageTable.put(name, retval);
            }
        }
        return retval;
    }

    public static Icon getScaledImageIcon(String name, int width, int height) {
        return PadsyImages.getScaledImageIcon(name, false, width, height);
    }

    public static Icon getScaledImageIcon(String path, boolean useFullPath, int width, int height) {
        String fullPath = "";
        fullPath = useFullPath ? path : "com/medset/resources/images/" + path;
        ImageIcon retval = null;
        try {
            SVGIcon svgIcon = new SVGIcon();
            svgIcon.setSvgURI(PadsyImages.getURL(fullPath).toURI());
            svgIcon.setAntiAlias(true);
            svgIcon.setPreferredSize(new Dimension(width, height));
            svgIcon.setScaleToFit(true);
            retval = svgIcon;
        }
        catch (Exception e) {
            logger.warning("Image: " + fullPath + " not found");
            retval = defaultImageIcon;
        }
        return retval;
    }

    private static URL getURL(String path) {
        URL retval = null;
        try {
            retval = PadsyClassLoader.getInstance().getResource(path);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Image: " + path + " not found", e);
        }
        return retval;
    }

    private static ImageIcon createImageIcon(String filename) {
        ImageIcon retval = null;
        URL url = PadsyImages.getURL("com/medset/resources/images/" + filename);
        if (url != null) {
            retval = new ImageIcon(url);
        } else {
            logger.warning("Image: " + filename + " not found");
        }
        return retval;
    }
}

