/*
 * Decompiled with CFR 0.152.
 */
package com.medset.padsy;

import com.medset.PadsyStarter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class PadsyLogManager {
    public static final String CONSOLE_LOGGING_KEY = "com.medset.padsy.logger.console";
    private static final String LOGFILE_PATTERN = String.valueOf(PadsyStarter.getPadsyIoPath()) + File.separator + "Log" + File.separator + "Padsy%g.log";
    private static final String LIMIT_KEY = "limit";
    private static final String LIMIT_DEFAULT = String.valueOf(51200);
    private static final String COUNT_KEY = "count";
    private static final String COUNT_DEFAULT = "5";
    private static final String LEVEL_KEY = "level";
    private static final String LEVEL_DEFAULT = "INFO";
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    private static final PadsyLogManager logManager = new PadsyLogManager();
    private Logger padsyLogger;
    private Logger rootLogger;
    private Properties logProperties;
    private FileHandler fileHandler;
    private ConsoleHandler consoleHandler;

    private PadsyLogManager() {
        block2: {
            this.logProperties = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(LOGGING_PROPERTIES_FILE);
                this.logProperties.loadFromXML(inputStream);
                inputStream.close();
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) break block2;
                System.err.println("Can't read logging properties: " + e.getMessage());
            }
        }
        this.init();
    }

    public static PadsyLogManager getInstance() {
        return logManager;
    }

    private void init() {
        this.padsyLogger = Logger.getLogger("com.medset");
        this.rootLogger = this.padsyLogger.getParent();
        Handler[] handlers = this.rootLogger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            this.rootLogger.removeHandler(handlers[i]);
            ++i;
        }
        if (Boolean.getBoolean(CONSOLE_LOGGING_KEY)) {
            this.initConsoleHandler();
        } else {
            this.initFileHandler();
        }
    }

    private void initConsoleHandler() {
        try {
            if (this.consoleHandler != null) {
                this.rootLogger.removeHandler(this.consoleHandler);
                this.consoleHandler.close();
                this.consoleHandler = null;
            }
            this.consoleHandler = new ConsoleHandler();
            this.padsyLogger.setLevel(Level.parse(this.getLevel()));
            this.consoleHandler.setFormatter(new SimpleFormatter());
            this.rootLogger.addHandler(this.consoleHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initFileHandler() {
        try {
            if (this.fileHandler != null) {
                this.rootLogger.removeHandler(this.fileHandler);
                this.fileHandler.close();
                this.fileHandler = null;
            }
            this.fileHandler = new FileHandler(LOGFILE_PATTERN, this.getLimit(), this.getCount());
            this.padsyLogger.setLevel(Level.parse(this.getLevel()));
            this.fileHandler.setFormatter(new SimpleFormatter());
            this.rootLogger.addHandler(this.fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLimit() {
        return Integer.parseInt(this.logProperties.getProperty(LIMIT_KEY, LIMIT_DEFAULT));
    }

    public void setLimit(int limit) {
        if (limit != this.getLimit()) {
            this.logProperties.setProperty(LIMIT_KEY, String.valueOf(limit));
            this.save();
            this.initFileHandler();
        }
    }

    public String getLevel() {
        return this.logProperties.getProperty(LEVEL_KEY, LEVEL_DEFAULT);
    }

    public void setLevel(String level) {
        if (level != null && level.compareTo(this.getLevel()) != 0) {
            this.logProperties.setProperty(LEVEL_KEY, level);
            this.save();
            this.padsyLogger.setLevel(Level.parse(level));
        }
    }

    public int getCount() {
        return Integer.parseInt(this.logProperties.getProperty(COUNT_KEY, COUNT_DEFAULT));
    }

    public void setCount(int count) {
        if (count != this.getCount()) {
            this.logProperties.setProperty(COUNT_KEY, String.valueOf(count));
            this.save();
            this.initFileHandler();
        }
    }

    private void save() {
        try {
            FileOutputStream outputStream = new FileOutputStream(LOGGING_PROPERTIES_FILE);
            this.logProperties.storeToXML(outputStream, "PADSY logfile properties");
            outputStream.close();
        }
        catch (Exception e) {
            System.err.println("Can't write logging properties: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        PadsyLogManager plm = PadsyLogManager.getInstance();
        Logger logger = Logger.getLogger("com.medset.test");
        logger.finest("finest");
        logger.finer("finer");
        logger.fine("fine");
        logger.info("info");
        logger.warning("warning");
        logger.severe("severe");
        plm.setLevel(Level.WARNING.getName());
        logger.finest("finest");
        logger.finer("finer");
        logger.fine("fine");
        logger.info("info");
        logger.warning("warning");
        logger.severe("severe");
        plm.setCount(2);
        logger.finest("finest");
        logger.finer("finer");
        logger.fine("fine");
        logger.info("info");
        logger.warning("warning");
        logger.severe("severe");
        plm.setLimit(100);
        logger.finest("finest");
        logger.finer("finer");
        logger.fine("fine");
        logger.info("info");
        logger.warning("warning");
        logger.severe("severe");
    }
}

