/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.MedsetColor;
import com.medset.graphics.NeuLookAndFeel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonUI;

public class PadsyButtonUI
extends MetalButtonUI {
    public static final String NO_GRADIENT_PAINT = "NoGradientPaint";
    private Color col1 = new Color(255, 255, 255, 0);
    private Color col2 = new Color(255, 255, 255, 128);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);
    private static final Color VERLAUF_HELL = new Color(255, 255, 255);
    private static final Color VERLAUF_DUNKEL = new Color(109, 169, 194);
    private static final Color VERLAUF_DEFAULT_DUNKEL = new Color(167, 210, 129);
    private static Color DISABLE_COLOR = new Color(204, 204, 204);
    private static final PadsyButtonUI buttonUI = new PadsyButtonUI();
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");

    public static ComponentUI createUI(JComponent c) {
        return buttonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!b.isSelected()) {
            b.setOpaque(false);
        }
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        boolean retval = false;
        retval = new RoundRectangle2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1, c.getHeight() + 2, c.getHeight() - 1).contains(x, y);
        return retval;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (model.isEnabled()) {
            if (model.isSelected() || model.isPressed() && model.isArmed()) {
                g.setColor(MedsetColor.SELECTBACK);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            } else {
                if (c instanceof NeuLookAndFeel) {
                    g.setColor(b.getForeground());
                } else {
                    g.setColor(model.isRollover() ? MedsetColor.SELECTBACK : b.getForeground());
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        } else {
            g.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean gradientPaint;
        Graphics2D g2D = (Graphics2D)g;
        AbstractButton b = (AbstractButton)c;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Action action = b.getAction();
        boolean bl = gradientPaint = action == null || action.getValue(NO_GRADIENT_PAINT) == null;
        if (!b.getModel().isEnabled() && gradientPaint && !NO_3D_BUTTONS) {
            g2D.setColor(DISABLE_COLOR);
            RoundRectangle2D.Double rec1 = new RoundRectangle2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1, c.getHeight() + 2, c.getHeight() - 1);
            g2D.fill(rec1);
        }
        if (!(c instanceof NeuLookAndFeel)) {
            super.paint(g, c);
        }
        if (gradientPaint && (b.getText() != null && b.getText().length() > 0 || b.getIcon() != null)) {
            GradientPaint gradient1;
            if (c instanceof NeuLookAndFeel) {
                if (b.getModel().isPressed() && b.getModel().isArmed()) {
                    gradient1 = b instanceof JButton && ((JButton)b).isDefaultButton() ? new GradientPaint(0.0f, 0.0f, VERLAUF_DEFAULT_DUNKEL, c.getWidth() / 2, 0.0f, VERLAUF_HELL, true) : new GradientPaint(0.0f, 0.0f, VERLAUF_DUNKEL, c.getWidth() / 2, 0.0f, VERLAUF_HELL, true);
                    RoundRectangle2D.Double rec1 = new RoundRectangle2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1, c.getHeight() + 2, c.getHeight() - 1);
                    g2D.setPaint(gradient1);
                    g2D.fill(rec1);
                } else if (b.getModel().isEnabled()) {
                    gradient1 = b instanceof JButton && ((JButton)b).isDefaultButton() ? new GradientPaint(0.0f, 0.0f, VERLAUF_HELL, 0.0f, c.getHeight(), VERLAUF_DEFAULT_DUNKEL) : new GradientPaint(0.0f, 0.0f, VERLAUF_HELL, 0.0f, c.getHeight(), VERLAUF_DUNKEL);
                    RoundRectangle2D.Double rec1 = new RoundRectangle2D.Double(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1, c.getHeight() + 2, c.getHeight() - 1);
                    g2D.setPaint(gradient1);
                    g2D.fill(rec1);
                }
            } else if (!NO_3D_BUTTONS) {
                if (b.getModel().isPressed()) {
                    gradient1 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col3, 0.0f, 0.0f, this.col4);
                    Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
                    g2D.setPaint(gradient1);
                    g2D.fill(rec1);
                    GradientPaint gradient2 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col1, 0.0f, c.getHeight(), this.col2);
                    Rectangle rec2 = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight());
                    g2D.setPaint(gradient2);
                    g2D.fill(rec2);
                } else if (b.getModel().isEnabled()) {
                    gradient1 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col1, 0.0f, 0.0f, this.col2);
                    Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
                    g2D.setPaint(gradient1);
                    g2D.fill(rec1);
                    GradientPaint gradient2 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col3, 0.0f, c.getHeight(), this.col4);
                    Rectangle rec2 = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight());
                    g2D.setPaint(gradient2);
                    g2D.fill(rec2);
                }
            }
        }
        if (c instanceof NeuLookAndFeel) {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }
}

