/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class PadsyComboBoxEditor
extends BasicComboBoxEditor {
    @Override
    protected JTextField createEditorComponent() {
        ComboBoxTextField editor = new ComboBoxTextField();
        return editor;
    }

    public class ComboBoxTextField
    extends JTextField {
        private static final long serialVersionUID = 0L;
        final String EMPTY_STRING = "";
        final Color TEXT_SELECTION_COLOR = new Color(224, 239, 206);
        protected String initTextValue = "";
        private ComboBoxTextFieldDecorator decorator = null;

        public ComboBoxTextField() {
            this.decorator = new ComboBoxTextFieldDecorator(this);
            this.decorator.setBackground();
            this.setSelectionColor(this.TEXT_SELECTION_COLOR);
        }

        public void initText(String value) {
            this.updateForeground();
            if (value == null) {
                value = "";
            }
            this.initTextValue = value;
            this.setText(value);
        }

        public void initText(int value) {
            this.initText(String.valueOf(value));
        }

        public int getTextAsInt() {
            int retval = 0;
            try {
                retval = Integer.parseInt(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return retval;
        }

        public boolean hasChanged() {
            return !this.initTextValue.equals(this.getText());
        }

        protected void updateForeground() {
            this.decorator.setForeground();
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            if (e.getID() == 1004) {
                this.decorator.setFocus(true);
                if (this.isEditable()) {
                    this.setCaretPosition(this.getText().length());
                }
                this.decorator.setBackground();
                this.decorator.setForeground();
            } else if (e.getID() == 1005) {
                this.decorator.setFocus(false);
                this.decorator.setBackground();
                this.updateForeground();
                this.setCaretColor(null);
            }
            super.processFocusEvent(e);
        }

        public boolean isGradientPaint() {
            return !this.decorator.isNewStyle();
        }
    }

    class ComboBoxTextFieldDecorator {
        private Color foregroundColor = null;
        private Color normalBackground;
        private Color focusBackground;
        private Color normalForeground;
        private Color focusForeground;
        private NewStileBorder newStyleBorder1;
        private NewStileBorder newStyleBorder2;
        private JTextField textField;
        protected boolean focusGained = false;

        public ComboBoxTextFieldDecorator(JTextField textField) {
            this.textField = textField;
            this.setBorders();
        }

        public void setFocus(boolean focus) {
            this.focusGained = focus;
            if (this.focusGained) {
                this.textField.setBorder(this.newStyleBorder2);
            } else {
                this.textField.setBorder(this.newStyleBorder1);
            }
            this.textField.getParent().repaint();
        }

        private void setBorders() {
            this.normalBackground = this.textField.getBackground();
            this.focusBackground = this.textField.getBackground();
            this.normalForeground = this.textField.getForeground();
            this.focusForeground = this.textField.getForeground();
            this.newStyleBorder1 = new NewStileBorder(new Color(199, 225, 178), new Color(204, 204, 204));
            this.newStyleBorder2 = new NewStileBorder(new Color(199, 225, 178), new Color(204, 204, 204));
            this.textField.setBorder(this.newStyleBorder1);
        }

        public void setBackground() {
            if (this.focusGained) {
                this.textField.setBackground(this.focusBackground);
            } else {
                this.textField.setBackground(this.normalBackground);
            }
        }

        public void setForeground() {
            if (this.focusGained) {
                this.textField.setForeground(this.focusForeground);
                this.textField.setCaretColor(this.focusForeground);
            } else if (this.foregroundColor != null) {
                this.textField.setForeground(this.foregroundColor);
                this.textField.setCaretColor(this.focusForeground);
            } else {
                this.textField.setForeground(this.normalForeground);
                this.textField.setCaretColor(this.focusForeground);
            }
        }

        public boolean isNewStyle() {
            return true;
        }

        protected JTextField getTextField() {
            return this.textField;
        }

        protected Color getNormalBackground() {
            return this.normalBackground;
        }

        protected Color getNormalForeground() {
            return this.normalForeground;
        }

        protected Color getFocusBackground() {
            return this.focusBackground;
        }

        protected Color getFocusForeground() {
            return this.focusForeground;
        }

        public Border getBorder1() {
            return this.newStyleBorder1;
        }

        public Border getBorder2() {
            return this.newStyleBorder2;
        }

        class NewStileBorder
        extends AbstractBorder {
            private static final long serialVersionUID = -7947353886479692961L;
            protected Color lineColor;
            private Color focusColor;

            public NewStileBorder(Color focusColor, Color color) {
                this.focusColor = focusColor;
                this.lineColor = color;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color oldColor = g.getColor();
                if (ComboBoxTextFieldDecorator.this.focusGained) {
                    g.setColor(this.focusColor);
                    g.drawLine(x, height - 2, width, height - 2);
                    g.drawLine(x, height - 1, width, height - 1);
                } else {
                    g.setColor(this.lineColor);
                    g.drawLine(x, height - 1, width, height - 1);
                }
                g.setColor(oldColor);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 0, 2, 0);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
                insets.bottom = 2;
                return insets;
            }

            public Color getLineColor() {
                return this.lineColor;
            }
        }
    }
}

