/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.plaf.PadsyComboBoxEditor;
import com.medset.plaf.SimpleArrowButton;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class PadsyComboBoxUI
extends BasicComboBoxUI {
    private static final Color FOCUS_COLOR = new Color(199, 225, 178);
    private static final Color NORMAL_COLOR = new Color(204, 204, 204);

    @Override
    protected JButton createArrowButton() {
        SimpleArrowButton button = new SimpleArrowButton(5);
        button.setBorder(null);
        button.setOpaque(false);
        return button;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.comboBox.isEnabled()) {
            if (c.hasFocus() || this.comboBox.getEditor().getEditorComponent().hasFocus()) {
                g2d.setColor(FOCUS_COLOR);
                g2d.drawRect(0, c.getHeight() - 2, c.getWidth(), 1);
            } else {
                g2d.setColor(NORMAL_COLOR);
                g2d.drawLine(0, c.getHeight() - 1, c.getWidth(), c.getHeight() - 1);
            }
            g2d.setColor(Color.BLACK);
        } else {
            g2d.setColor(Color.LIGHT_GRAY);
        }
        if (this.comboBox.getSelectedItem() != null) {
            String value = this.comboBox.getSelectedItem().toString();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setFont(this.comboBox.getFont());
            if (this.comboBox.isEditable()) {
                g2d.setClip(this.getInsets().left, c.getHeight() - this.getInsets().bottom - 6, c.getWidth() - this.getInsets().left - this.getInsets().right, c.getHeight());
            }
            g2d.drawString(value, this.getInsets().left, c.getHeight() - this.getInsets().bottom - 6);
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setOpaque(false);
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new PadsyComboBoxEditor();
    }
}

