/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class PadsyListUI
extends BasicListUI {
    private boolean isToolkitTrueColor = false;
    private Color colBg;
    private Color col1;
    private Color col2;
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");
    private int shadow = 48;

    public PadsyListUI(JComponent list) {
        this.isToolkitTrueColor = this.isToolkitTrueColor(list);
    }

    public static ComponentUI createUI(JComponent list) {
        return new PadsyListUI(list);
    }

    private boolean isToolkitTrueColor(Component c) {
        int pixelsize = c.getToolkit().getColorModel().getPixelSize();
        return pixelsize >= 24;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.maybeUpdateLayoutState();
        if (c.isOpaque()) {
            Graphics2D g2D = (Graphics2D)g;
            this.colBg = c.getBackground();
            int red = this.colBg.getRed();
            int green = this.colBg.getGreen();
            int blue = this.colBg.getBlue();
            g2D.setColor(this.colBg);
            g2D.fill(g.getClipBounds());
            this.col1 = new Color(red >= this.shadow ? red - this.shadow : 0, green >= this.shadow ? green - this.shadow : 0, blue >= this.shadow ? blue - this.shadow : 0);
            this.col2 = PadsyListUI.getTranslucentColor(this.col1, 0);
            Rectangle cb = g.getClipBounds();
            if (!NO_3D_BUTTONS) {
                if (this.isToolkitTrueColor) {
                    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.colBg, 0.0f, this.list.getHeight(), new Color(224, 224, 224));
                    g2D.setPaint(gradient);
                    g2D.fill(cb);
                } else {
                    g2D.setColor(this.colBg);
                    g2D.fill(cb);
                    GradientPaint gradientTop = new GradientPaint(0.0f, 0.0f, this.col1, 0.0f, 5.0f, this.col2);
                    g2D.setPaint(gradientTop);
                    g2D.fill(new Rectangle(cb.x, cb.y, cb.width, 20));
                    GradientPaint gradientLeft = new GradientPaint(0.0f, 0.0f, this.col1, 5.0f, 0.0f, this.col2);
                    g2D.setPaint(gradientLeft);
                    g2D.fill(new Rectangle(cb.x, cb.y, 20, cb.height));
                }
            }
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paint(g, c);
    }

    private static Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        this.updateLayoutStateNeeded = 768;
        return super.getPreferredSize(c);
    }
}

