/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.medset.plaf.PadsyTheme;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class PadsyLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = 4373455995402713602L;
    boolean themeInited = false;

    @Override
    public String getID() {
        return "Padsy";
    }

    @Override
    public String getName() {
        return "Padsy";
    }

    @Override
    public String getDescription() {
        return "Look and Feel for Padsy. Developed by Medset GmbH, 2001.";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TextFieldUI");
        this.putDefault(table, "PasswordFieldUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "MenuUI");
        this.putDefault(table, "ScrollBarUI");
        this.putDefault(table, "TableUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "CheckBoxUI");
        this.putDefault(table, "LabelUI");
        this.putDefault(table, "ProgressBarUI");
        this.putDefault(table, "OptionPaneUI");
        this.putDefault(table, "RootPaneUI");
        LookAndFeelFactory.addUIDefaultsCustomizer((LookAndFeelFactory.UIDefaultsCustomizer)new LookAndFeelFactory.UIDefaultsCustomizer(){

            public void customize(UIDefaults defaults) {
                defaults.put("DockableFrameUI", "com.medset.plaf.PadsyDockableFrameUI");
                defaults.put("JideTabbedPaneUI", "com.medset.plaf.PadsyDockableTabbedPaneUI");
                defaults.put("JideTabbedPane.tabInsets", new Insets(5, 15, 5, 15));
                defaults.put("JideTabbedPane.contentBorderInsets", new Insets(-1, 0, 1, 1));
                defaults.put("DockingFramework.changeCursor", (Object)true);
                defaults.put("JideTabbedPane.shadow", Color.LIGHT_GRAY);
                defaults.put("JideTabbedPane.darkShadow", Color.GRAY);
                defaults.put("JideSplitPane.dividerSize", (Object)12);
            }
        });
    }

    protected void putDefault(UIDefaults table, String uiKey) {
        String className = "com.medset.plaf.Padsy" + uiKey;
        table.put(uiKey, className);
    }

    @Override
    public UIDefaults getDefaults() {
        if (!this.themeInited) {
            PadsyLookAndFeel.setCurrentTheme(new PadsyTheme());
            this.themeInited = true;
        }
        UIDefaults retval = super.getDefaults();
        return retval;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        table.put("textHighlight", this.getTranslucentColor(PadsyLookAndFeel.getTextHighlightColor(), 128));
    }

    private Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }
}

