/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class PadsyMenuUI
extends BasicMenuUI {
    public static final Color col1 = new Color(197, 227, 239);
    public static final Color col2 = new Color(139, 198, 223);
    public static final Color col3 = new Color(104, 149, 167);
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");

    public static ComponentUI createUI(JComponent x) {
        return new PadsyMenuUI();
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (menuItem instanceof JMenu && menuItem.getParent() instanceof JMenuBar) {
            ButtonModel model = menuItem.getModel();
            if (model.isSelected()) {
                this.paintGradient(g, menuItem, col3, col2, col1);
                g.setColor(Color.BLACK);
            } else {
                this.paintGradient(g, menuItem, col1, col2, col3);
                g.setColor(Color.BLACK);
            }
        } else {
            super.paintBackground(g, menuItem, bgColor);
        }
    }

    private void paintGradient(Graphics g, JMenuItem menuItem, Color col1, Color col2, Color col3) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!NO_3D_BUTTONS) {
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient1 = new GradientPaint(0.0f, (float)menuItem.getHeight() / 2.0f, col2, 0.0f, 0.0f, col1);
            Rectangle rec1 = new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight() / 2);
            g2D.setPaint(gradient1);
            g2D.fill(rec1);
            GradientPaint gradient2 = new GradientPaint(0.0f, (float)menuItem.getHeight() / 2.0f, col2, 0.0f, menuItem.getHeight(), col3);
            Rectangle rec2 = new Rectangle(0, menuItem.getHeight() / 2, menuItem.getWidth(), menuItem.getHeight());
            g2D.setPaint(gradient2);
            g2D.fill(rec2);
        }
    }
}

