/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.NeuLookAndFeel;
import com.medset.graphics.PadsyFont;
import com.medset.graphics.TableLayout;
import com.medset.padsy.PadsyImages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.security.AccessController;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLookup;

public class PadsyOptionPaneUI
extends BasicOptionPaneUI {
    private static final Color DEFAULT_MESSAGE_COLOR = Color.BLACK;
    private static final Font DEFAULT_MESSAGE_FONT = PadsyFont.getBoldFont(18.0f);
    private static final int BOTTOM_SPACE = 0;
    private static final int SPACE = 14;
    private static final int ICON_SIZE = 48;
    private static String newline = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    @Override
    protected Icon getIcon() {
        return super.getIcon();
    }

    @Override
    protected Icon getIconForType(int messageType) {
        Icon retval = null;
        retval = messageType == 0 ? PadsyImages.getScaledImageIcon("svg/icon-error.svg", 48, 48) : (messageType == 2 ? PadsyImages.getScaledImageIcon("svg/icon-warning.svg", 48, 48) : (messageType == 3 ? PadsyImages.getScaledImageIcon("svg/icon-question.svg", 48, 48) : (messageType == 1 ? PadsyImages.getScaledImageIcon("svg/icon-info.svg", 48, 48) : super.getIconForType(messageType))));
        return retval;
    }

    public static ComponentUI createUI(JComponent c) {
        return new PadsyOptionPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installComponents() {
        JOptionPane optionPane = this.getOptionPane();
        TableLayout optionPaneLayout = new TableLayout(new double[]{14.0, -1.0, 14.0}, new double[]{14.0, -1.0, 14.0, -2.0, 0.0});
        if (optionPane != null) {
            optionPane.setLayout(optionPaneLayout);
            optionPane.add((Component)this.createMessageArea(), "1,1");
            optionPane.add((Component)this.createButtonArea(), "1,3");
        }
    }

    @Override
    protected Object[] getButtons() {
        Object[] retval = null;
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            int minimumWidth = Math.max(DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonMinimumWidth", -1), 80);
            if (suppliedOptions == null) {
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                retval = type == 0 ? new OptionPaneButton[]{new OptionPaneButton(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), minimumWidth), new OptionPaneButton(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), minimumWidth)} : (type == 1 ? new OptionPaneButton[]{new OptionPaneButton(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), minimumWidth), new OptionPaneButton(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), minimumWidth), new OptionPaneButton(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), minimumWidth)} : (type == 2 ? new OptionPaneButton[]{new OptionPaneButton(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), minimumWidth), new OptionPaneButton(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), minimumWidth)} : new OptionPaneButton[]{new OptionPaneButton(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), minimumWidth)}));
                this.addActionsListeners(retval);
            } else {
                retval = this.configureSuppliedOptions(suppliedOptions, minimumWidth);
            }
        }
        return retval;
    }

    protected Object[] configureSuppliedOptions(Object[] suppliedOptions, int minimumWidth) {
        Object[] retval = new Object[suppliedOptions.length];
        int i = 0;
        while (i < suppliedOptions.length) {
            Object currentObject = suppliedOptions[i];
            if (currentObject instanceof String) {
                OptionPaneButton optionPaneButton = new OptionPaneButton(currentObject.toString(), i, null, minimumWidth);
                optionPaneButton.addActionListener(this.createButtonActionListener(i));
                retval[i] = optionPaneButton;
            } else if (currentObject instanceof Component) {
                retval[i] = currentObject;
            }
            ++i;
        }
        return retval;
    }

    protected void addActionsListeners(Object[] defaultOptions) {
        int i = 0;
        while (i < defaultOptions.length) {
            ((JButton)defaultOptions[i]).addActionListener(this.createButtonActionListener(i));
            ++i;
        }
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    protected Container createButtonArea() {
        Container createButtonArea = super.createButtonArea();
        createButtonArea.setLayout(new FlowLayout(2, 11, 5));
        return createButtonArea;
    }

    private boolean isCustomComponentWithoutIcon(Object message) {
        return message instanceof JComponent && ((JComponent)message).getName() != null && ((JComponent)message).getName().equals("OptionPane.customMessageAreaWithoutIcon");
    }

    private boolean isCustomMessageArea(Object message) {
        return message instanceof Container && ((Container)message).getName() != null && ((Container)message).getName().equals("OptionPane.customMessageArea");
    }

    @Override
    protected Container createMessageArea() {
        Container retval = new JPanel();
        Object message = this.getMessage();
        if (message != null) {
            retval = this.isCustomMessageArea(message) ? (Container)message : new PadsyMessageArea(super.createMessageArea());
        }
        return retval;
    }

    @Override
    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            if (msg instanceof JScrollPane || msg instanceof JPanel) {
                cons.fill = 1;
                cons.weighty = 1.0;
            } else {
                cons.fill = 2;
            }
            cons.weightx = 1.0;
            container.add((Component)msg, cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            ++cons.gridy;
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            Object[] msgs = (Object[])msg;
            int i = 0;
            while (i < msgs.length) {
                this.addMessageComponents(container, cons, msgs[i], maxll, false);
                ++i;
            }
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg, 0);
            this.configureMessageLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        } else {
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            int nl = -1;
            int nll = 0;
            nl = s.indexOf(newline);
            if (nl >= 0) {
                nll = newline.length();
            } else {
                nl = s.indexOf("\r\n");
                if (nl >= 0) {
                    nll = 2;
                } else {
                    nl = s.indexOf(10);
                    if (nl >= 0) {
                        nll = 1;
                    }
                }
            }
            if (nl >= 0) {
                if (nl == 0) {
                    JPanel breakPanel = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            if (f != null) {
                                return new Dimension(1, f.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    breakPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, cons, breakPanel, maxll, true);
                } else {
                    this.addMessageComponents(container, cons, s.substring(0, nl), maxll, false);
                }
                this.addMessageComponents(container, cons, s.substring(nl + nll), maxll, false);
            } else if (len > maxll) {
                Box c = Box.createVerticalBox();
                c.setName("OptionPane.verticalBox");
                this.burstStringInto(c, s, maxll);
                this.addMessageComponents(container, cons, c, maxll, true);
            } else {
                JLabel label = new JLabel(s, 10);
                label.setName("OptionPane.label");
                this.configureMessageLabel(label);
                this.addMessageComponents(container, cons, label, maxll, true);
            }
        }
    }

    private void configureMessageLabel(JLabel label) {
        Color color = (Color)DefaultLookup.get(this.optionPane, this, "OptionPane.messageForeground");
        if (color == null) {
            color = DEFAULT_MESSAGE_COLOR;
        }
        label.setForeground(color);
        Font messageFont = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.messageFont");
        if (messageFont == null) {
            messageFont = DEFAULT_MESSAGE_FONT;
        }
        label.setFont(messageFont);
    }

    protected JOptionPane getOptionPane() {
        return this.optionPane;
    }

    class OptionPaneButton
    extends JButton
    implements NeuLookAndFeel {
        private static final long serialVersionUID = -5765493427614945533L;
        private int minimumWidth;

        public OptionPaneButton(String text, int mnemonic, Icon icon, int minimumWidth) {
            super(text);
            super.setFont(DEFAULT_MESSAGE_FONT);
            if (minimumWidth > 0) {
                this.minimumWidth = minimumWidth;
            }
            if (icon != null) {
                this.setIcon(icon);
            }
            if (mnemonic != 0) {
                this.setMnemonic(mnemonic);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension min = super.getMinimumSize();
            min.width = Math.max(min.width, this.minimumWidth);
            return min;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            pref.width = Math.max(pref.width, this.minimumWidth);
            return pref;
        }
    }

    class PadsyMessageArea
    extends JPanel {
        private static final long serialVersionUID = -561321990458071842L;

        public PadsyMessageArea(Object message) {
            boolean useIcon = PadsyOptionPaneUI.this.getIcon() != null && PadsyOptionPaneUI.this.isCustomComponentWithoutIcon(message);
            int space = 0;
            int iconSize = 0;
            if (useIcon) {
                space = 24;
                iconSize = 48;
            }
            this.setLayout(new TableLayout(new double[]{iconSize, space, -2.0}, new double[]{iconSize, -2.0}));
            if (useIcon) {
                JLabel iconLabel = new JLabel(PadsyOptionPaneUI.this.getIcon(), 0);
                this.add((Component)iconLabel, "0,0");
            }
            JComponent messageLabel = null;
            if (message instanceof JLabel) {
                messageLabel = (JLabel)message;
                messageLabel.setAlignmentY(0.0f);
                messageLabel.setFont(DEFAULT_MESSAGE_FONT);
            } else if (message instanceof String) {
                messageLabel = new JLabel(message.toString(), 0);
                messageLabel.setFont(DEFAULT_MESSAGE_FONT);
            } else {
                try {
                    messageLabel = (JComponent)message;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (messageLabel != null) {
                this.add((Component)messageLabel, "2, 0, 2, 1");
            }
        }
    }
}

