/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.NeuLookAndFeel;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class PadsyProgressBarUI
extends BasicProgressBarUI {
    private Color col1 = new Color(255, 255, 255, 0);
    private Color col2 = new Color(255, 255, 255, 128);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);
    public static final Color TITLE_BACKGROUND = new Color(219, 237, 245);

    public static ComponentUI createUI(JComponent x) {
        return new PadsyProgressBarUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = (Graphics2D)g;
        if (c instanceof NeuLookAndFeel) {
            if (this.progressBar.isIndeterminate()) {
                this.paintIndeterminate(g, c);
            } else {
                Shape oldClip = g2D.getClip();
                g2D.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight(), c.getHeight(), c.getHeight()));
                GradientPaint gradient1 = new GradientPaint(0.0f, c.getHeight(), Color.WHITE, 0.0f, 0.0f, TITLE_BACKGROUND);
                Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight());
                g2D.setPaint(gradient1);
                g2D.fill(rec1);
                this.paintDeterminate(g2D, c);
                g.setClip(oldClip);
            }
        } else {
            super.paint(g, c);
            GradientPaint gradient1 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col1, 0.0f, 0.0f, this.col2);
            Rectangle rec1 = new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
            g2D.setPaint(gradient1);
            g2D.fill(rec1);
            GradientPaint gradient2 = new GradientPaint(0.0f, (float)c.getHeight() / 2.0f, this.col3, 0.0f, c.getHeight(), this.col4);
            Rectangle rec2 = new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight());
            g2D.setPaint(gradient2);
            g2D.fill(rec2);
        }
    }
}

