/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.plaf.metal.MetalScrollButton;

public class PadsyScrollButton
extends MetalScrollButton {
    private static final long serialVersionUID = 5100407886472909775L;
    private Color col1 = new Color(255, 255, 255, 64);
    private Color col2 = new Color(255, 255, 255, 0);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");

    public PadsyScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rec2;
        Rectangle rec1;
        Point grad2End;
        Point grad2Start;
        Point grad1End;
        Point grad1Start;
        super.paint(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2D = (Graphics2D)g;
        if (this.getDirection() == 3 || this.getDirection() == 7) {
            grad1Start = new Point(1, 1);
            grad2Start = grad1End = new Point(1, height / 2);
            grad2End = new Point(1, height);
            rec1 = new Rectangle(grad1Start, new Dimension(width, height / 2));
            rec2 = new Rectangle(grad2Start, new Dimension(width, height / 2 + 1));
        } else {
            grad1Start = new Point(1, 1);
            grad2Start = grad1End = new Point(width / 2, 1);
            grad2End = new Point(width, 1);
            rec1 = new Rectangle(grad1Start, new Dimension(width / 2, height));
            rec2 = new Rectangle(grad2Start, new Dimension(width / 2 + 1, height));
        }
        if (!NO_3D_BUTTONS) {
            GradientPaint gradient1 = new GradientPaint(grad1Start, this.col1, grad1End, this.col2);
            GradientPaint gradient2 = new GradientPaint(grad2Start, this.col3, grad2End, this.col4);
            g2D.setPaint(gradient1);
            g2D.fill(rec1);
            g2D.setPaint(gradient2);
            g2D.fill(rec2);
        }
    }
}

