/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.plaf.SimpleArrowButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class PadsySimpleComboBoxUI
extends BasicComboBoxUI {
    private static final Logger logger = Logger.getLogger(PadsySimpleComboBoxUI.class.getName());

    @Override
    protected JButton createArrowButton() {
        return new SimpleArrowButton(5);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setOpaque(false);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2D = null;
        try {
            try {
                g2D = (Graphics2D)g.create();
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                FontRenderContext fontRenderContext = g2D.getFontRenderContext();
                Font font = g2D.getFont();
                String selectedItem = (String)this.comboBox.getSelectedItem();
                LineMetrics lineMetrics = font.getLineMetrics(selectedItem, fontRenderContext);
                g2D.setColor(Color.BLACK);
                g2D.drawString(selectedItem, 0.0f, (float)(this.getDisplaySize().height / 2) + lineMetrics.getDescent());
            }
            catch (ClassCastException e) {
                logger.log(Level.INFO, String.valueOf(this.getClass().getSimpleName()) + " can't handle anything than String's as elements.");
                if (g2D != null) {
                    g2D.dispose();
                }
            }
        }
        finally {
            if (g2D != null) {
                g2D.dispose();
            }
        }
    }
}

