/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class PadsyTableUI
extends BasicTableUI {
    public static ComponentUI createUI(JComponent c) {
        return new PadsyTableUI();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        private void setDispatchComponent(MouseEvent e) {
            Component editorComponent = PadsyTableUI.this.table.getEditorComponent();
            Point p = e.getPoint();
            Point p2 = SwingUtilities.convertPoint(PadsyTableUI.this.table, p, editorComponent);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null || !PadsyTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(PadsyTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            PadsyTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
            PadsyTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(flag);
        }

        private boolean shouldIgnore(MouseEvent e) {
            boolean ignore;
            Point p = e.getPoint();
            int row = PadsyTableUI.this.table.rowAtPoint(p);
            boolean bl = ignore = SwingUtilities.isRightMouseButton(e) && PadsyTableUI.this.table.isRowSelected(row);
            return ignore || e.isConsumed() || !PadsyTableUI.this.table.isEnabled();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(e);
        }

        void adjustFocusAndSelection(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = PadsyTableUI.this.table.rowAtPoint(p);
            int column = PadsyTableUI.this.table.columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            if (PadsyTableUI.this.table.editCellAt(row, column, e)) {
                this.setDispatchComponent(e);
                this.repostEvent(e);
            } else if (PadsyTableUI.this.table.isRequestFocusEnabled()) {
                PadsyTableUI.this.table.requestFocus();
            }
            TableCellEditor editor = PadsyTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                boolean adjusting = e.getID() == 501;
                this.setValueIsAdjusting(adjusting);
                PadsyTableUI.this.table.changeSelection(row, column, e.isControlDown(), e.isShiftDown());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(e)) {
                    return;
                }
                this.repostEvent(e);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.shouldIgnore(e)) {
                return;
            }
            this.repostEvent(e);
            TableCellEditor editor = PadsyTableUI.this.table.getCellEditor();
            if (editor == null || editor.shouldSelectCell(e)) {
                Point p = e.getPoint();
                int row = PadsyTableUI.this.table.rowAtPoint(p);
                int column = PadsyTableUI.this.table.columnAtPoint(p);
                if (column == -1 || row == -1) {
                    return;
                }
                PadsyTableUI.this.table.changeSelection(row, column, false, true);
            }
        }
    }
}

