/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.NeuLookAndFeel;
import com.medset.graphics.NeuLookAndFeelTextField;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class PadsyTextFieldUI
extends BasicTextFieldUI {
    private Color col1 = new Color(0, 0, 0, 48);
    private Color col2 = new Color(0, 0, 0, 0);
    private static final boolean NO_3D_BUTTONS = Boolean.getBoolean("com.medset.plaf.no3d");
    protected JComponent myComponent;

    public PadsyTextFieldUI() {
    }

    PadsyTextFieldUI(JComponent c) {
        this.myComponent = c;
    }

    public static ComponentUI createUI(JComponent c) {
        return new PadsyTextFieldUI(c);
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
        if (!NO_3D_BUTTONS && !this.calculatePaintMode()) {
            Rectangle editorRect = this.getVisibleEditorRect();
            Graphics2D g2D = (Graphics2D)g;
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.col1, 0.0f, (float)this.myComponent.getHeight() * 2.0f / 3.0f, this.col2);
            g2D.setPaint(gradient);
            g2D.fill(editorRect);
        }
    }

    protected boolean calculatePaintMode() {
        boolean dontPaint = false;
        if (this.myComponent instanceof NeuLookAndFeelTextField) {
            dontPaint = !((NeuLookAndFeelTextField)((Object)this.myComponent)).isGradientPaint();
        } else {
            Container parent = this.myComponent.getParent();
            if (parent instanceof NeuLookAndFeel && parent instanceof JComboBox) {
                dontPaint = true;
            }
        }
        return dontPaint;
    }
}

