/*
 * Decompiled with CFR 0.152.
 */
package com.medset.plaf;

import com.medset.graphics.MedsetColor;
import com.medset.graphics.NeuLookAndFeel;
import com.medset.graphics.PadsyFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalBorders;

public class PadsyTheme
extends DefaultMetalTheme {
    Font baseFont = PadsyFont.getPlainFont(1.0f);
    private final FontUIResource controlFont;
    private final FontUIResource systemFont = this.controlFont = new FontUIResource(this.baseFont.deriveFont(0, 15.0f));
    private final FontUIResource userFont = this.controlFont;
    private final FontUIResource smallFont = new FontUIResource(this.baseFont.deriveFont(0, 12.0f));
    private final ColorUIResource primary1 = new ColorUIResource(0, 0, 0);
    private final ColorUIResource primary2 = new ColorUIResource(MedsetColor.SELECTBACK);
    private final ColorUIResource primary3 = new ColorUIResource(MedsetColor.MEDSET_NORMAL);

    @Override
    public String getName() {
        return "Padsy Theme";
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.controlFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.systemFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.userFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.controlFont;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.controlFont;
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.smallFont;
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        table.put("Tree.leftChildIndent", new Integer(4));
        table.put("Tree.rightChildIndent", new Integer(10));
        table.put("Button.background", new ColorUIResource(new Color(255, 255, 255, 0)));
        table.put("Button.select", this.primary2);
        table.put("Button.border", new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(new MetalBorders.ButtonBorder()), new MarginBorder()));
        table.put("Button.textShiftOffset", new Integer(2));
        table.put("Button.rollover", Boolean.TRUE);
        table.put("ToolBar.isRollover", new Boolean(true));
        table.put("ToolBar.rolloverBorder", new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(new MetalBorders.ButtonBorder()), new MarginBorder()));
        table.put("ToolBar.nonrolloverBorder", new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(new MetalBorders.ButtonBorder()), new MarginBorder()));
        table.put("ToggleButton.background", this.primary3);
        table.put("ToggleButton.select", this.primary2);
        table.put("TabbedPane.foreground", new ColorUIResource(255, 255, 255));
        table.put("TabbedPane.font", new FontUIResource(this.baseFont.deriveFont(19.0f)));
        table.put("TabbedPane.selected", this.primary2);
        table.put("MenuItem.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("RadioButtonMenuItem.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("CheckBoxMenuItem.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("Menu.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("ComboBox.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("List.selectionBackground", this.primary2);
        table.put("List.selectionForeground", new ColorUIResource(255, 255, 255));
        table.put("ProgressBar.foreground", this.primary2);
        table.put("ScrollBar.thumb", this.primary3);
        table.put("ScrollBar.thumbHighlight", this.primary2);
        table.put("CheckBox.icon", "com.medset.plaf.PadsyCheckBoxIcon");
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 4059959428892115585L;
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);
        private Border oldBorder;

        public ButtonBorder(Border oldBorder) {
            this.oldBorder = oldBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c instanceof NeuLookAndFeel) {
                AbstractButton button = (AbstractButton)c;
                ButtonModel model = button.getModel();
                Graphics2D g2d = (Graphics2D)g;
                int offset = 0;
                if (model.isEnabled()) {
                    boolean isDefault;
                    boolean bl = isDefault = button instanceof JButton && ((JButton)button).isDefaultButton();
                    if (isDefault) {
                        g.setColor(new Color(27, 120, 18));
                    } else {
                        g.setColor(MedsetColor.SELECTBACK);
                    }
                    if (model.isRollover()) {
                        g2d.setStroke(new BasicStroke(2.0f));
                        offset = 1;
                    }
                } else {
                    g.setColor(Color.GRAY);
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.draw(new RoundRectangle2D.Double(x, y, w - 1 - offset, h - 1 - offset, h + 2, h - 1));
            } else {
                this.oldBorder.paintBorder(c, g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ButtonBorder.borderInsets.top;
            newInsets.left = ButtonBorder.borderInsets.left;
            newInsets.bottom = ButtonBorder.borderInsets.bottom;
            newInsets.right = ButtonBorder.borderInsets.right;
            return newInsets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 6415923174847558155L;

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            AbstractButton b;
            Insets margin = null;
            if (c instanceof AbstractButton && (b = (AbstractButton)c).getText() != null && b.getText().length() > 0) {
                margin = b.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }
    }

    static class MedsetButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 231647997503838754L;
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;
        protected Color sel_shadow;
        protected Color sel_darkShadow;
        protected Color sel_highlight;
        protected Color sel_lightHighlight;

        public MedsetButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight, Color sel_shadow, Color sel_darkShadow, Color sel_highlight, Color sel_lightHighlight) {
            this.shadow = shadow;
            this.darkShadow = darkShadow;
            this.highlight = highlight;
            this.lightHighlight = lightHighlight;
            this.sel_shadow = sel_shadow;
            this.sel_darkShadow = sel_darkShadow;
            this.sel_highlight = sel_highlight;
            this.sel_lightHighlight = sel_lightHighlight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean isPressed = false;
            boolean isDefault = false;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                boolean bl = isPressed = model.isPressed() && model.isArmed();
                if (c instanceof JButton) {
                    isDefault = ((JButton)c).isDefaultButton();
                }
            }
            if (isPressed) {
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, isDefault, this.sel_shadow, this.sel_darkShadow, this.sel_highlight, this.sel_lightHighlight);
            } else {
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, isDefault, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 3, 3, 3);
        }
    }
}

